/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.SunCCCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.ErrorManager;

class SunCCCompiler
extends SunCCCCompiler {
    protected SunCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public SunCCCompiler createCopy(CompilerFlavor flavor) {
        SunCCCompiler copy = new SunCCCompiler(this.getExecutionEnvironment(), flavor, this.getKind(), this.getName(), this.getDisplayName(), this.getPath());
        if (this.isReady()) {
            copy.copySystemIncludeDirectories(this.getSystemIncludeDirectories());
            copy.copySystemPreprocessorSymbols(this.getSystemPreprocessorSymbols());
        }
        return copy;
    }

    public static SunCCCompiler create(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        return new SunCCCompiler(env, flavor, kind, name, displayName, path);
    }

    @Override
    public ToolchainManager.CompilerDescriptor getDescriptor() {
        return this.getFlavor().getToolchainDescriptor().getCpp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void parseCompilerOutput(BufferedReader reader, CCCCompiler.Pair pair) {
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    reader.close();
                    return;
                }
                for (String token : this.getSystemPaths(line)) {
                    SunCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(token));
                    if (!token.endsWith("Cstd")) continue;
                    SunCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(token.substring(0, token.length() - 4) + "std"));
                }
                this.parseUserMacros(line, pair.systemPreprocessorSymbolsList);
                if (!line.startsWith("#define ")) continue;
                int sepIdx = -1;
                int parCount = 0;
                block9: for (int i = 8; i < line.length(); ++i) {
                    switch (line.charAt(i)) {
                        case '(': {
                            ++parCount;
                            break;
                        }
                        case ')': {
                            --parCount;
                            break;
                        }
                        case ' ': {
                            if (parCount != 0) break;
                            sepIdx = i;
                            break block9;
                        }
                    }
                }
                if (sepIdx <= 0) continue;
                String token = line.substring(8, sepIdx) + "=" + line.substring(sepIdx + 1);
                SunCCCompiler.addUnique(pair.systemPreprocessorSymbolsList, token);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }
}

