/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.GNUCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

final class MsvcCompiler
extends GNUCCompiler {
    protected MsvcCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public MsvcCompiler createCopy(CompilerFlavor flavor) {
        MsvcCompiler copy = new MsvcCompiler(this.getExecutionEnvironment(), flavor, this.getKind(), this.getName(), this.getDisplayName(), this.getPath());
        if (this.isReady()) {
            copy.copySystemIncludeDirectories(this.getSystemIncludeDirectories());
            copy.copySystemPreprocessorSymbols(this.getSystemPreprocessorSymbols());
        }
        return copy;
    }

    public static MsvcCompiler create(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        return new MsvcCompiler(env, flavor, kind, name, displayName, path);
    }

    @Override
    public ToolchainManager.CompilerDescriptor getDescriptor() {
        if (this.getKind() == PredefinedToolKind.CCCompiler) {
            return this.getFlavor().getToolchainDescriptor().getCpp();
        }
        return this.getFlavor().getToolchainDescriptor().getC();
    }

    @Override
    protected CCCCompiler.Pair getFreshSystemIncludesAndDefines() {
        String list;
        CCCCompiler.Pair res = new CCCCompiler.Pair();
        List<ToolchainManager.PredefinedMacro> pm = this.getDescriptor().getPredefinedMacros();
        if (pm != null) {
            for (ToolchainManager.PredefinedMacro macro : pm) {
                if (macro.getFlags() != null) continue;
                res.systemPreprocessorSymbolsList.add(macro.getMacro());
            }
        }
        if ((list = System.getenv("INCLUDE")) != null) {
            StringTokenizer st = new StringTokenizer(list, ";");
            while (st.hasMoreTokens()) {
                res.systemIncludeDirectoriesList.add(st.nextToken());
            }
        }
        return res;
    }

    @Override
    protected String getUniqueID() {
        return "" + this.getKind() + super.getUniqueID();
    }
}

