/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.OutputListener;

public abstract class ErrorParserProvider {
    public static final Result NO_RESULT = new NoResult();
    public static final Result REMOVE_LINE = new RemoveLine();
    private static final ErrorParserProvider DEFAULT = new DefaultErrorParserProvider();

    public static ErrorParserProvider getDefault() {
        return DEFAULT;
    }

    public abstract ErrorParser getErorParser(Project var1, CompilerFlavor var2, ExecutionEnvironment var3, FileObject var4);

    public abstract String getID();

    private static final class DefaultErrorParserProvider
    extends ErrorParserProvider {
        private final Lookup.Result<ErrorParserProvider> res = Lookup.getDefault().lookupResult(ErrorParserProvider.class);

        DefaultErrorParserProvider() {
        }

        private ErrorParserProvider getService(String id) {
            for (ErrorParserProvider service : this.res.allInstances()) {
                if (!service.getID().equals(id)) continue;
                return service;
            }
            return null;
        }

        @Override
        public ErrorParser getErorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
            ErrorParserProvider provider = this.getService(flavor.getToolchainDescriptor().getScanner().getID());
            if (provider != null) {
                return provider.getErorParser(project, flavor, execEnv, relativeTo);
            }
            return null;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class RemoveLine
    implements Result {
        private RemoveLine() {
        }

        @Override
        public boolean result() {
            return true;
        }

        @Override
        public List<ConvertedLine> converted() {
            return Collections.emptyList();
        }
    }

    private static final class NoResult
    implements Result {
        private NoResult() {
        }

        @Override
        public boolean result() {
            return false;
        }

        @Override
        public List<ConvertedLine> converted() {
            return Collections.emptyList();
        }
    }

    public static final class Results
    implements Result {
        private List<ConvertedLine> result = new ArrayList<ConvertedLine>(1);

        public Results() {
        }

        public Results(String line, OutputListener listener) {
            this.result.add(ConvertedLine.forText((String)line, (OutputListener)listener));
        }

        public void add(String line, OutputListener listener) {
            this.result.add(ConvertedLine.forText((String)line, (OutputListener)listener));
        }

        @Override
        public boolean result() {
            return true;
        }

        @Override
        public List<ConvertedLine> converted() {
            return this.result;
        }
    }

    public static interface Result {
        public boolean result();

        public List<ConvertedLine> converted();
    }

    public static interface ErrorParser {
        public Result handleLine(String var1) throws IOException;
    }
}

