/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class PhpProjectUtils {
    private static final Logger LOGGER = Logger.getLogger(PhpProjectUtils.class.getName());
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.php");

    private PhpProjectUtils() {
    }

    public static PhpProject getPhpProject(Node node) {
        return PhpProjectUtils.getPhpProject(CommandUtils.getFileObject(node));
    }

    public static PhpProject getPhpProject(FileObject fo) {
        assert (fo != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        return (PhpProject)project.getLookup().lookup(PhpProject.class);
    }

    public static void openFile(String path, int line) {
        DataObject dataObject;
        assert (path != null);
        FileObject fileObject = FileUtil.toFileObject((File)new File(path));
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "FileObject not found for {0}", path);
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, "DataObject not found for {0}", path);
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            LOGGER.log(Level.INFO, "LineCookie not found for {0}", path);
            return;
        }
        Line.Set lineSet = lineCookie.getLineSet();
        try {
            final Line currentLine = lineSet.getCurrent(line - 1);
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    currentLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
        catch (IndexOutOfBoundsException exc) {
            LOGGER.log(Level.FINE, null, exc);
        }
    }

    public static SourceGroup[] getSourceGroups(Project phpProject) {
        Sources sources = ProjectUtils.getSources((Project)phpProject);
        return sources.getSourceGroups("PHPSOURCE");
    }

    public static FileObject[] getSourceObjects(Project phpProject) {
        SourceGroup[] groups = PhpProjectUtils.getSourceGroups(phpProject);
        FileObject[] fileObjects = new FileObject[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            fileObjects[i] = groups[i].getRootFolder();
        }
        return fileObjects;
    }

    public static void reformatFile(File file) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        assert (fileObject != null) : "No fileobject for " + file;
        PhpProjectUtils.reformatFile(DataObject.find((FileObject)fileObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformatFile(final DataObject dataObject) throws IOException {
        assert (dataObject != null);
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        assert (ec != null) : "No editorcookie for " + dataObject;
        StyledDocument doc = ec.openDocument();
        assert (doc instanceof BaseDocument);
        final BaseDocument baseDoc = (BaseDocument)doc;
        final Reformat reformat = Reformat.get((Document)baseDoc);
        reformat.lock();
        try {
            baseDoc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        reformat.reformat(0, baseDoc.getLength());
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.INFO, "Cannot reformat file " + dataObject.getName(), ex);
                    }
                }
            });
        }
        finally {
            reformat.unlock();
        }
        PhpProjectUtils.saveFile(dataObject);
    }

    public static void saveFile(DataObject dataObject) {
        assert (dataObject != null);
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
            }
        }
    }

    public static void saveFile(FileObject fileObject) {
        assert (fileObject != null);
        try {
            DataObject dobj = DataObject.find((FileObject)fileObject);
            if (dobj != null) {
                PhpProjectUtils.saveFile(dobj);
            }
        }
        catch (DataObjectNotFoundException donfe) {
            LOGGER.log(Level.SEVERE, donfe.getLocalizedMessage(), donfe);
        }
    }

    public static boolean isVisible(PhpVisibilityQuery phpVisibilityQuery, FileObject fileObject) {
        assert (phpVisibilityQuery != null);
        assert (fileObject != null);
        for (FileObject fo = fileObject; fo != null; fo = fo.getParent()) {
            if (phpVisibilityQuery.isVisible(fo)) continue;
            return false;
        }
        return true;
    }

    public static void logUsage(Class<?> srcClass, String message, List<? extends Object> params) {
        assert (message != null);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params.toArray(new Object[params.size()]));
        }
        USG_LOGGER.log(logRecord);
    }

    public static String getFrameworksForUsage(Collection<PhpFrameworkProvider> frameworks) {
        assert (frameworks != null);
        StringBuilder buffer = new StringBuilder(200);
        for (PhpFrameworkProvider provider : frameworks) {
            if (buffer.length() > 0) {
                buffer.append("|");
            }
            buffer.append(provider.getName());
        }
        return buffer.toString();
    }
}

