/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.ui.options.PhpOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PhpOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String ID = "General";
    private PhpOptionsPanel phpOptionsPanel = null;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile boolean changed;

    public void update() {
        this.phpOptionsPanel.setPhpInterpreter(this.getPhpOptions().getPhpInterpreter());
        this.phpOptionsPanel.setOpenResultInOutputWindow(this.getPhpOptions().isOpenResultInOutputWindow());
        this.phpOptionsPanel.setOpenResultInBrowser(this.getPhpOptions().isOpenResultInBrowser());
        this.phpOptionsPanel.setOpenResultInEditor(this.getPhpOptions().isOpenResultInEditor());
        this.phpOptionsPanel.setDebuggerPort(this.getPhpOptions().getDebuggerPort());
        this.phpOptionsPanel.setDebuggerSessionId(this.getPhpOptions().getDebuggerSessionId());
        this.phpOptionsPanel.setDebuggerStoppedAtTheFirstLine(this.getPhpOptions().isDebuggerStoppedAtTheFirstLine());
        this.phpOptionsPanel.setDebuggerWatchesAndEval(this.getPhpOptions().isDebuggerWatchesAndEval());
        this.changed = false;
    }

    public void applyChanges() {
        this.getPhpOptions().setPhpInterpreter(this.phpOptionsPanel.getPhpInterpreter());
        this.getPhpOptions().setOpenResultInOutputWindow(this.phpOptionsPanel.isOpenResultInOutputWindow());
        this.getPhpOptions().setOpenResultInBrowser(this.phpOptionsPanel.isOpenResultInBrowser());
        this.getPhpOptions().setOpenResultInEditor(this.phpOptionsPanel.isOpenResultInEditor());
        this.getPhpOptions().setDebuggerPort(this.phpOptionsPanel.getDebuggerPort());
        this.getPhpOptions().setDebuggerSessionId(this.phpOptionsPanel.getDebuggerSessionId());
        this.getPhpOptions().setDebuggerStoppedAtTheFirstLine(this.phpOptionsPanel.isDebuggerStoppedAtTheFirstLine());
        this.getPhpOptions().setDebuggerWatchesAndEval(this.phpOptionsPanel.isDebuggerWatchesAndEval());
        this.getPhpOptions().setPhpGlobalIncludePath(this.phpOptionsPanel.getPhpGlobalIncludePath());
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        return this.validateComponent();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.phpOptionsPanel == null) {
            this.phpOptionsPanel = new PhpOptionsPanel();
            this.phpOptionsPanel.addChangeListener(this);
        }
        return this.phpOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PhpOptions.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changed();
    }

    private boolean validateComponent() {
        Integer debuggerPort = this.phpOptionsPanel.getDebuggerPort();
        if (debuggerPort == null || debuggerPort < 1) {
            this.phpOptionsPanel.setError(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_DebuggerInvalidPort"));
            return false;
        }
        String debuggerSessionId = this.phpOptionsPanel.getDebuggerSessionId();
        if (debuggerSessionId == null || debuggerSessionId.trim().length() == 0 || debuggerSessionId.contains(" ")) {
            this.phpOptionsPanel.setError(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_DebuggerInvalidSessionId"));
            return false;
        }
        String warning = PhpInterpreter.validate((String)this.phpOptionsPanel.getPhpInterpreter());
        if (warning != null) {
            this.phpOptionsPanel.setWarning(warning);
            return true;
        }
        this.phpOptionsPanel.setError(" ");
        return true;
    }

    private void changed() {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }
}

