/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsLocalWeb;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsRemoteWeb;
import org.netbeans.modules.php.project.ui.customizer.RunAsScript;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = -5494488817914071L;
    private final ConfigComboBoxModel comboModel;
    private final ConfigManager manager;
    private final RunAsPanel.InsidePanel[] insidePanels;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel runPanel;
    private JSeparator separator;

    public CustomizerRun(PhpProjectProperties properties, ProjectCustomizer.Category category) {
        this.manager = properties.getConfigManager();
        this.insidePanels = new RunAsPanel.InsidePanel[]{new RunAsLocalWeb(properties, this.manager, category), new RunAsRemoteWeb(properties, this.manager, category), new RunAsScript(properties.getProject(), this.manager, category)};
        this.initComponents();
        this.comboModel = new ConfigComboBoxModel();
        this.configCombo.setModel(this.comboModel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configCombo.setSelectedItem(this.manager.currentConfiguration().getName());
    }

    private ConfigManager.Configuration configurationFor(String configName) {
        return this.manager.configurationFor(configName);
    }

    private void selectCurrentItem() {
        ConfigManager.Configuration config = this.manager.currentConfiguration();
        this.configCombo.setSelectedItem(config.getName());
        this.configDel.setEnabled(!config.isDefault());
    }

    private void initComponents() {
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.separator = new JSeparator();
        this.runPanel = new RunAsPanel(this.insidePanels);
        this.setFocusTraversalPolicy(null);
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_Configuration"));
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_New"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configNewActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_Delete"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configDelActionPerformed(evt);
            }
        });
        this.runPanel.setLayout(new CardLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.runPanel, GroupLayout.Alignment.LEADING, -1, 400, Short.MAX_VALUE).addComponent(this.separator, GroupLayout.Alignment.LEADING, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.configLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configCombo, 0, 142, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configDel))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configCombo, -2, -1, -2).addComponent(this.configNew).addComponent(this.configDel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.runPanel, -1, 197, Short.MAX_VALUE).addContainerGap()));
        this.configLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel.AccessibleContext.accessibleName"));
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel.AccessibleContext.accessibleDescription"));
        this.configCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configCombo.AccessibleContext.accessibleName"));
        this.configCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configCombo.AccessibleContext.accessibleDescription"));
        this.configNew.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew.AccessibleContext.accessibleName"));
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew.AccessibleContext.accessibleDescription"));
        this.configDel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDel.AccessibleContext.accessibleName"));
        this.configDel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDel.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.separator.AccessibleContext.accessibleDescription"));
        this.runPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.runPanel.AccessibleContext.accessibleName"));
        this.runPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.runPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.AccessibleContext.accessibleDescription"));
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        this.manager.markAsCurrentConfiguration(config == null || config.length() == 0 ? null : config);
        this.selectCurrentItem();
    }

    private void configNewActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ConfigurationName"), NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CreateNewConfiguration"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.OK_OPTION) {
            String name = d.getInputText();
            if (name.trim().length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"MSG_ConfigurationNameBlank"), 2));
                return;
            }
            String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
            if (this.manager.exists(config)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"MSG_ConfigurationExists", (Object)config), 2));
                return;
            }
            ConfigManager.Configuration cfg = this.manager.createNew(config, name);
            this.comboModel.addElement(config);
            this.manager.markAsCurrentConfiguration(config);
            this.selectCurrentItem();
        }
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        assert (config != null);
        this.comboModel.removeElement(config);
        this.configurationFor(config).delete();
        this.selectCurrentItem();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 21963218553211553L;

        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            String label = CustomizerRun.this.configurationFor(config).getDisplayName();
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class ConfigComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -2086330612256611127L;

        public ConfigComboBoxModel() {
            TreeSet<String> alphaConfigs = new TreeSet<String>(this.getComparator());
            alphaConfigs.addAll(CustomizerRun.this.manager.configurationNames());
            for (String config : alphaConfigs) {
                this.addElement(config);
            }
        }

        private Comparator<String> getComparator() {
            return new Comparator<String>(){
                Collator coll = Collator.getInstance();

                @Override
                public int compare(String s1, String s2) {
                    String lbl1 = CustomizerRun.this.configurationFor(s1).getDisplayName();
                    String lbl2 = CustomizerRun.this.configurationFor(s2).getDisplayName();
                    return this.coll.compare(lbl1, lbl2);
                }
            };
        }
    }
}

