/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.util.NbBundle;

final class SolarisPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php";

    SolarisPhpEnvironment() {
    }

    @Override
    protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
        File varDir;
        ArrayList<PhpEnvironment.DocumentRoot> roots = new ArrayList<PhpEnvironment.DocumentRoot>(2);
        PhpEnvironment.DocumentRoot userPublicHtml = SolarisPhpEnvironment.getUserPublicHtmlDocumentRoot(projectName);
        if (userPublicHtml != null) {
            roots.add(userPublicHtml);
        }
        if (!(varDir = new File("/var/")).isDirectory()) {
            return Collections.emptyList();
        }
        String[] apaches = varDir.list(APACHE_FILENAME_FILTER);
        if (apaches == null || apaches.length == 0) {
            return Collections.emptyList();
        }
        File htDocs = null;
        for (String apache : apaches) {
            htDocs = SolarisPhpEnvironment.findHtDocsDirectory(new File(varDir, apache), null);
            if (htDocs == null) continue;
            String documentRoot = SolarisPhpEnvironment.getFolderName(htDocs, projectName);
            String url = SolarisPhpEnvironment.getDefaultUrl(projectName);
            String hint = NbBundle.getMessage(SolarisPhpEnvironment.class, (String)"TXT_HtDocs");
            roots.add(new PhpEnvironment.DocumentRoot(documentRoot, url, hint, roots.isEmpty() && htDocs.canWrite()));
            break;
        }
        if (!roots.isEmpty()) {
            return roots;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        return SolarisPhpEnvironment.getAllPhpInterpreters(PHP);
    }
}

