/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.spi;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class RemoteConfiguration {
    static final Logger LOGGER = Logger.getLogger(RemoteConfiguration.class.getName());
    static final RequestProcessor KEYRING_ACCESS = new RequestProcessor();
    private final String displayName;
    private final String name;
    final String passwordKey;

    public RemoteConfiguration(ConfigManager.Configuration cfg) {
        this(cfg.getName(), cfg.getDisplayName());
    }

    protected RemoteConfiguration(String name, String displayName) {
        assert (name != null);
        assert (displayName != null);
        this.passwordKey = this.getClass().getName() + "." + name + ".password";
        this.name = name;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.getUrl("");
    }

    public abstract String getUrl(String var1);

    public abstract String getInitialDirectory();

    public boolean saveProperty(String key, String value) {
        return false;
    }

    public void notifyDeleted() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteConfiguration other = (RemoteConfiguration)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [displayName: ");
        sb.append(this.displayName);
        sb.append(", name: ");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }

    protected String readPassword(ConfigManager.Configuration cfg, String key) {
        String oldPassword = cfg.getValue(key, true);
        if (oldPassword != null) {
            return oldPassword;
        }
        String password = this.readPasswordFromKeyring();
        if (password != null) {
            cfg.putValue(key, password, true);
        }
        return password;
    }

    private String readPasswordFromKeyring() {
        try {
            final Future result = KEYRING_ACCESS.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    char[] newPassword = Keyring.read((String)RemoteConfiguration.this.passwordKey);
                    if (newPassword != null) {
                        return new String(newPassword);
                    }
                    return null;
                }
            });
            if (SwingUtilities.isEventDispatchThread() && !result.isDone()) {
                try {
                    result.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    ProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                result.get();
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                        }
                    }, (String)NbBundle.getMessage(RemoteConfiguration.class, (String)"MSG_KeyringAccess"));
                }
            }
            return (String)result.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return null;
    }

    protected void savePassword(final String password, final String type) {
        if (StringUtils.hasText((String)password)) {
            KEYRING_ACCESS.post(new Runnable(){

                @Override
                public void run() {
                    Keyring.save((String)RemoteConfiguration.this.passwordKey, (char[])password.toCharArray(), (String)NbBundle.getMessage(RemoteConfiguration.class, (String)"MSG_PasswordFor", (Object)RemoteConfiguration.this.getDisplayName(), (Object)type));
                }
            });
        } else {
            this.deletePassword();
        }
    }

    protected void deletePassword() {
        KEYRING_ACCESS.post(new Runnable(){

            @Override
            public void run() {
                Keyring.delete((String)RemoteConfiguration.this.passwordKey);
            }
        });
    }

    public static final class Empty
    extends RemoteConfiguration {
        public Empty(String name, String displayName) {
            super(name, displayName);
        }

        @Override
        public String getUrl(String directory) {
            return "";
        }

        @Override
        public String getInitialDirectory() {
            return "/";
        }
    }
}

