/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmFontColorManager;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.openide.util.Cancellable;

public abstract class HighlighterBase
implements CsmFileTaskFactory.PhaseRunner,
CsmFontColorManager.FontColorChangeListener {
    static final boolean MINIMAL = Boolean.getBoolean("cnd.highlighting.minimal");
    private final WeakReference<BaseDocument> weakDoc;
    private final Collection<Cancellable> listeners = new HashSet<Cancellable>();

    public HighlighterBase(Document doc) {
        this.weakDoc = doc instanceof BaseDocument ? new WeakReference<BaseDocument>((BaseDocument)doc) : null;
    }

    protected void init(Document doc) {
        String mimeType = (String)doc.getProperty("mimeType");
        CsmFontColorManager.instance().addListener(mimeType, (CsmFontColorManager.FontColorChangeListener)this);
    }

    protected BaseDocument getDocument() {
        return this.weakDoc != null ? (BaseDocument)this.weakDoc.get() : null;
    }

    public void stateChanged(FontColorProvider provider) {
        this.updateFontColors(provider);
    }

    protected abstract void updateFontColors(FontColorProvider var1);

    protected boolean isCancelled() {
        return Thread.currentThread().isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCancelListener(Cancellable interruptor) {
        Collection<Cancellable> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(interruptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCancelListener(Cancellable interruptor) {
        Collection<Cancellable> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(interruptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Collection<Cancellable> collection = this.listeners;
        synchronized (collection) {
            for (Cancellable interruptor : this.listeners) {
                interruptor.cancel();
            }
        }
    }
}

