/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.constants;

import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantClass;
import com.sun.javacard.classfile.constants.JConstantDouble;
import com.sun.javacard.classfile.constants.JConstantFieldRef;
import com.sun.javacard.classfile.constants.JConstantFloat;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantInterfaceMethodRef;
import com.sun.javacard.classfile.constants.JConstantLong;
import com.sun.javacard.classfile.constants.JConstantMethodRef;
import com.sun.javacard.classfile.constants.JConstantNameAndType;
import com.sun.javacard.classfile.constants.JConstantString;
import com.sun.javacard.classfile.constants.JConstantUtf8;
import java.io.DataInputStream;
import java.io.IOException;

public class JConstantPool {
    private JConstant[] constants;

    public JConstantPool(int n) {
        this.constants = new JConstant[n];
    }

    public JConstant getAt(int n) {
        return this.constants[n];
    }

    public JConstant[] getConstants() {
        return this.constants;
    }

    public JConstantUtf8 getConstantUtf8(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantUtf8) {
            return (JConstantUtf8)jConstant;
        }
        return null;
    }

    public JConstantInteger getConstantInteger(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantInteger) {
            return (JConstantInteger)jConstant;
        }
        return null;
    }

    public JConstantFloat getConstantFloat(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantFloat) {
            return (JConstantFloat)jConstant;
        }
        return null;
    }

    public JConstantLong getConstantLong(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantLong) {
            return (JConstantLong)jConstant;
        }
        return null;
    }

    public JConstantDouble getConstantDouble(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantDouble) {
            return (JConstantDouble)jConstant;
        }
        return null;
    }

    public JConstantClass getConstantClass(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantClass) {
            return (JConstantClass)jConstant;
        }
        return null;
    }

    public JConstantString getConstantString(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantString) {
            return (JConstantString)jConstant;
        }
        return null;
    }

    public JConstantFieldRef getConstantFieldRef(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantFieldRef) {
            return (JConstantFieldRef)jConstant;
        }
        return null;
    }

    public JConstantMethodRef getConstantMethodRef(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantMethodRef) {
            return (JConstantMethodRef)jConstant;
        }
        return null;
    }

    public JConstantInterfaceMethodRef getConstantInterfaceMethodRef(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantInterfaceMethodRef) {
            return (JConstantInterfaceMethodRef)jConstant;
        }
        return null;
    }

    public JConstantNameAndType getConstantNameAndType(int n) {
        JConstant jConstant = this.getAt(n);
        if (jConstant instanceof JConstantNameAndType) {
            return (JConstantNameAndType)jConstant;
        }
        return null;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        for (int i = 1; i < this.constants.length; ++i) {
            int n = dataInputStream.readUnsignedByte();
            this.constants[i] = JConstant.create(n, this);
            this.constants[i].parse(dataInputStream);
            if (n != 6 && n != 5) continue;
            ++i;
        }
    }

    public void resolve() {
        for (int i = 1; i < this.constants.length; ++i) {
            if (this.constants[i] == null) continue;
            this.constants[i].resolve();
        }
    }
}

