/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.stats;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.CompositeCPUCCTWalker;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.ui.stats.ProjectAwareStatisticalModule;
import org.openide.util.NbBundle;

public class HttpRequestTrackerPanel
extends ProjectAwareStatisticalModule {
    private static final String NO_METHOD_STRING = NbBundle.getMessage(HttpRequestTrackerPanel.class, (String)"HttpRequestTrackerPanel_NoMethodString");
    private static final String NO_DATA_STRING = NbBundle.getMessage(HttpRequestTrackerPanel.class, (String)"HttpRequestTrackerPanel_NoDataString");
    private static final String REQUEST_TRACKER_STRING = NbBundle.getMessage(HttpRequestTrackerPanel.class, (String)"HttpRequestTrackerPanel_RequestTrackerString");
    private static final String REQUEST_TRACKER_DESCR = NbBundle.getMessage(HttpRequestTrackerPanel.class, (String)"HttpRequestTrackerPanel_RequestTrackerDescr");
    private CompositeCPUCCTWalker treeWalker;
    private HttpRequestTrackerModel model;
    private JLabel noData = new JLabel(NO_DATA_STRING);
    private JLabel noMethods = new JLabel(NO_METHOD_STRING);
    private RuntimeCPUCCTNode lastAppNode;

    public HttpRequestTrackerPanel() {
        this.initComponents();
        this.model = new HttpRequestTrackerModel();
        this.treeWalker = new CompositeCPUCCTWalker();
        this.treeWalker.add(0, (CPUCCTVisitor)this.model);
    }

    public void setSelectedMethodId(int methodId) {
        int lastSelectedId = this.getSelectedMethodId();
        super.setSelectedMethodId(methodId);
        if (lastSelectedId != methodId) {
            lastSelectedId = methodId;
            this.refresh(this.lastAppNode);
        }
    }

    public void refresh(RuntimeCPUCCTNode appNode) {
        if (appNode == null) {
            return;
        }
        if (this.model != null) {
            appNode.accept((RuntimeCPUCCTNodeVisitor)this.treeWalker);
            this.lastAppNode = appNode;
        }
    }

    public boolean supportsProject(Project project) {
        if (this.isWebProject(project)) {
            System.setProperty("org.netbeans.lib.profiler.servletTracking", "true");
            return true;
        }
        System.setProperty("org.netbeans.lib.profiler.servletTracking", "false");
        return false;
    }

    private boolean isWebProject(Project project) {
        if (project == null) {
            return false;
        }
        return WebProjectUtils.getDeploymentDescriptorFileObjects(project, true) != null;
    }

    private void initComponents() {
        BoxLayout layout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(layout);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setName(REQUEST_TRACKER_STRING);
        this.setToolTipText(REQUEST_TRACKER_DESCR);
        this.noMethods.setOpaque(false);
        this.noMethods.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noMethods.getBorder()));
        this.noData.setOpaque(false);
        this.noData.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noData.getBorder()));
        this.add(this.noMethods);
    }

    private void refreshData() {
        Set<String> paths;
        if (this.model == null) {
            return;
        }
        Runnable uiUpdater = null;
        uiUpdater = this.getSelectedMethodId() == -1 ? new Runnable(){

            @Override
            public void run() {
                HttpRequestTrackerPanel.this.removeAll();
                HttpRequestTrackerPanel.this.add(HttpRequestTrackerPanel.this.noMethods);
                HttpRequestTrackerPanel.this.revalidate();
                HttpRequestTrackerPanel.this.repaint();
            }
        } : ((paths = this.model.getPaths(this.getSelectedMethodId())) == null || paths.isEmpty() ? new Runnable(){

            @Override
            public void run() {
                HttpRequestTrackerPanel.this.removeAll();
                HttpRequestTrackerPanel.this.add(HttpRequestTrackerPanel.this.noData);
                HttpRequestTrackerPanel.this.revalidate();
                HttpRequestTrackerPanel.this.repaint();
            }
        } : new Runnable(){

            @Override
            public void run() {
                HttpRequestTrackerPanel.this.removeAll();
                for (String path : paths) {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setOpaque(false);
                    JLabel data = new JLabel(path);
                    data.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), data.getBorder()));
                    data.setOpaque(false);
                    panel.add((Component)data, "West");
                    HttpRequestTrackerPanel.this.add(panel);
                }
                HttpRequestTrackerPanel.this.revalidate();
                HttpRequestTrackerPanel.this.repaint();
            }
        });
        if (EventQueue.isDispatchThread()) {
            uiUpdater.run();
        } else {
            EventQueue.invokeLater(uiUpdater);
        }
    }

    private class HttpRequestTrackerModel
    extends CPUCCTVisitorAdapter {
        private final Set<String> EMPTY_SET = new HashSet<String>();
        private ReadWriteLock lock = new ReentrantReadWriteLock();
        private ServletRequestCPUCCTNode usedRequest = null;
        private Set<String> paths = new HashSet<String>();
        private Stack<ServletRequestCPUCCTNode> servletStack = new Stack();
        private int inCalls;
        private int lastCalls;
        private int outCalls;
        private long time0;
        private long time1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getPaths(int methodId) {
            this.lock.readLock().lock();
            try {
                Set<String> set = this.paths != null ? new HashSet<String>(this.paths) : this.EMPTY_SET;
                return set;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void afterWalk() {
            this.servletStack.clear();
            this.lock.writeLock().unlock();
            HttpRequestTrackerPanel.this.refreshData();
        }

        public void beforeWalk() {
            this.lock.writeLock().lock();
            this.servletStack.clear();
            this.paths.clear();
        }

        public void visit(MethodCPUCCTNode node) {
            boolean first = false;
            if (this.usedRequest == null) {
                if (node.getMethodId() != HttpRequestTrackerPanel.this.getSelectedMethodId()) {
                    return;
                }
                this.usedRequest = this.servletStack.isEmpty() ? null : this.servletStack.peek();
                first = true;
            }
            if (this.usedRequest == null) {
                return;
            }
            this.time0 += node.getNetTime0();
            this.time1 += node.getNetTime1();
            if (!first) {
                this.inCalls += node.getNCalls();
            }
            this.outCalls += node.getNCalls();
            this.lastCalls = node.getNCalls();
        }

        public void visit(ServletRequestCPUCCTNode node) {
            this.servletStack.push(node);
        }

        public void visitPost(ServletRequestCPUCCTNode node) {
            this.servletStack.pop();
            if (this.usedRequest != null && this.usedRequest.equals((Object)node)) {
                this.paths.add(this.usedRequest.getServletPath());
                this.outCalls = 0;
                this.inCalls = 0;
                this.lastCalls = 0;
                this.time0 = 0L;
                this.time1 = 0L;
                this.usedRequest = null;
            }
        }
    }
}

