/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.jsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.jsp.JSPFolderNode;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.jsp.JSPNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JspsNode
extends ContainerNode {
    private static final String JSPS_STRING = NbBundle.getMessage(JspsNode.class, (String)"JspsNode_JspsString");

    public JspsNode(ContainerNode parent) {
        super(JSPS_STRING, (Icon)Utils.PACKAGE_ICON, parent);
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    private static class Children
    extends GreedySelectorChildren<JspsNode> {
        private Children() {
        }

        protected List<SelectorNode> prepareChildren(JspsNode parent) {
            ArrayList<SelectorNode> components = new ArrayList<SelectorNode>();
            Project project = (Project)parent.getLookup().lookup(Project.class);
            Collection<FileObject> fos = WebProjectUtils.getDocumentBaseFileObjects(project, true);
            for (FileObject fo : fos) {
                this.enumerateJSPs(fo, components, parent);
            }
            return components;
        }

        private void enumerateJSPs(FileObject fo, List<SelectorNode> components, JspsNode parent) {
            HashSet<JSPFolderNode> folders = new HashSet<JSPFolderNode>();
            HashSet<JSPNode> jsps = new HashSet<JSPNode>();
            for (FileObject child : fo.getChildren()) {
                if (child.isFolder()) {
                    JSPFolderNode folderNode = new JSPFolderNode(child, parent);
                    if (folderNode.isLeaf()) continue;
                    folders.add(folderNode);
                    continue;
                }
                if (!child.getExt().equalsIgnoreCase("jsp")) continue;
                jsps.add(new JSPNode(child, parent));
            }
            ArrayList foldersList = new ArrayList(folders);
            ArrayList jspsList = new ArrayList(jsps);
            Collections.sort(foldersList, JSPFolderNode.COMPARATOR);
            components.addAll(foldersList);
            Collections.sort(jspsList, JSPNode.COMPARATOR);
            components.addAll(jspsList);
        }
    }
}

