/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.tha.api;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.openide.util.Exceptions;

public final class THASuspensionSupport {
    private final ExecutionEnvironment execEnv;
    private final DLightExecutorService.DLightScheduledTask notifyTask;
    private final Listener listener;
    private final int pid;
    private volatile Status status = Status.INIT;
    private volatile State state = State.UNKNOWN;

    private THASuspensionSupport(ExecutionEnvironment execEnv, int pid, Listener listener, boolean initiallyResumed) {
        this.execEnv = execEnv;
        this.pid = pid;
        this.listener = listener;
        this.state = initiallyResumed ? State.RESUMED : State.SUSPENDED;
        this.notifyTask = this.startMonitor();
    }

    public static THASuspensionSupport getSupportFor(ExecutionEnvironment execEnv, int pid, Listener listener, boolean initiallyResumed) {
        return new THASuspensionSupport(execEnv, pid, listener, initiallyResumed);
    }

    public Status getStatus() {
        return this.status;
    }

    public State getState() {
        return this.state;
    }

    public synchronized void resume(final boolean resume) {
        boolean resumed;
        boolean bl = resumed = this.state == State.RESUMED;
        if (this.status == Status.ENABLED && resume != resumed) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Future rc = CommonTasksSupport.sendSignal((ExecutionEnvironment)THASuspensionSupport.this.execEnv, (int)THASuspensionSupport.this.pid, (Signal)Signal.SIGUSR1, null);
                        if ((Integer)rc.get() == 0) {
                            THASuspensionSupport.this.state = resume ? State.RESUMED : State.SUSPENDED;
                            THASuspensionSupport.this.listener.stateChanged(THASuspensionSupport.this.state);
                        }
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                DLightExecutorService.submit((Runnable)r, (String)((resume ? "Resume" : "Suspend") + " THA data collection for " + this.pid + "@" + this.execEnv.toString()));
            } else {
                r.run();
            }
        }
    }

    private DLightExecutorService.DLightScheduledTask startMonitor() {
        try {
            HostInfo hinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
            boolean isSolaris = hinfo.getOSFamily() == HostInfo.OSFamily.SUNOS;
            Verifier verifier = isSolaris ? new SolarisVerifier() : new LinuxVerifier();
            return DLightExecutorService.scheduleAtFixedRate((Runnable)verifier, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS, (String)("Monitoring process " + this.pid + "@" + this.execEnv.toString() + " for THA pause/resume readiness"));
        }
        catch (IOException ex) {
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    private synchronized void stopMonitor(Status status) {
        this.status = status;
        this.notifyTask.cancel(1L);
        this.listener.statusChanged(status);
    }

    public static enum Status {
        INIT,
        ENABLED,
        DISABLED,
        ERROR;

    }

    public static enum State {
        UNKNOWN,
        SUSPENDED,
        RESUMED;

    }

    public static interface Listener {
        public void statusChanged(Status var1);

        public void stateChanged(State var1);
    }

    private class SolarisVerifier
    extends Verifier {
        public SolarisVerifier() {
            this.npb.setExecutable("/bin/pargs").setArguments(new String[]{"-l", "" + THASuspensionSupport.this.pid});
            this.collectPattern = Pattern.compile(".*/collect .*");
        }
    }

    private class LinuxVerifier
    extends Verifier {
        public LinuxVerifier() {
            this.npb.setExecutable("ps").setArguments(new String[]{"-o", "comm=", "-p", "" + THASuspensionSupport.this.pid});
            this.collectPattern = Pattern.compile("^collect$");
        }
    }

    private abstract class Verifier
    implements Runnable {
        protected NativeProcessBuilder npb;
        protected Pattern collectPattern;

        public Verifier() {
            this.npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)THASuspensionSupport.this.execEnv);
        }

        @Override
        public void run() {
            try {
                NativeProcess p = this.npb.call();
                String comm = ProcessUtils.readProcessOutputLine((Process)p);
                int rc = p.waitFor();
                if (rc != 0) {
                    THASuspensionSupport.this.stopMonitor(Status.ERROR);
                    return;
                }
                if (!this.collectPattern.matcher(comm).matches()) {
                    THASuspensionSupport.this.stopMonitor(Status.ENABLED);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

