/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.tha.api;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.perfan.tha.api.THAConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.NbBundle;

public final class THAInstrumentationSupport {
    private static final CollectVersion minSupportedVersion = CollectVersion.getCollectVersion("6.7");
    private static final ConcurrentHashMap<SSLocation, THAInstrumentationSupport> hash = new ConcurrentHashMap();
    private final ExecutionEnvironment execEnv;
    private Future<CollectVersion> version;
    private final String collectCMD;
    private final String binDir;

    public static THAInstrumentationSupport getSupport(ExecutionEnvironment execEnv, String sunstudioBinDir) {
        SSLocation location = new SSLocation(execEnv, sunstudioBinDir);
        THAInstrumentationSupport support = hash.get(location);
        if (support != null) {
            return support;
        }
        support = new THAInstrumentationSupport(execEnv, sunstudioBinDir);
        THAInstrumentationSupport existentSupport = hash.putIfAbsent(location, support);
        if (existentSupport != null) {
            return existentSupport;
        }
        return support;
    }

    private THAInstrumentationSupport(ExecutionEnvironment execEnv, String sunstudioBinDir) {
        this.binDir = sunstudioBinDir;
        this.execEnv = execEnv;
        this.collectCMD = sunstudioBinDir + "collect";
    }

    public boolean isSupported() {
        boolean result = false;
        try {
            CollectVersion vers;
            if (this.version == null) {
                this.version = this.getVersion();
            }
            return (vers = this.version.get()).compareTo(minSupportedVersion) > 0;
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public boolean isInstrumentationNeeded(ExecutionEnvironment env, THAConfiguration configuration) {
        try {
            return configuration.collectDataRaces() || !configuration.collectDeadlocks() || !HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getCpuFamily().equals((Object)HostInfo.CpuFamily.SPARC);
        }
        catch (IOException ex) {
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return true;
    }

    public Future<Boolean> isInstrumented(final String executable) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)THAInstrumentationSupport.this.execEnv);
                npb.setExecutable(THAInstrumentationSupport.this.collectCMD).setArguments(new String[]{"-n", "-r races", executable});
                NativeProcess p = npb.call();
                List out = ProcessUtils.readProcessOutput((Process)p);
                int result = p.waitFor();
                if (result == 0) {
                    String identifier = THAInstrumentationSupport.loc("THA_InstrumentedIdentifier", new String[0]);
                    for (String s : out) {
                        if (!s.contains(identifier)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private Future<CollectVersion> getVersion() {
        FutureTask<CollectVersion> getBinDir = new FutureTask<CollectVersion>(new Callable<CollectVersion>(){

            @Override
            public CollectVersion call() throws Exception {
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)THAInstrumentationSupport.this.execEnv);
                npb.setExecutable(THAInstrumentationSupport.this.binDir + "version").setArguments(new String[]{THAInstrumentationSupport.this.collectCMD});
                NativeProcess np = npb.call();
                List output = ProcessUtils.readProcessOutput((Process)np);
                int result = np.waitFor();
                if (result == 0) {
                    return CollectVersion.getCollectVersion((String)output.get(0));
                }
                return CollectVersion.UNKNOWN;
            }
        });
        getBinDir.run();
        return getBinDir;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(THAInstrumentationSupport.class, (String)key, (Object[])params);
    }

    public String getLinkerOptions() {
        return "-xinstrument=datarace";
    }

    public String getCompilerOptions() {
        return "-xinstrument=datarace";
    }

    private static final class SSLocation {
        private final ExecutionEnvironment execEnv;
        private final String binDir;

        public SSLocation(ExecutionEnvironment execEnv, String binDir) {
            this.execEnv = execEnv;
            this.binDir = binDir;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SSLocation)) {
                return false;
            }
            SSLocation other = (SSLocation)obj;
            return this.execEnv.equals(other.execEnv) && this.binDir.equals(other.binDir);
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + (this.execEnv != null ? this.execEnv.hashCode() : 0);
            hash = 23 * hash + (this.binDir != null ? this.binDir.hashCode() : 0);
            return hash;
        }
    }

    private static class CollectVersion
    implements Comparable<CollectVersion> {
        public static final CollectVersion UNKNOWN = new CollectVersion(0, 0);
        private final int major;
        private final int minor;

        public static CollectVersion getCollectVersion(String versionString) {
            Pattern versionPattern = Pattern.compile("version [^:]+: Sun Analyzer ([1-9]+)\\.([1-9]+).*");
            Matcher m = versionPattern.matcher(versionString);
            if (m.matches()) {
                return new CollectVersion(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
            }
            versionPattern = Pattern.compile("version [^:]+: Sun .*Analyzer ([1-9]+)\\.([1-9]+).*");
            m = versionPattern.matcher(versionString);
            if (m.matches()) {
                return new CollectVersion(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
            }
            versionPattern = Pattern.compile("([1-9]+)\\.([1-9]+).*");
            m = versionPattern.matcher(versionString);
            if (m.matches()) {
                return new CollectVersion(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
            }
            return UNKNOWN;
        }

        private CollectVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        @Override
        public int compareTo(CollectVersion other) {
            if (this.equals(other)) {
                return 0;
            }
            if (this.major == other.major) {
                return Integer.valueOf(this.minor).compareTo(other.minor);
            }
            return Integer.valueOf(this.major).compareTo(other.major);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CollectVersion)) {
                return false;
            }
            CollectVersion that = (CollectVersion)obj;
            return this.major == that.major && this.minor == that.minor;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + this.major;
            hash = 17 * hash + this.minor;
            return hash;
        }
    }
}

