/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.util.DLightLogger;

public final class ExperimentStatistics {
    private final Double startTime;
    private final Double endTime;
    private final Double duration;
    private final Double totalThreadTime;
    private final Double avrgThreadsNumber;
    private final Double t_userCPU;
    private final Double t_userCPU_p;
    private final Double t_sysCPU;
    private final Double t_sysCPU_p;
    private final Double t_waitCPU;
    private final Double t_waitCPU_p;
    private final Double t_usrLock;
    private final Double t_usrLock_p;

    ExperimentStatistics(String[] toParse) {
        Object _startTime = null;
        Object _endTime = null;
        Double _duration = null;
        Double _totalThreadTime = null;
        Object _avrgThreadsNumber = null;
        Object _t_userCPU = null;
        Object _t_userCPU_p = null;
        Object _t_sysCPU = null;
        Object _t_sysCPU_p = null;
        Object _t_waitCPU = null;
        Object _t_waitCPU_p = null;
        Double _t_usrLock = null;
        Double _t_usrLock_p = null;
        for (String s : toParse) {
            int scidx = s.indexOf(58);
            if (scidx < 0) continue;
            String id = s.substring(0, scidx).trim();
            try {
                if (id.startsWith("User Lock")) {
                    StringTokenizer t = ExperimentStatistics.tokenize(s.substring(scidx + 1));
                    _t_usrLock = DataUtil.toDouble((Object)t.nextToken(), (double)Double.NaN);
                    _t_usrLock_p = DataUtil.toDouble((Object)t.nextToken(), (double)Double.NaN);
                    continue;
                }
                if (id.startsWith("Total Thread Time") || id.startsWith("Total LWP Time")) {
                    _totalThreadTime = DataUtil.toDouble((Object)s.substring(scidx + 1), (double)Double.NaN);
                    continue;
                }
                if (!id.startsWith("Duration")) continue;
                _duration = DataUtil.toDouble((Object)s.substring(scidx + 1), (double)Double.NaN);
            }
            catch (NoSuchElementException ex) {
                DLightLogger.instance.log(Level.INFO, "Failed to parse statistics line", ex);
            }
        }
        this.startTime = _startTime;
        this.endTime = _endTime;
        this.duration = _duration == null || Double.isNaN(_duration) ? null : _duration;
        this.totalThreadTime = _totalThreadTime == null || Double.isNaN(_totalThreadTime) ? null : _totalThreadTime;
        this.avrgThreadsNumber = _avrgThreadsNumber;
        this.t_userCPU = _t_userCPU;
        this.t_userCPU_p = _t_userCPU_p;
        this.t_sysCPU = _t_sysCPU;
        this.t_sysCPU_p = _t_sysCPU_p;
        this.t_waitCPU = _t_waitCPU;
        this.t_waitCPU_p = _t_waitCPU_p;
        this.t_usrLock = _t_usrLock == null || Double.isNaN(_t_usrLock) ? null : _t_usrLock;
        this.t_usrLock_p = _t_usrLock_p == null || Double.isNaN(_t_usrLock_p) ? null : _t_usrLock_p;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Double getTotalThreadTime() {
        return this.totalThreadTime;
    }

    public Double getULock() {
        return this.t_usrLock;
    }

    public Double getULock_p() {
        return this.t_usrLock_p;
    }

    private static StringTokenizer tokenize(String line) {
        return new StringTokenizer(line, " ()%");
    }
}

