/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.stack.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionImpl;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;

public class FunctionCallImpl
extends FunctionCallWithMetric {
    private final Map<FunctionMetric, Object> metrics;
    private final long ref;
    private String displayedName = null;
    private SourceFileInfoProvider.SourceFileInfo sourceInfo = null;
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\s+(.+?)(?:\\s+\\+\\s+0x([0-9a-fA-F]+))?(?:,\\s+line\\s+(\\d+)\\s+in\\s+\"(.+)\")?");

    public FunctionCallImpl(FunctionImpl function, long offset, Map<FunctionMetric, Object> metrics) {
        super((Function)function, offset);
        this.ref = function.getRef();
        this.metrics = Collections.unmodifiableMap(new HashMap<FunctionMetric, Object>(metrics));
        this.updateDisplayedName();
    }

    public synchronized void setSourceFileInfo(SourceFileInfoProvider.SourceFileInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.updateDisplayedName();
        this.setLineNumber(sourceInfo == null ? -1 : sourceInfo.getLine());
        ((FunctionImpl)this.getFunction()).setSourcefileName(sourceInfo == null ? "<unknown>" : sourceInfo.getFileName());
    }

    public long getFunctionRefID() {
        return this.ref;
    }

    public synchronized String getSourceFile() {
        return this.sourceInfo == null ? null : this.sourceInfo.getFileName();
    }

    public synchronized String getDisplayedName() {
        return this.displayedName;
    }

    public Object getMetricValue(FunctionMetric metric) {
        return this.metrics.get(metric);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getFunction().toString());
        sb.append(" [ ");
        for (FunctionMetric m : this.metrics.keySet()) {
            sb.append(m.getMetricDisplayedName()).append(" == ");
            sb.append(this.metrics.get(m)).append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionCallImpl)) {
            return false;
        }
        FunctionCallImpl that = (FunctionCallImpl)((Object)obj);
        if (this.ref != that.ref) {
            return false;
        }
        return ((Object)this.metrics).equals(that.metrics);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.metrics != null ? ((Object)this.metrics).hashCode() : 0);
        hash = 29 * hash + (int)(this.ref ^ this.ref >>> 32);
        return hash;
    }

    public boolean hasMetric(String metric_id) {
        for (FunctionMetric metric : this.metrics.keySet()) {
            if (!metric.getMetricID().equals(metric_id)) continue;
            return true;
        }
        return false;
    }

    public Object getMetricValue(String metric_id) {
        for (FunctionMetric metric : this.metrics.keySet()) {
            if (!metric.getMetricID().equals(metric_id)) continue;
            return this.metrics.get(metric);
        }
        return null;
    }

    private synchronized void updateDisplayedName() {
        StringBuilder sb = new StringBuilder(this.getFunction().getSignature());
        if (this.sourceInfo != null) {
            String file = this.sourceInfo.getFileName();
            int line = this.sourceInfo.getLine();
            sb.append("; ");
            sb.append(new File(file).getName());
            if (line > 0) {
                sb.append(':').append(line);
            }
        }
        if (sb.length() == 0) {
            sb.append(super.getDisplayedName());
        }
        this.displayedName = sb.toString();
    }

    public static List<FunctionCall> parseStack(ListIterator<String> it) {
        ArrayList<FunctionCall> result = new ArrayList<FunctionCall>();
        while (it.hasNext()) {
            String line = it.next().replace("Stack:", "      ");
            if (8 <= line.length() - line.trim().length()) {
                result.add(FunctionCallImpl.parseFunctionCall(line));
                continue;
            }
            it.previous();
            break;
        }
        return result;
    }

    private static FunctionCall parseFunctionCall(String line) {
        Matcher m = FUNCTION_PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        int lineNumber = -1;
        if (m.group(3) != null) {
            try {
                lineNumber = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        FunctionImpl func = new FunctionImpl(m.group(1), m.group(2) != null ? (long)m.group(2).hashCode() : (long)(m.group(1) + lineNumber).hashCode());
        FunctionCallImpl call = new FunctionCallImpl(func, lineNumber, new HashMap<FunctionMetric, Object>());
        if (m.group(4) != null) {
            call.setSourceFileInfo(new SourceFileInfoProvider.SourceFileInfo((CharSequence)m.group(4), lineNumber, 0));
            func.setSourcefileName(m.group(4));
        }
        return call;
    }
}

