/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class WebParamHolder
extends Rule<VariableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(VariableElement subject, ProblemContext ctx) {
        AnnotationMirror paramAnn = Utilities.findAnnotation(subject, "javax.jws.WebParam");
        if (paramAnn != null) {
            AnnotationValue val = Utilities.getAnnotationAttrValue(paramAnn, "mode");
            WebParam.Mode value = null;
            if (val != null) {
                try {
                    value = WebParam.Mode.valueOf((String)val.getValue().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!(WebParam.Mode.INOUT != value && WebParam.Mode.OUT != value || "javax.xml.ws.Holder".equals(WebParamHolder.getVariableType(subject)))) {
                String label = NbBundle.getMessage(WebParamHolder.class, (String)"MSG_WebParam_HolderRequired");
                RemoveAnnotationArgument fix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, paramAnn, "mode");
                AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, paramAnn);
                ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "mode");
                ctx.setElementToAnnotate(problemTree);
                ErrorDescription problem = WebParamHolder.createProblem((Element)subject, ctx, label, fix);
                ctx.setElementToAnnotate(null);
                return new ErrorDescription[]{problem};
            }
        }
        return null;
    }

    @Override
    protected boolean isApplicable(VariableElement subject, ProblemContext ctx) {
        return Utilities.hasAnnotation(subject, "javax.jws.WebParam");
    }

    private static String getVariableType(VariableElement subject) {
        DeclaredType dt;
        if (subject.asType() instanceof DeclaredType && (dt = (DeclaredType)subject.asType()).asElement() instanceof TypeElement) {
            TypeElement elem = (TypeElement)dt.asElement();
            return elem.getQualifiedName().toString();
        }
        return null;
    }
}

