/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.serialization;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.vmd.api.model.PresenterSerializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.serialization.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MidpPropertyPresenterSerializer
implements PresenterSerializer {
    private String displayName;
    private String editorID;
    private String propertyName;

    public MidpPropertyPresenterSerializer(String displayName, PropertyDescriptor property) {
        this.displayName = displayName;
        this.editorID = MidpPropertyPresenterSerializer.createEditorIDForPropertyDescriptor(property);
        this.propertyName = property.getName();
    }

    public List<Element> serialize(Document document) {
        Element element = document.createElement("MidpProperty");
        XMLUtils.setAttribute(document, element, "displayName", this.displayName);
        if (this.editorID != null) {
            XMLUtils.setAttribute(document, element, "editor", this.editorID);
        }
        XMLUtils.setAttribute(document, element, "propertyName", this.propertyName);
        return Arrays.asList(element);
    }

    private static String createEditorIDForPropertyDescriptor(PropertyDescriptor property) {
        TypeID type = property.getType();
        if (MidpTypes.TYPEID_BOOLEAN.equals((Object)type)) {
            return "boolean";
        }
        if (MidpTypes.TYPEID_CHAR.equals((Object)type)) {
            return "char";
        }
        if (MidpTypes.TYPEID_BYTE.equals((Object)type)) {
            return "byte";
        }
        if (MidpTypes.TYPEID_SHORT.equals((Object)type)) {
            return "short";
        }
        if (MidpTypes.TYPEID_INT.equals((Object)type)) {
            return "int";
        }
        if (MidpTypes.TYPEID_LONG.equals((Object)type)) {
            return "long";
        }
        if (MidpTypes.TYPEID_FLOAT.equals((Object)type)) {
            return "float";
        }
        if (MidpTypes.TYPEID_DOUBLE.equals((Object)type)) {
            return "double";
        }
        if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)type)) {
            return "java.lang.String";
        }
        return "#javaCode";
    }
}

