/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.parser.XmlSyntaxTreeBuilder;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.netbeans.editor.ext.html.parser.spi.HtmlModel;
import org.netbeans.editor.ext.html.parser.spi.HtmlParseResult;
import org.netbeans.editor.ext.html.parser.spi.HtmlTag;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagAttribute;
import org.netbeans.editor.ext.html.parser.spi.NamedCharRef;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HtmlCompletionQuery
extends UserTask {
    private static final String SCRIPT_TAG_NAME = "script";
    private static final String STYLE_TAG_NAME = "style";
    private static boolean lowerCase;
    private static boolean isXHtml;
    private Document document;
    private FileObject file;
    private int offset;
    private CompletionResult completionResult;

    public HtmlCompletionQuery(Document document, int offset) {
        this.document = document;
        this.offset = offset;
        this.file = DataLoadersBridge.getDefault().getFileObject(document);
    }

    public CompletionResult query() throws ParseException {
        Source source = Source.create((Document)this.document);
        ParserManager.parse(Collections.singleton(source), (UserTask)this);
        return this.completionResult;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        final Parser.Result parserResult = resultIterator.getParserResult(this.offset);
        if (parserResult == null) {
            return;
        }
        final Snapshot snapshot = parserResult.getSnapshot();
        final Document doc = snapshot.getSource().getDocument(true);
        if (doc == null) {
            return;
        }
        doc.render(new Runnable(){

            @Override
            public void run() {
                int embeddedOffset = snapshot.getEmbeddedOffset(HtmlCompletionQuery.this.offset);
                String resultMimeType = parserResult.getSnapshot().getMimeType();
                if (resultMimeType.equals("text/html")) {
                    HtmlCompletionQuery.this.completionResult = HtmlCompletionQuery.this.query((HtmlParserResult)parserResult);
                } else if (resultMimeType.equals("text/javascript")) {
                    HtmlCompletionQuery.this.completionResult = HtmlCompletionQuery.this.queryHtmlEndTagInEmbeddedCode(snapshot, doc, embeddedOffset, HtmlCompletionQuery.SCRIPT_TAG_NAME);
                } else if (resultMimeType.equals("text/x-css")) {
                    HtmlCompletionQuery.this.completionResult = HtmlCompletionQuery.this.queryHtmlEndTagInEmbeddedCode(snapshot, doc, embeddedOffset, HtmlCompletionQuery.STYLE_TAG_NAME);
                }
            }
        });
    }

    private CompletionResult queryHtmlEndTagInEmbeddedCode(Snapshot snapshot, Document doc, int embeddedOffset, String endTagName) {
        Token<HTMLTokenId> openTagToken;
        int documentItemOffset = snapshot.getOriginalOffset(embeddedOffset);
        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, documentItemOffset - 1);
        if (ts != null && ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && CharSequenceUtilities.equals((CharSequence)ts.token().text(), (Object)">") && (openTagToken = Utils.findTagOpenToken(ts)) != null && CharSequenceUtilities.equals((CharSequence)openTagToken.text(), (Object)endTagName)) {
            List<HtmlCompletionItem> items = Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(endTagName, documentItemOffset));
            return new CompletionResult(items, this.offset);
        }
        String expectedCode = "</" + endTagName;
        int patternSize = Math.max(embeddedOffset, embeddedOffset - expectedCode.length());
        CharSequence pattern = snapshot.getText().subSequence(embeddedOffset - patternSize, embeddedOffset);
        int ltIndex = CharSequenceUtilities.lastIndexOf((CharSequence)pattern, (int)60);
        if (ltIndex == -1) {
            return null;
        }
        boolean match = true;
        for (int i = ltIndex; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == expectedCode.charAt(i - ltIndex)) continue;
            match = false;
            break;
        }
        if (match) {
            int itemOffset = embeddedOffset - patternSize + ltIndex;
            documentItemOffset = snapshot.getOriginalOffset(itemOffset);
            List<HtmlCompletionItem> items = Collections.singletonList(HtmlCompletionItem.createEndTag(endTagName, documentItemOffset, null, -1, HtmlCompletionItem.EndTag.Type.DEFAULT));
            return new CompletionResult(items, this.offset);
        }
        return null;
    }

    CompletionResult query(HtmlParserResult parserResult) {
        Collection<CompletionItem> result;
        int anchor;
        block69: {
            boolean queryHtmlContent;
            AstNode undeclaredTagsLeafNode;
            AstNode node;
            int len;
            TokenId id;
            String itemText;
            String preText;
            int documentItemOffset;
            int itemOffset;
            Token item;
            TokenSequence ts;
            int astOffset;
            String sourceMimetype;
            HtmlModel model;
            HtmlParseResult htmlResult;
            block70: {
                boolean inside;
                block68: {
                    try {
                        htmlResult = parserResult.getSyntaxAnalyzerResult().parseHtml();
                    }
                    catch (org.netbeans.editor.ext.html.parser.api.ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return null;
                    }
                    model = htmlResult.model();
                    Snapshot snapshot = parserResult.getSnapshot();
                    sourceMimetype = snapshot.getSource().getMimeType();
                    astOffset = snapshot.getEmbeddedOffset(this.offset);
                    if (astOffset == -1) {
                        return null;
                    }
                    lowerCase = this.usesLowerCase(parserResult, astOffset);
                    HtmlVersion version = parserResult.getHtmlVersion();
                    isXHtml = version.isXhtml();
                    TokenHierarchy hi = snapshot.getTokenHierarchy();
                    ts = hi.tokenSequence(HTMLTokenId.language());
                    assert (ts != null);
                    int diff = ts.move(astOffset);
                    boolean backward = false;
                    if (ts.moveNext()) {
                        if (diff == 0 && (ts.token().id() == HTMLTokenId.TEXT || ts.token().id() == HTMLTokenId.WS || ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL || ts.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL)) {
                            backward = true;
                            if (!ts.movePrevious()) {
                                return null;
                            }
                        }
                    } else {
                        backward = true;
                        if (!ts.movePrevious()) {
                            return null;
                        }
                    }
                    anchor = -1;
                    item = ts.token();
                    itemOffset = ts.offset();
                    documentItemOffset = snapshot.getOriginalOffset(itemOffset);
                    itemText = preText = ((Object)item.text()).toString();
                    if (astOffset - itemOffset < 0 || preText.length() < astOffset - itemOffset) {
                        StringBuilder b = new StringBuilder();
                        b.append("Inconsistency in the snapshot! Detailed info:");
                        b.append("\n------------------------------------------------");
                        b.append("\ndocument.getText():");
                        try {
                            b.append(this.document.getText(0, this.document.getLength()));
                        }
                        catch (BadLocationException ex) {
                            b.append(ex.getMessage());
                        }
                        b.append("\n------------------------------------------------");
                        b.append("\ntoken hierarchy:\n").append(hi.toString());
                        b.append("\n------------------------------------------------");
                        b.append("\ntoken sequence:\n").append(ts.toString());
                        b.append("\n------------------------------------------------");
                        b.append("\nsnapshot.getText():").append(((Object)snapshot.getText()).toString());
                        b.append("\n------------------------------------------------");
                        b.append("\nsnapshot.toString():").append(snapshot).toString();
                        b.append("\nsource:").append(snapshot.getSource()).toString();
                        b.append(String.format("\nastOffset = %1$s, itemOffset = %2$s", astOffset, itemOffset));
                        b.append(String.format("\npreText=%s; len=%s", preText, preText.length()));
                        Logger.getAnonymousLogger().warning(b.toString());
                    }
                    if (diff < preText.length()) {
                        preText = preText.substring(0, astOffset - itemOffset);
                    }
                    id = item.id();
                    inside = ts.offset() < astOffset;
                    result = null;
                    len = 1;
                    int searchAstOffset = astOffset == snapshot.getText().length() ? astOffset - 1 : astOffset;
                    node = null;
                    AstNode root = null;
                    boolean useHtmlParseResult = true;
                    if (version == HtmlVersion.HTML5 || version == HtmlVersion.XHTML5 || version == HtmlVersion.XHTML10_FRAMESET || version == HtmlVersion.XHTML10_STICT || version == HtmlVersion.XHTML10_TRANSATIONAL || version == HtmlVersion.HTML41_FRAMESET || version == HtmlVersion.HTML41_STRICT || version == HtmlVersion.HTML41_TRANSATIONAL) {
                        for (ProblemDescription pd : htmlResult.getProblems()) {
                            if (pd.getType() <= 1) continue;
                            useHtmlParseResult = false;
                            break;
                        }
                    }
                    if (useHtmlParseResult) {
                        node = parserResult.findLeafTag(searchAstOffset, !backward, false);
                        if (node == null || node.equals(parserResult.root())) {
                            useHtmlParseResult = false;
                        } else {
                            root = node.getRootNode();
                        }
                    }
                    if (!useHtmlParseResult && (node = AstNodeUtils.findNode((AstNode)(root = XmlSyntaxTreeBuilder.makeUncheckedTree((HtmlSource)htmlResult.source(), (List)parserResult.getSyntaxAnalyzerResult().getElements().items())), (int)searchAstOffset, (!backward ? 1 : 0) != 0, (boolean)false)) == null) {
                        node = root;
                    }
                    assert (node != null);
                    assert (root != null);
                    AstNode undeclaredTagsParseTreeRoot = parserResult.rootOfUndeclaredTagsParseTree();
                    assert (undeclaredTagsParseTreeRoot != null);
                    undeclaredTagsLeafNode = AstNodeUtils.findNode((AstNode)undeclaredTagsParseTreeRoot, (int)searchAstOffset, (!backward ? 1 : 0) != 0, (boolean)false);
                    String namespace = (String)root.getProperty("namespace");
                    queryHtmlContent = namespace == null || namespace.equals(parserResult.getHtmlVersion().getDefaultNamespace());
                    int ampIndex = preText.lastIndexOf(38);
                    if (id != HTMLTokenId.TEXT && id != HTMLTokenId.VALUE || ampIndex <= -1) break block68;
                    anchor = this.offset;
                    result = this.translateCharRefs(this.offset - len, model.getNamedCharacterReferences(), preText.substring(ampIndex + 1));
                    break block69;
                }
                if (id != HTMLTokenId.CHARACTER) break block70;
                if (!inside && preText.endsWith(";")) break block69;
                anchor = documentItemOffset + 1;
                result = this.translateCharRefs(documentItemOffset, model.getNamedCharacterReferences(), preText.length() > 0 ? preText.substring(1) : "");
                break block69;
            }
            if (id == HTMLTokenId.TAG_OPEN) {
                if (node.getNameWithoutPrefix().equals(preText)) {
                    node = node.parent();
                }
                anchor = documentItemOffset;
                astOffset -= preText.length() + 1;
                result = new ArrayList<CompletionItem>();
                if (queryHtmlContent) {
                    Collection possibleOpenTags = htmlResult.getPossibleTagsInContext(node, true);
                    Collection<HtmlTag> allTags = this.filterHtmlElements(model.getAllTags(), preText);
                    Collection<HtmlTag> filteredByPrefix = this.filterHtmlElements(possibleOpenTags, preText);
                    result.addAll(this.translateHtmlTags(documentItemOffset - 1, filteredByPrefix, allTags));
                }
                HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, documentItemOffset - 1, preText, itemText);
                for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                    result.addAll(e.completeOpenTags(context));
                }
            } else if (id != HTMLTokenId.BLOCK_COMMENT && preText.endsWith("<") || id == HTMLTokenId.TAG_OPEN_SYMBOL && "<".equals(((Object)item.text()).toString())) {
                if (node.getNameWithoutPrefix().equals(preText)) {
                    node = node.parent();
                }
                anchor = this.offset;
                result = new ArrayList<CompletionItem>();
                if (queryHtmlContent) {
                    Collection possibleOpenTags = htmlResult.getPossibleTagsInContext(node, true);
                    Collection allTags = model.getAllTags();
                    result.addAll(this.translateHtmlTags(this.offset - 1, possibleOpenTags, allTags));
                    if (HtmlPreferences.completionOffersEndTagAfterLt()) {
                        result.addAll(this.getPossibleEndTags(htmlResult, node, undeclaredTagsLeafNode, this.offset, ""));
                    }
                }
                HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, this.offset - 1, "", "");
                for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                    List<CompletionItem> items = e.completeOpenTags(context);
                    result.addAll(items);
                }
            } else if (id == HTMLTokenId.TEXT && preText.endsWith("</") || id == HTMLTokenId.TAG_OPEN_SYMBOL && preText.endsWith("</")) {
                anchor = this.offset;
                result = this.getPossibleEndTags(htmlResult, node, undeclaredTagsLeafNode, this.offset, "");
            } else if (id == HTMLTokenId.TAG_CLOSE) {
                anchor = documentItemOffset;
                result = this.getPossibleEndTags(htmlResult, node, undeclaredTagsLeafNode, this.offset, preText);
            } else if (id == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                anchor = this.offset;
                result = this.getAutocompletedEndTag(node, undeclaredTagsLeafNode, astOffset, this.offset);
            } else if (id == HTMLTokenId.WS || id == HTMLTokenId.ARGUMENT) {
                String prefix = id == HTMLTokenId.ARGUMENT ? preText : "";
                len = prefix.length();
                anchor = this.offset - len;
                if (!queryHtmlContent) {
                    ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
                    HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, prefix, itemText, node);
                    for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                        items.addAll(e.completeAttributes(context));
                    }
                    result = items;
                } else {
                    String wordAtCursor;
                    if (node.type() == AstNode.NodeType.UNKNOWN_TAG || node.type() == AstNode.NodeType.DECLARATION || node.type() == AstNode.NodeType.ROOT) {
                        return null;
                    }
                    assert (node.type() == AstNode.NodeType.OPEN_TAG) : "Unexpected node type " + node.type();
                    HtmlTag tag = model.getTag(node.name());
                    if (tag == null) {
                        return null;
                    }
                    Collection<HtmlTagAttribute> possible = this.filterAttributes(tag.getAttributes(), prefix);
                    Collection existingAttrsNames = node.getAttributeKeys();
                    String string = wordAtCursor = item == null ? null : ((Object)item.text()).toString();
                    if (wordAtCursor == null) {
                        wordAtCursor = "";
                    }
                    ArrayList<HtmlTagAttribute> complete = new ArrayList<HtmlTagAttribute>();
                    for (HtmlTagAttribute attr : possible) {
                        String aName = attr.getName();
                        if (!aName.equals(prefix) && (existingAttrsNames.contains(isXHtml ? aName : aName.toUpperCase(Locale.ENGLISH)) || existingAttrsNames.contains(isXHtml ? aName : aName.toLowerCase(Locale.ENGLISH))) && (!wordAtCursor.equals(aName) || prefix.length() <= 0)) continue;
                        complete.add(attr);
                    }
                    result = this.translateAttribs(anchor, complete, tag);
                }
            } else if (id == HTMLTokenId.VALUE || id == HTMLTokenId.OPERATOR || id == HTMLTokenId.WS) {
                if (id == HTMLTokenId.WS) {
                    ts.move(itemOffset);
                    ts.movePrevious();
                    Token t = ts.token();
                    if (t.id() != HTMLTokenId.OPERATOR) {
                        return null;
                    }
                }
                if (node.type() == AstNode.NodeType.OPEN_TAG) {
                    HtmlTag tag;
                    ts.move(itemOffset);
                    ts.moveNext();
                    Token argItem = ts.token();
                    while (argItem.id() != HTMLTokenId.ARGUMENT && ts.movePrevious()) {
                        argItem = ts.token();
                    }
                    if (argItem.id() != HTMLTokenId.ARGUMENT) {
                        return null;
                    }
                    String argName = ((Object)argItem.text()).toString();
                    if (!isXHtml) {
                        argName = argName.toLowerCase(Locale.ENGLISH);
                    }
                    if ((tag = model.getTag(node.name())) == null) {
                        return null;
                    }
                    HtmlTagAttribute attribute = tag.getAttribute(argName);
                    result = new ArrayList<CompletionItem>();
                    if (id != HTMLTokenId.VALUE) {
                        anchor = this.offset;
                        if (attribute != null) {
                            result.addAll(this.translateValues(anchor, attribute.getPossibleValues()));
                            ValueCompletion<HtmlCompletionItem> valuesCompletion = AttrValuesCompletion.getSupport(node.name(), argName);
                            if (valuesCompletion != null) {
                                result.addAll(valuesCompletion.getItems(this.file, anchor, ""));
                            }
                        }
                        HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, "", itemText, node, argName, false);
                        for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                            result.addAll(e.completeAttributeValue(context));
                        }
                    } else {
                        String quotationChar = null;
                        if (preText != null && preText.length() > 0) {
                            if (preText.substring(0, 1).equals("'")) {
                                quotationChar = "'";
                            }
                            if (preText.substring(0, 1).equals("\"")) {
                                quotationChar = "\"";
                            }
                        }
                        String prefix = quotationChar == null ? preText : preText.substring(1);
                        anchor = documentItemOffset + (quotationChar != null ? 1 : 0);
                        if (attribute != null) {
                            result.addAll(this.translateValues(documentItemOffset, this.filter(attribute.getPossibleValues(), prefix), quotationChar));
                            ValueCompletion<HtmlCompletionItem> valuesCompletion = AttrValuesCompletion.getSupport(node.name(), argName);
                            if (valuesCompletion != null) {
                                result.addAll(valuesCompletion.getItems(this.file, anchor, prefix));
                            }
                        }
                        HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, prefix, itemText, node, argName, quotationChar != null);
                        for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                            result.addAll(e.completeAttributeValue(context));
                        }
                    }
                }
            }
        }
        return result == null ? null : new CompletionResult(result, anchor);
    }

    private boolean usesLowerCase(HtmlParserResult result, int astOffset) {
        AstNode node = AstNodeUtils.getTagNode((AstNode)result.root(), (int)astOffset);
        return node != null ? Character.isLowerCase(node.name().charAt(0)) : true;
    }

    public List<CompletionItem> getAutocompletedEndTag(AstNode node, AstNode undeclaredTagsLeafNode, int astOffset, int documentOffset) {
        List<CompletionItem> result = this.getAutocompletedEndTag(node, astOffset, documentOffset);
        if (result == null) {
            result = this.getAutocompletedEndTag(undeclaredTagsLeafNode, astOffset, documentOffset);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public List<CompletionItem> getAutocompletedEndTag(AstNode node, int astOffset, int documentOffset) {
        if (node.type() == AstNode.NodeType.OPEN_TAG && node.endOffset() == astOffset && !node.isEmpty() && !AstNodeUtils.hasForbiddenEndTag((AstNode)node)) {
            return Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(node.name(), documentOffset));
        }
        return null;
    }

    private List<CompletionItem> translateCharRefs(int offset, Collection<? extends NamedCharRef> refs, String prefix) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(refs.size());
        for (NamedCharRef namedCharRef : refs) {
            String name = namedCharRef.getName();
            if (!name.startsWith(prefix)) continue;
            result.add(HtmlCompletionItem.createCharacterReference(name, namedCharRef.getValue(), offset, name));
        }
        return result;
    }

    private List<CompletionItem> getPossibleEndTags(HtmlParseResult htmlResult, AstNode leaf, AstNode undeclaredTagsLeafNode, int offset, String prefix) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.addAll(this.getPossibleEndTags(htmlResult, leaf, offset, prefix));
        items.addAll(this.getPossibleHtmlEndTagsForUndeclaredComponents(undeclaredTagsLeafNode, offset, prefix));
        return items;
    }

    private Collection<CompletionItem> getPossibleEndTags(HtmlParseResult htmlResult, AstNode leaf, int offset, String prefix) {
        Collection possible = htmlResult.getPossibleTagsInContext(leaf, false);
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        int order = 0;
        for (HtmlTag tag : possible) {
            String tagName = isXHtml ? tag.getName() : (lowerCase ? tag.getName().toLowerCase(Locale.ENGLISH) : tag.getName().toUpperCase(Locale.ENGLISH));
            items.add(HtmlCompletionItem.createEndTag(tagName, offset - 2 - prefix.length(), tagName, order++, this.getEndTagType(leaf)));
        }
        return items;
    }

    private List<CompletionItem> getPossibleHtmlEndTagsForUndeclaredComponents(AstNode leaf, int offset, String prefix) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        while (leaf.type() != AstNode.NodeType.ROOT) {
            if (leaf.type() == AstNode.NodeType.OPEN_TAG) {
                String tagName;
                String string = isXHtml ? leaf.name() : (tagName = lowerCase ? leaf.name().toLowerCase(Locale.ENGLISH) : leaf.name().toUpperCase(Locale.ENGLISH));
                if (tagName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) {
                    int order = offset - leaf.startOffset();
                    items.add(HtmlCompletionItem.createEndTag(tagName, offset - 2 - prefix.length(), tagName, order++, this.getEndTagType(leaf)));
                }
                if (leaf.needsToHaveMatchingTag() && leaf.getMatchingTag() == null) break;
            }
            leaf = leaf.parent();
            assert (leaf != null);
        }
        return items;
    }

    private HtmlCompletionItem.EndTag.Type getEndTagType(AstNode leaf) {
        if (leaf.getMatchingTag() != null) {
            return leaf.needsToHaveMatchingTag() ? HtmlCompletionItem.EndTag.Type.REQUIRED_EXISTING : HtmlCompletionItem.EndTag.Type.OPTIONAL_EXISTING;
        }
        return leaf.needsToHaveMatchingTag() ? HtmlCompletionItem.EndTag.Type.REQUIRED_MISSING : HtmlCompletionItem.EndTag.Type.OPTIONAL_MISSING;
    }

    private Collection<String> filter(Collection<?> col, String prefix) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (Object o : col) {
            String s = o.toString();
            if (!s.startsWith(prefix)) continue;
            filtered.add(s);
        }
        return filtered;
    }

    private Collection<HtmlTagAttribute> filterAttributes(Collection<HtmlTagAttribute> attrs, String prefix) {
        ArrayList<HtmlTagAttribute> filtered = new ArrayList<HtmlTagAttribute>();
        for (HtmlTagAttribute ta : attrs) {
            if (!ta.getName().startsWith(prefix)) continue;
            filtered.add(ta);
        }
        return filtered;
    }

    private Collection<HtmlTag> filterHtmlElements(Collection<HtmlTag> elements, String elementNamePrefix) {
        ArrayList<HtmlTag> filtered = new ArrayList<HtmlTag>();
        elementNamePrefix = elementNamePrefix.toLowerCase(Locale.ENGLISH);
        for (HtmlTag e : elements) {
            if (!e.getName().toLowerCase(Locale.ENGLISH).startsWith(elementNamePrefix)) continue;
            filtered.add(e);
        }
        return filtered;
    }

    List<CompletionItem> translateHtmlTags(int offset, Collection<HtmlTag> possible, Collection<HtmlTag> all) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(possible.size());
        HashSet<HtmlTag> allmodifiable = new HashSet<HtmlTag>(all);
        allmodifiable.removeAll(possible);
        for (HtmlTag e : possible) {
            result.add(this.item4HtmlTag(e, offset, true));
        }
        for (HtmlTag e : allmodifiable) {
            result.add(this.item4HtmlTag(e, offset, false));
        }
        return result;
    }

    private HtmlCompletionItem item4HtmlTag(HtmlTag e, int offset, boolean possible) {
        String name = e.getName();
        name = isXHtml ? name : (lowerCase ? name.toLowerCase(Locale.ENGLISH) : name.toUpperCase(Locale.ENGLISH));
        return HtmlCompletionItem.createTag(e, name, offset, name, possible);
    }

    Collection<CompletionItem> translateAttribs(int offset, Collection<HtmlTagAttribute> attribs, HtmlTag tag) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(attribs.size());
        String tagName = tag.getName() + "#";
        block3: for (HtmlTagAttribute attrib : attribs) {
            String name = attrib.getName();
            switch (attrib.getType()) {
                case BOOLEAN: {
                    result.add(HtmlCompletionItem.createBooleanAttribute(name, offset, attrib.isRequired(), tagName + name));
                    continue block3;
                }
            }
            result.add(HtmlCompletionItem.createAttribute(attrib, name, offset, attrib.isRequired(), tagName + name));
        }
        return result;
    }

    Collection<HtmlCompletionItem> translateValues(int offset, Collection<String> values) {
        return this.translateValues(offset, values, null);
    }

    Collection<HtmlCompletionItem> translateValues(int offset, Collection<String> values, String quotationChar) {
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<HtmlCompletionItem> result = new ArrayList<HtmlCompletionItem>(values.size());
        if (quotationChar != null) {
            ++offset;
        }
        for (String value : values) {
            result.add(HtmlCompletionItem.createAttributeValue(value, offset));
        }
        return result;
    }

    static {
        isXHtml = false;
    }

    public static class CompletionResult {
        private Collection<? extends CompletionItem> items;
        int anchor;

        CompletionResult(Collection<? extends CompletionItem> items, int anchor) {
            this.items = items;
            this.anchor = anchor;
        }

        public int getAnchor() {
            return this.anchor;
        }

        public Collection<? extends CompletionItem> getItems() {
            return this.items;
        }
    }
}

