/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.inspector.GlobalFolderRegistry;
import org.openide.util.Mutex;

final class FolderRegistry {
    private static final Map<String, WeakReference<FolderRegistry>> registries = new HashMap<String, WeakReference<FolderRegistry>>();
    private Mutex mutex = new Mutex();
    private HashMap<TypeID, InspectorFolder> folders = new HashMap();
    private GlobalFolderRegistry globalFolderRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FolderRegistry getRegistry(String projectType, String projectID) {
        Map<String, WeakReference<FolderRegistry>> map = registries;
        synchronized (map) {
            FolderRegistry registry;
            WeakReference<FolderRegistry> ref = registries.get(projectID);
            FolderRegistry folderRegistry = registry = ref != null ? (FolderRegistry)ref.get() : null;
            if (registry == null) {
                registry = new FolderRegistry(projectType);
                registries.put(projectID, new WeakReference<FolderRegistry>(registry));
            }
            return registry;
        }
    }

    private FolderRegistry(String projectType) {
        this.globalFolderRegistry = GlobalFolderRegistry.getGlobalFolderRegistry(projectType);
        this.reload();
    }

    private boolean isAccess() {
        return this.mutex.isReadAccess() || this.mutex.isWriteAccess();
    }

    void readAccess(final Runnable runnable) {
        this.globalFolderRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                FolderRegistry.this.mutex.readAccess(runnable);
            }
        });
    }

    private void writeAccess(final Runnable runnable) {
        this.globalFolderRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                FolderRegistry.this.mutex.writeAccess(runnable);
            }
        });
    }

    private void reload() {
        this.writeAccess(new Runnable(){

            @Override
            public void run() {
                FolderRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        HashMap<TypeID, InspectorFolder> tempFolders = new HashMap<TypeID, InspectorFolder>();
        Collection<InspectorFolder> _folders = this.globalFolderRegistry.getInspectorFolder();
        for (InspectorFolder folder : _folders) {
            tempFolders.put(folder.getTypeID(), folder);
        }
        this.folders = tempFolders;
    }

    Collection<InspectorFolder> getFolders() {
        assert (this.isAccess());
        return Collections.unmodifiableCollection(this.folders.values());
    }

    void addListener(Listener listener) {
        this.globalFolderRegistry.addListener(listener);
    }

    void removeListener(Listener listener) {
        this.globalFolderRegistry.removeListener(listener);
    }

    static interface Listener {
        public void notifyRegistryContentChange();
    }
}

