/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.JspConfig;
import org.netbeans.modules.j2ee.dd.api.web.JspPropertyGroup;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesPanelFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SectionValidator;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PagesMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private PagesPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String PAGES_MV_ID = "dd_multiviewPages";
    private static final String HELP_ID_PREFIX = "dd_multiview_pages_";

    public PagesMultiViewElement(DDDataObject dObj, int index) {
        super((XmlMultiViewDataObject)dObj);
        this.dObj = dObj;
        this.index = index;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PagesPanelFactory(this.comp, dObj);
        this.addAction = new AddAction(dObj, NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_addJspPG"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_remove"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagesMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new PagesView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            this.view.openPanel((Object)"welcome_files");
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (!(this.dObj.isChangedFromUI() || (name = evt.getPropertyName()).indexOf("WelcomeFileList") <= 0 && name.indexOf("JspConfig") <= 0 && name.indexOf("ErrorPage") <= 0 && name.indexOf("version") <= 0)) {
            if (PAGES_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TXT_removeJspGroupConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
                JspPropertyGroup group = (JspPropertyGroup)sectionPanel.getKey();
                try {
                    PagesMultiViewElement.this.dObj.modelUpdatedFromUI();
                    PagesMultiViewElement.this.dObj.setChangedFromUI(true);
                    PagesMultiViewElement.this.webApp.getSingleJspConfig().removeJspPropertyGroup(group);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                }
                catch (VersionNotSupportedException ex) {
                }
                finally {
                    PagesMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(DDDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_addJspPG_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            String[] labels = new String[]{NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_displayName"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_description"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"LBL_urlPatterns")};
            String[] a11y_desc = new String[]{NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_jsp_property_display_name"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_jsp_property_desc"), NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_jsp_property_url_pattern")};
            boolean[] buttons = new boolean[]{false, false, true};
            SimpleDialogPanel.DialogDescriptor descriptor = new SimpleDialogPanel.DialogDescriptor(labels, true);
            descriptor.setButtons(buttons);
            descriptor.setA11yDesc(a11y_desc);
            descriptor.setTextField(new boolean[]{true, false, true});
            final SimpleDialogPanel dialogPanel = new SimpleDialogPanel(descriptor);
            dialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_add_jsp_property_group"));
            dialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PagesMultiViewElement.class, (String)"ACSD_add_jsp_property_group"));
            dialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = DDUtils.getDocBaseGroups(PagesMultiViewElement.this.dObj);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String newValue;
                            String fileName = "/" + DDUtils.getResourcePath(groups, fo, '/', true);
                            String oldValue = dialogPanel.getValues()[2];
                            if (fileName.length() > 0 && !oldValue.equals(newValue = DDUtils.addItem(oldValue, fileName, false))) {
                                dialogPanel.getTextComponents()[2].setText(newValue);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            EditDialog dialog = new EditDialog((JPanel)dialogPanel, NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_JspPropertyGroup"), true){

                protected String validate() {
                    String[] values = dialogPanel.getValues();
                    String urlPatterns = values[2].trim();
                    return SectionValidator.validateNewJspPropertyGroup(urlPatterns);
                }
            };
            dialog.setValid(false);
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getTextComponents()[2].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getTextComponents()[2].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                PagesMultiViewElement.this.dObj.modelUpdatedFromUI();
                PagesMultiViewElement.this.dObj.setChangedFromUI(true);
                String[] values = dialogPanel.getValues();
                String name = values[0];
                String description = values[1];
                String urls = values[2].trim();
                try {
                    JspConfig jspConfig = null;
                    try {
                        jspConfig = PagesMultiViewElement.this.webApp.getSingleJspConfig();
                        if (jspConfig == null) {
                            jspConfig = (JspConfig)PagesMultiViewElement.this.webApp.createBean("JspConfig");
                            PagesMultiViewElement.this.webApp.setJspConfig(jspConfig);
                        }
                    }
                    catch (VersionNotSupportedException ex) {
                        // empty catch block
                    }
                    JspPropertyGroup group = (JspPropertyGroup)jspConfig.createBean("JspPropertyGroup");
                    if (name.length() > 0) {
                        group.setDisplayName(name);
                    }
                    if (description.length() > 0) {
                        group.setDescription(description);
                    }
                    String[] patterns = DDUtils.getStringArray(urls);
                    group.setUrlPattern(patterns);
                    jspConfig.addJspPropertyGroup(group);
                    PagesView view = (PagesView)PagesMultiViewElement.this.comp.getContentView();
                    JspPGNode node = new JspPGNode(view, group);
                    view.getJspPGsNode().getChildren().add(new Node[]{node});
                    SectionPanel pan = new SectionPanel((SectionView)view, (Node)node, view.getJspGroupTitle(group), (Object)group);
                    pan.setHeaderActions(new Action[]{PagesMultiViewElement.this.removeAction});
                    view.getJspGroupsContainer().addSection((NodeSectionPanel)pan, true);
                }
                catch (ClassNotFoundException ex) {
                }
                finally {
                    PagesMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class ErrorPagesNode
    extends AbstractNode {
        ErrorPagesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_errorPages"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/htmlObject.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_pages_errorPagesNode");
        }
    }

    private class WelcomeFilesNode
    extends AbstractNode {
        WelcomeFilesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_welcomeFiles"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/htmlObject.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_pages_welcomeFilesNode");
        }
    }

    private class JspPGNode
    extends AbstractNode {
        JspPGNode(PagesView view, JspPropertyGroup group) {
            super(Children.LEAF);
            this.setDisplayName(view.getJspGroupNodeName(group));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/jspObject.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_pages_jspPropertyGroupNode");
        }
    }

    class PagesView
    extends SectionView {
        private SectionContainer jspPGCont;
        private Node groupsNode;
        private Node welcomeFilesNode;
        private Node errorPagesNode;

        PagesView(WebApp webApp) {
            super((InnerPanelFactory)PagesMultiViewElement.this.factory);
            JspConfig jspConfig = null;
            JspPropertyGroup[] groups = null;
            boolean jspConfigSupported = true;
            try {
                jspConfig = webApp.getSingleJspConfig();
            }
            catch (VersionNotSupportedException ex) {
                jspConfigSupported = false;
            }
            this.welcomeFilesNode = new WelcomeFilesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.welcomeFilesNode, (Object)"welcome_files"));
            this.errorPagesNode = new ErrorPagesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.errorPagesNode, (Object)"error_pages"));
            Children.Array rootChildren = new Children.Array();
            if (jspConfigSupported) {
                groups = jspConfig == null ? new JspPropertyGroup[]{} : jspConfig.getJspPropertyGroup();
                Node[] nodes = new Node[groups.length];
                Children.Array ch = new Children.Array();
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = new JspPGNode(this, groups[i]);
                }
                ch.add(nodes);
                this.groupsNode = new SectionContainerNode((Children)ch);
                this.groupsNode.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_jspPropGroups"));
                this.groupsNode.setName("dd_multiview_pages_jspPropertyGroupsNode");
                this.jspPGCont = new SectionContainer((SectionView)this, this.groupsNode, NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_jspPropGroups"));
                this.jspPGCont.setHeaderActions(new Action[]{PagesMultiViewElement.this.addAction});
                SectionPanel[] pan = new SectionPanel[groups.length];
                for (int i = 0; i < nodes.length; ++i) {
                    pan[i] = new SectionPanel((SectionView)this, nodes[i], this.getJspGroupTitle(groups[i]), (Object)groups[i]);
                    pan[i].setHeaderActions(new Action[]{PagesMultiViewElement.this.removeAction});
                    this.jspPGCont.addSection((NodeSectionPanel)pan[i]);
                }
                this.addSection((NodeSectionPanel)this.jspPGCont);
                rootChildren.add(new Node[]{this.welcomeFilesNode, this.errorPagesNode, this.groupsNode});
            } else {
                PagesMultiViewElement.this.addAction.setEnabled(false);
                rootChildren.add(new Node[]{this.welcomeFilesNode, this.errorPagesNode});
            }
            AbstractNode root = new AbstractNode((Children)rootChildren);
            this.setRoot((Node)root);
        }

        Node getJspPGsNode() {
            return this.groupsNode;
        }

        Node getWelcomeFilesNode() {
            return this.welcomeFilesNode;
        }

        SectionContainer getJspGroupsContainer() {
            return this.jspPGCont;
        }

        String getJspGroupTitle(JspPropertyGroup jspGroup) {
            String name = jspGroup.getDefaultDisplayName();
            if (name == null) {
                name = NbBundle.getMessage(PagesMultiViewElement.class, (String)"NODE_JSP_GROUP");
            }
            String[] patterns = jspGroup.getUrlPattern();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < patterns.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(patterns[i]);
            }
            return NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_JSP_GROUP", (Object)name, (Object)buf.toString());
        }

        String getJspGroupNodeName(JspPropertyGroup jspGroup) {
            String displayName = jspGroup.getDefaultDisplayName();
            if (displayName != null) {
                return displayName;
            }
            return NbBundle.getMessage(PagesMultiViewElement.class, (String)"NODE_JSP_GROUP");
        }

        public Error validateView() {
            return SectionValidator.validatePages(PagesMultiViewElement.this.webApp);
        }
    }
}

