/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.AbsoluteOrdering;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.OrderingItemPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.RelativeOrderingPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AbsoluteOrderingPanel
extends SectionInnerPanel
implements ItemListener {
    private DDDataObject dObj;
    private WebApp webApp;
    private DefaultListModel listModel;
    private JButton bAdd;
    private JButton bDown;
    private JButton bEdit;
    private JButton bRemove;
    private JButton bUp;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JList listOrdering;

    public AbsoluteOrderingPanel(SectionView sectionView, DDDataObject dObj) {
        super(sectionView);
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.initComponents();
        this.listModel = new DefaultListModel();
        this.listOrdering.setModel(this.listModel);
        try {
            for (AbsoluteOrdering ordering : this.webApp.getAbsoluteOrdering()) {
                for (String name : ordering.getName()) {
                    this.listModel.addElement(name);
                }
            }
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void setValue(JComponent source, Object value) {
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.listOrdering = new JList();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.bUp = new JButton();
        this.bDown = new JButton();
        this.setMinimumSize(new Dimension(250, 150));
        this.jLabel1.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"LBL_AbsoluteOrder"));
        this.listOrdering.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.listOrdering);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbsoluteOrderingPanel.this.bAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Edit"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbsoluteOrderingPanel.this.bEditActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Remove"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbsoluteOrderingPanel.this.bRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bUp, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Up"));
        this.bUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbsoluteOrderingPanel.this.bUpActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDown, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Down"));
        this.bDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbsoluteOrderingPanel.this.bDownActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jScrollPane2, 0, 0, Short.MAX_VALUE).add(2, (Component)this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.bRemove, -1, -1, Short.MAX_VALUE).add((Component)this.bEdit, -1, -1, Short.MAX_VALUE).add((Component)this.bAdd, -1, -1, Short.MAX_VALUE).add((Component)this.bDown, -1, -1, Short.MAX_VALUE).add((Component)this.bUp, -1, -1, Short.MAX_VALUE)).add(92, 92, 92)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bAdd).addPreferredGap(0).add((Component)this.bEdit).addPreferredGap(0).add((Component)this.bRemove).addPreferredGap(0).add((Component)this.bUp).addPreferredGap(0).add((Component)this.bDown)).add((Component)this.jScrollPane2)).addContainerGap(31, Short.MAX_VALUE)));
    }

    private void bAddActionPerformed(ActionEvent evt) {
        String name = this.getNameFromUser("");
        if (name != null) {
            this.listModel.addElement(name);
            this.refreshDdModel();
        }
    }

    private void bEditActionPerformed(ActionEvent evt) {
        String name;
        int x = this.listOrdering.getSelectedIndex();
        if (x >= 0 && (name = this.getNameFromUser((String)this.listModel.get(x))) != null) {
            this.listModel.set(x, name);
            this.refreshDdModel();
        }
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int x = this.listOrdering.getSelectedIndex();
        if (x >= 0) {
            this.listModel.remove(x);
            this.refreshDdModel();
        }
    }

    private void bUpActionPerformed(ActionEvent evt) {
        int x = this.listOrdering.getSelectedIndex();
        if (x > 0) {
            this.exchange(x - 1);
            this.listOrdering.setSelectedIndex(x - 1);
            this.refreshDdModel();
        }
    }

    private void bDownActionPerformed(ActionEvent evt) {
        int x = this.listOrdering.getSelectedIndex();
        if (x >= 0 && x < this.listModel.size() - 1) {
            this.exchange(x);
            this.listOrdering.setSelectedIndex(x + 1);
            this.refreshDdModel();
        }
    }

    private String getNameFromUser(String value) {
        OrderingItemPanel p = new OrderingItemPanel(value);
        DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage(RelativeOrderingPanel.class, (String)"TTL_Ordering"));
        dd.createNotificationLineSupport();
        p.setDlgSupport(dd);
        dd.setOptionType(2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            return p.getResult();
        }
        return null;
    }

    private void exchange(int x) {
        Object tmp1 = this.listModel.get(x);
        Object tmp2 = this.listModel.get(x + 1);
        this.listModel.set(x, tmp2);
        this.listModel.set(x + 1, tmp1);
    }

    private void refreshDdModel() {
        try {
            AbsoluteOrdering ordering = this.webApp.newAbsoluteOrdering();
            AbsoluteOrdering[] orderings = new AbsoluteOrdering[1];
            String[] items = new String[this.listModel.size()];
            int maxi = this.listModel.size();
            for (int i = 0; i < maxi; ++i) {
                items[i] = (String)this.listModel.get(i);
            }
            ordering.setName(items);
            orderings[0] = ordering;
            this.webApp.setAbsoluteOrdering(orderings);
            this.dObj.modelUpdatedFromUI();
        }
        catch (VersionNotSupportedException e) {
            Logger.global.log(Level.SEVERE, "refresh of DD model failed", e);
        }
    }
}

