/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsfapi.spi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportHandle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class JsfSupportProvider {
    private static final Logger LOGGER = Logger.getLogger(JsfSupportProvider.class.getName());

    public static JsfSupport get(Source source) {
        FileObject fo = source.getFileObject();
        if (fo == null) {
            return null;
        }
        return JsfSupportProvider.get(fo);
    }

    public static JsfSupport get(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        return JsfSupportProvider.get(project);
    }

    public static synchronized JsfSupport get(Project project) {
        JsfSupportHandle handle = (JsfSupportHandle)project.getLookup().lookup(JsfSupportHandle.class);
        if (handle == null) {
            LOGGER.log(Level.FINE, "{0} does not have an instance of JsfSupportHandle in its lookup.", project);
            return null;
        }
        JsfSupport instance = handle.get();
        if (instance == null) {
            JsfSupportProvider provider = (JsfSupportProvider)Lookup.getDefault().lookup(JsfSupportProvider.class);
            if (provider == null) {
                LOGGER.warning("There's no instance of JsfSupportProvider registered in the global lookup!");
                return null;
            }
            instance = provider.getSupport(project);
            if (instance == null) {
                LOGGER.warning(String.format("The implementation %s of JsfSupportProvider returned no JsfSupport instance for project %s", provider.getClass().getName(), JsfSupportProvider.getProjectDisplayName(project)));
                return null;
            }
            handle.install(instance);
        }
        return instance;
    }

    private static String getProjectDisplayName(Project project) {
        return FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
    }

    public abstract JsfSupport getSupport(Project var1);
}

