/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.api.SharedSessionStateListener;
import org.netbeans.modules.dlight.management.api.impl.DataStorageManager;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;

public final class SharedStorageDLightSession
implements SessionStateListener {
    private final String storageUniqueKey;
    private final List<DLightSession> sessions = new ArrayList<DLightSession>();
    private CountDownLatch latch;
    private List<SharedSessionStateListener> sessionStateListeners = null;
    private DLightSession.SessionState state;

    SharedStorageDLightSession(String storageUniqueKey) {
        this.storageUniqueKey = storageUniqueKey;
    }

    public ServiceInfoDataStorage getServiceInfoStorage() {
        return DataStorageManager.getInstance().getServiceInfoDataStorageFor(this.storageUniqueKey);
    }

    public final void addIndicatorNotificationListener(IndicatorNotificationsListener l) {
        for (DLightSession session : this.sessions) {
            session.addIndicatorNotificationListener(l);
        }
    }

    public void addSessionStateListener(SharedSessionStateListener listener) {
        if (this.sessionStateListeners == null) {
            this.sessionStateListeners = new ArrayList<SharedSessionStateListener>();
        }
        if (!this.sessionStateListeners.contains(listener)) {
            this.sessionStateListeners.add(listener);
        }
    }

    public void removeSessionStateListener(SharedSessionStateListener listener) {
        if (this.sessionStateListeners == null) {
            return;
        }
        this.sessionStateListeners.remove(listener);
    }

    void setState(DLightSession.SessionState state) {
        DLightSession.SessionState oldState = this.state;
        this.state = state;
        if (this.sessionStateListeners != null) {
            for (SharedSessionStateListener l : this.sessionStateListeners.toArray(new SharedSessionStateListener[0])) {
                l.sessionStateChanged(this, oldState, state);
            }
        }
    }

    public DLightSession.SessionState getState() {
        return this.state;
    }

    public void addDLightSession(DLightSession session) {
        session.addSessionStateListener(this);
        this.sessions.add(session);
    }

    public void run() {
        this.latch = new CountDownLatch(this.sessions.size());
        this.setState(DLightSession.SessionState.RUNNING);
        for (DLightSession session : this.sessions) {
            session.start();
        }
    }

    public String getSorageUniqueKey() {
        return this.storageUniqueKey;
    }

    public void closeSession() {
        this.setState(DLightSession.SessionState.CLOSED);
        for (DLightSession session : this.sessions) {
            session.close();
        }
    }

    @Override
    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        switch (newState) {
            case ANALYZE: 
            case CLOSED: {
                this.latch.countDown();
                if (this.latch.getCount() != 0L) break;
                this.setState(DLightSession.SessionState.ANALYZE);
            }
        }
    }
}

