/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.support.impl.DiscoveryProjectGeneratorImpl;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DiscoveryExtension
implements IteratorExtension,
DiscoveryExtensionInterface {
    public void discoverArtifacts(Map<String, Object> map) {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        DiscoveryExtensionInterface.Applicable applicable = this.isApplicable(descriptor);
        if (applicable != null) {
            if (applicable.isApplicable()) {
                descriptor.setCompilerName(applicable.getCompilerName());
                descriptor.setDependencies(applicable.getDependencies());
                descriptor.setSearchPaths(applicable.getSearchPaths());
                descriptor.setRootFolder(applicable.getSourceRoot());
                descriptor.setErrors(applicable.getErrors());
            } else {
                descriptor.setErrors(applicable.getErrors());
            }
        }
    }

    public Set<FileObject> createProject(WizardDescriptor wizard) throws IOException {
        return new ImportProject(wizard).create();
    }

    @Override
    public void apply(Map<String, Object> map, Project project) throws IOException {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        descriptor.setProject(project);
        DiscoveryProjectGeneratorImpl generator = new DiscoveryProjectGeneratorImpl(descriptor);
        generator.makeProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryExtensionInterface.Applicable isApplicable(DiscoveryDescriptor descriptor) {
        SelectConfigurationPanel.MyProgress progress = new SelectConfigurationPanel.MyProgress();
        progress.start(0);
        try {
            ArrayList<String> errors = new ArrayList<String>();
            DiscoveryExtensionInterface.Applicable applicable = this.isApplicableExecLog(descriptor);
            if (applicable.isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable2 = applicable;
                return applicable2;
            }
            applicable = this.isApplicableDwarfExecutable(descriptor);
            if (applicable.isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable3 = applicable;
                return applicable3;
            }
            if (applicable.getErrors() != null) {
                errors.addAll(applicable.getErrors());
            }
            if ((applicable = this.isApplicableMakeLog(descriptor)).isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable4 = applicable;
                return applicable4;
            }
            if (applicable.getErrors() != null) {
                errors.addAll(applicable.getErrors());
            }
            if ((applicable = this.isApplicableDwarfFolder(descriptor)).isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable5 = applicable;
                return applicable5;
            }
            if (applicable.getErrors() != null) {
                errors.addAll(applicable.getErrors());
            }
            if (!errors.isEmpty()) {
                DiscoveryExtensionInterface.Applicable applicable6 = ApplicableImpl.getNotApplicable(errors);
                return applicable6;
            }
            DiscoveryExtensionInterface.Applicable applicable7 = ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NoExecutable_NoBaseFolder")));
            return applicable7;
        }
        finally {
            progress.done();
        }
    }

    private DiscoveryExtensionInterface.Applicable isApplicableDwarfExecutable(DiscoveryDescriptor descriptor) {
        String selectedExecutable = descriptor.getBuildResult();
        if (selectedExecutable == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        File file = new File(selectedExecutable);
        if (!file.exists()) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundExecutable", (Object)selectedExecutable)));
        }
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryExtension.findProvider("dwarf-executable");
        if (provider != null && provider.isApplicable(proxy)) {
            provider.getProperty("executable").setValue(selectedExecutable);
            provider.getProperty("libraries").setValue(new String[0]);
            DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy);
            if (canAnalyze.isApplicable()) {
                descriptor.setProvider(provider);
                return canAnalyze;
            }
            if (canAnalyze.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeExecutable", (Object)selectedExecutable)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableDwarfFolder(DiscoveryDescriptor descriptor) {
        String rootFolder = descriptor.getRootFolder();
        if (rootFolder == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryExtension.findProvider("dwarf-folder");
        if (provider != null && provider.isApplicable(proxy)) {
            provider.getProperty("folder").setValue(rootFolder);
            DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy);
            if (canAnalyze.isApplicable()) {
                descriptor.setProvider(provider);
                return canAnalyze;
            }
            if (canAnalyze.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeFolder", (Object)rootFolder)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableMakeLog(DiscoveryDescriptor descriptor) {
        String rootFolder = descriptor.getRootFolder();
        if (rootFolder == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        String logFile = descriptor.getBuildLog();
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryExtension.findProvider("make-log");
        if (provider != null && provider.isApplicable(proxy)) {
            provider.getProperty("make-log-file").setValue(logFile);
            DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy);
            if (canAnalyze.isApplicable()) {
                descriptor.setProvider(provider);
                return canAnalyze;
            }
            if (canAnalyze.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeBuildLog", (Object)logFile)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableExecLog(DiscoveryDescriptor descriptor) {
        String rootFolder = descriptor.getRootFolder();
        if (rootFolder == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        String logFile = descriptor.getExecLog();
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryExtension.findProvider("exec-log");
        if (provider != null) {
            provider.getProperty("exec-log-file").setValue(logFile);
            if (provider.isApplicable(proxy)) {
                DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy);
                if (canAnalyze.isApplicable()) {
                    descriptor.setProvider(provider);
                    return canAnalyze;
                }
                if (canAnalyze.getErrors().size() > 0) {
                    return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
                }
                return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeBuildLog", (Object)logFile)));
            }
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    public DiscoveryExtensionInterface.Applicable isApplicable(Map<String, Object> map, Project project) {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        return this.isApplicable(descriptor);
    }

    public boolean canApply(DiscoveryDescriptor descriptor) {
        if (!this.isApplicable(descriptor).isApplicable()) {
            return false;
        }
        String level = descriptor.getLevel();
        if (level == null || level.length() == 0) {
            return false;
        }
        DiscoveryProvider provider = descriptor.getProvider();
        if (provider == null) {
            return false;
        }
        if ("dwarf-executable".equals(provider.getID())) {
            String selectedExecutable = descriptor.getBuildResult();
            String additional = descriptor.getAditionalLibraries();
            provider.getProperty("executable").setValue(selectedExecutable);
            if (additional != null && additional.length() > 0) {
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(additional, ";");
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
                provider.getProperty("libraries").setValue(list.toArray(new String[list.size()]));
            } else {
                provider.getProperty("libraries").setValue(new String[0]);
            }
        } else if ("dwarf-folder".equals(provider.getID())) {
            String rootFolder = descriptor.getRootFolder();
            provider.getProperty("folder").setValue(rootFolder);
        } else if (!"make-log".equals(provider.getID()) && !"exec-log".equals(provider.getID())) {
            return false;
        }
        SelectConfigurationPanel.buildModel(descriptor);
        return !descriptor.isInvokeProvider() && descriptor.getConfigurations() != null && descriptor.getConfigurations().size() > 0 && descriptor.getIncludedFiles() != null;
    }

    @Override
    public boolean canApply(Map<String, Object> map, Project project) {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        descriptor.setProject(project);
        return this.canApply(descriptor);
    }

    public static DiscoveryProvider findProvider(String providerID) {
        for (DiscoveryProvider provider : Lookup.getDefault().lookupAll(DiscoveryProvider.class)) {
            if (!providerID.equals(provider.getID())) continue;
            provider.clean();
            return provider;
        }
        return null;
    }

    public void discoverProject(Map<String, Object> map, Project lastSelectedProject, IteratorExtension.ProjectKind projectKind) {
        ImportExecutable importer = new ImportExecutable(map, lastSelectedProject, projectKind);
        if (lastSelectedProject != null) {
            importer.process(this);
        }
    }

    public void discoverHeadersByModel(Project project) {
        DiscoveryManagerImpl.discoverHeadersByModel(project);
    }

    private static class ProjectProxyImpl
    implements ProjectProxy {
        private DiscoveryDescriptor descriptor;

        private ProjectProxyImpl(DiscoveryDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public boolean createSubProjects() {
            return false;
        }

        @Override
        public Project getProject() {
            return null;
        }

        @Override
        public String getMakefile() {
            return null;
        }

        @Override
        public String getSourceRoot() {
            return this.descriptor.getRootFolder();
        }

        @Override
        public String getExecutable() {
            return this.descriptor.getBuildResult();
        }

        @Override
        public String getWorkingFolder() {
            return null;
        }

        @Override
        public boolean mergeProjectProperties() {
            return false;
        }
    }
}

