/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.services;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardAction;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class DiscoveryManagerImpl {
    public static final String BUILD_LOG_KEY = "build-log";
    public static final String BUILD_EXEC_KEY = "exec-log";
    private static final RequestProcessor RP = new RequestProcessor("Discovery Manager Worker", 1);
    private static final Map<CsmProject, CsmProgressListener> listeners = new WeakHashMap<CsmProject, CsmProgressListener>();
    private static final Map<NativeProject, CsmProgressListener> listeners2 = new WeakHashMap<NativeProject, CsmProgressListener>();

    private DiscoveryManagerImpl() {
    }

    public static void projectBuilt(Project project, Map<String, Object> artifacts, boolean isIncremental) {
        RP.post((Runnable)new DiscoveryWorker(project, artifacts, isIncremental));
    }

    public static void discoverHeadersByModel(final Project project) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                final NativeProject np = (NativeProject)project.getLookup().lookup(NativeProject.class);
                ImportProject.logger.log(Level.INFO, "Post fixing of excluded header files for project {0}", np);
                CsmProgressAdapter listener = new CsmProgressAdapter(){

                    public void projectParsingFinished(CsmProject aCsmProject) {
                        ImportProject.logger.log(Level.INFO, "Model parsing finished and ready to fixing of excluded header files for project {0}", aCsmProject);
                        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)np);
                        if (csmProject != null && csmProject.equals(aCsmProject)) {
                            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                            listeners2.remove(np);
                            DiscoveryManagerImpl.fixExcludedHeaderFiles(project, ImportProject.logger);
                        }
                    }
                };
                listeners2.put(np, listener);
                CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            }
        });
    }

    public static void fixExcludedHeaderFiles(Project makeProject, Logger logger) {
        ProjectBridge bridge;
        CsmModel model = CsmModelAccessor.getModel();
        if (!(model instanceof ModelImpl) || makeProject == null) {
            if (logger != null) {
                logger.log(Level.INFO, "Failed fixing of excluded header files for project {0}", makeProject);
            }
            return;
        }
        NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
        if (np == null) {
            if (logger != null) {
                logger.log(Level.INFO, "Not found make project for fixing of excluded header files for project {0}", makeProject);
            }
            return;
        }
        CsmProject p = model.getProject((Object)np);
        if (p == null) {
            if (logger != null) {
                logger.log(Level.INFO, "Not found model project for fixing of excluded header files for project {0}", np);
            }
            return;
        }
        if (logger != null) {
            logger.log(Level.INFO, "Start fixing of excluded header files for project {0}", p);
        }
        HashSet<String> needCheck = new HashSet<String>();
        HashSet<String> needAdd = new HashSet<String>();
        HashMap<String, Item> normalizedItems = DiscoveryManagerImpl.initNormalizedNames(makeProject);
        for (CsmFile file : p.getAllFiles()) {
            ProjectBase pb;
            Set parentFiles;
            if (!(file instanceof FileImpl)) continue;
            FileImpl impl = (FileImpl)file;
            NativeFileItem item = impl.getNativeFileItem();
            if (item == null) {
                String path = ((Object)impl.getAbsolutePath()).toString();
                item = (NativeFileItem)normalizedItems.get(path);
            }
            boolean isLineDirective = false;
            if (item != null && item.getLanguage() == NativeFileItem.Language.C_HEADER && p instanceof ProjectBase && (parentFiles = (pb = (ProjectBase)p).getGraph().getParentFiles(file)).isEmpty()) {
                isLineDirective = true;
            }
            if (item != null && np.equals(item.getNativeProject()) && item.isExcluded()) {
                if (!(item instanceof Item)) continue;
                if (logger != null) {
                    logger.log(Level.FINE, "#fix excluded->included header for file {0}", impl.getAbsolutePath());
                }
                ProjectBridge.setExclude((Item)item, false);
                ProjectBridge.setHeaderTool((Item)item);
                if (!file.isHeaderFile()) continue;
                needCheck.add(item.getAbsolutePath());
                continue;
            }
            if (isLineDirective && item != null && np.equals(item.getNativeProject()) && !item.isExcluded()) {
                if (!(item instanceof Item)) continue;
                if (logger != null) {
                    logger.log(Level.FINE, "#fix included->excluded for file {0}", impl.getAbsolutePath());
                }
                ProjectBridge.setExclude((Item)item, true);
                continue;
            }
            if (item != null || !file.isHeaderFile()) continue;
            String path = ((Object)impl.getAbsolutePath()).toString();
            needAdd.add(path);
        }
        if ((needCheck.size() > 0 || needAdd.size() > 0) && (bridge = new ProjectBridge(makeProject)).isValid()) {
            if (needAdd.size() > 0) {
                Map<String, Folder> prefferedFolders = bridge.prefferedFolders();
                Iterator i$ = needAdd.iterator();
                while (i$.hasNext()) {
                    int i;
                    String path;
                    String name = path = (String)i$.next();
                    if (Utilities.isWindows()) {
                        path = path.replace('\\', '/');
                    }
                    if ((i = path.lastIndexOf(47)) < 0) continue;
                    String folderPath = path.substring(0, i);
                    Folder prefferedFolder = prefferedFolders.get(folderPath);
                    if (prefferedFolder == null) {
                        LinkedList<String> mkFolder = new LinkedList<String>();
                        while ((i = folderPath.lastIndexOf(47)) > 0) {
                            mkFolder.addLast(folderPath.substring(i + 1));
                            prefferedFolder = prefferedFolders.get(folderPath = folderPath.substring(0, i));
                            if (prefferedFolder == null) continue;
                        }
                        if (prefferedFolder != null) {
                            while (!mkFolder.isEmpty()) {
                                String segment = (String)mkFolder.pollLast();
                                prefferedFolder = prefferedFolder.addNewFolder(segment, segment, true, (Folder.Kind)null);
                                folderPath = folderPath + "/" + segment;
                                prefferedFolders.put(folderPath, prefferedFolder);
                            }
                        }
                    }
                    if (prefferedFolder == null) continue;
                    String relPath = bridge.getRelativepath(name);
                    Item item = bridge.getProjectItem(relPath);
                    if (item == null) {
                        item = bridge.createItem(name);
                        item = prefferedFolder.addItem(item);
                    }
                    if (item == null) continue;
                    ProjectBridge.setHeaderTool(item);
                    if (!MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) {
                        needCheck.add(path);
                    }
                    ProjectBridge.excludeItemFromOtherConfigurations(item);
                }
            }
            if (needCheck.size() > 0) {
                bridge.checkForNewExtensions(needCheck);
            }
        }
        DiscoveryManagerImpl.saveMakeConfigurationDescriptor(makeProject);
    }

    public static void saveMakeConfigurationDescriptor(Project lastSelectedProject) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            makeConfigurationDescriptor.setModified();
            makeConfigurationDescriptor.save();
            makeConfigurationDescriptor.checkForChangedItems(lastSelectedProject, null, null);
        }
    }

    public static HashMap<String, Item> initNormalizedNames(Project makeProject) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        HashMap<String, Item> normalizedItems = new HashMap<String, Item>();
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null && (makeConfigurationDescriptor = pdp.getConfigurationDescriptor()) != null) {
            for (Item item : makeConfigurationDescriptor.getProjectItems()) {
                normalizedItems.put(item.getNormalizedPath(), item);
            }
        }
        return normalizedItems;
    }

    private static final class DiscoveryWorker
    implements Runnable {
        private final Project project;
        private final Map<String, Object> artifacts;
        private final boolean isIncremental;

        DiscoveryWorker(Project project, Map<String, Object> artifacts, boolean isIncremental) {
            this.project = project;
            this.artifacts = artifacts;
            this.isIncremental = isIncremental;
        }

        @Override
        public void run() {
            DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension == null) {
                return;
            }
            String artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_EXEC_KEY);
            if (artifact != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("DW:rootFolder", this.findRoot());
                map.put("DW:execLogFile", artifact);
                map.put("DW:consolidationLevel", "file");
                if (this.isIncremental) {
                    map.put("DW:incremental", Boolean.TRUE);
                }
                if (extension.canApply(map, this.project)) {
                    try {
                        this.postModelTask();
                        extension.apply(map, this.project);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
                return;
            }
            artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_LOG_KEY);
            if (artifact != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("DW:rootFolder", this.findRoot());
                map.put("DW:logFile", artifact);
                map.put("DW:consolidationLevel", "file");
                if (this.isIncremental) {
                    map.put("DW:incremental", Boolean.TRUE);
                }
                if (extension.canApply(map, this.project)) {
                    try {
                        this.postModelTask();
                        extension.apply(map, this.project);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
                return;
            }
        }

        private String findRoot() {
            return DiscoveryWizardAction.findSourceRoot(this.project);
        }

        private void postModelTask() {
            NativeProject np = (NativeProject)this.project.getLookup().lookup(NativeProject.class);
            final CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)np);
            ImportProject.logger.log(Level.INFO, "Post fixing of excluded header files for project {0}", csmProject);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject aCsmProject) {
                    ImportProject.logger.log(Level.INFO, "Model parsing finished and ready to fixing of excluded header files for project {0}", aCsmProject);
                    if (csmProject.equals(aCsmProject)) {
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove(aCsmProject);
                        DiscoveryManagerImpl.fixExcludedHeaderFiles(DiscoveryWorker.this.project, ImportProject.logger);
                    }
                }
            };
            listeners.put(csmProject, listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
        }
    }
}

