/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.openide.util.Lookup;

public abstract class SelectorNode
extends CheckTreeNode {
    private SelectorChildren children;
    private String nodeName;
    private String displayName;
    private boolean valid = true;
    private Lookup lookup = null;

    public SelectorNode(String name, String displayName, Icon icon, SelectorChildren children) {
        super((Object)displayName, icon);
        this.init(displayName, name, children);
    }

    public SelectorNode(String name, String displayName, Icon icon, SelectorChildren children, Lookup lookup) {
        super((Object)displayName, icon);
        this.init(displayName, name, children);
        this.lookup = lookup;
    }

    public SelectorNode(String name, String displayName, Icon icon, SelectorChildren children, ContainerNode parent) {
        super((Object)displayName, icon);
        this.init(displayName, name, children);
        this.setParent((MutableTreeNode)((Object)parent));
    }

    public SelectorNode(String name, String displayName, Icon icon, SelectorChildren children, ContainerNode parent, Lookup lookup) {
        this(name, displayName, icon, children, parent);
        this.lookup = lookup;
    }

    private void init(String displayName, String name, SelectorChildren children) {
        this.nodeName = name;
        this.children = children;
        this.displayName = displayName;
        if (this.children != null) {
            this.children.setParent(this);
        }
    }

    public final Lookup getLookup() {
        if (this.lookup == null) {
            if (this.getParent() != null) {
                return this.getParent().getLookup();
            }
            return Lookup.EMPTY;
        }
        return this.lookup;
    }

    public final TreeNode getChildAt(int childIndex) {
        int size = this.children.getNodes().size();
        return (TreeNode)((Object)(childIndex <= size && childIndex >= 0 ? this.children.getNodes().get(childIndex) : null));
    }

    public int getChildCount() {
        return this.children.getNodeCount();
    }

    public int getChildCount(boolean forceRefresh) {
        return this.children.getNodeCount(forceRefresh);
    }

    public final int getIndex(TreeNode node) {
        return this.children.getNodes().indexOf(node);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Collection<ClientUtils.SourceCodeSelection> getRootMethods(boolean all) {
        ClientUtils.SourceCodeSelection signature;
        ArrayList<ClientUtils.SourceCodeSelection> roots = new ArrayList<ClientUtils.SourceCodeSelection>();
        if ((all || this.isFullyChecked()) && (signature = this.getSignature()) != null) {
            roots.add(signature);
        }
        return roots;
    }

    public final Collection<ClientUtils.SourceCodeSelection> getRootMethods() {
        return this.getRootMethods(false);
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final ContainerNode getParent() {
        TreeNode parent = super.getParent();
        if (parent == null || !(parent instanceof ContainerNode)) {
            return null;
        }
        return (ContainerNode)((Object)parent);
    }

    public abstract ClientUtils.SourceCodeSelection getSignature();

    public final boolean isValid() {
        return this.valid;
    }

    public final Enumeration children() {
        return Collections.enumeration(this.children.getNodes());
    }

    public final void detach() {
        this.parent = null;
    }

    public boolean equals(Object anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        if (!(anotherNode instanceof SelectorNode)) {
            return false;
        }
        if (((SelectorNode)((Object)anotherNode)).getSignature() != null && this.getSignature() != null) {
            return ((SelectorNode)((Object)anotherNode)).getSignature().equals((Object)this.getSignature());
        }
        return ((SelectorNode)((Object)anotherNode)).getNodeName().equals(this.getNodeName());
    }

    public int hashCode() {
        return this.getNodeName().hashCode() + (this.getSignature() != null ? this.getSignature().hashCode() : 0);
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected final void setChildren(SelectorChildren children) {
        this.children = children;
        this.children.setParent(this);
    }

    protected final void setValid(boolean value) {
        this.valid = value;
    }

    protected final void updateDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

