/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.node;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class RootNode
extends AbstractNode {
    private static final RequestProcessor REFRESH_PROCESSOR = new RequestProcessor("Server registry update/refresh", 5);
    private static final String SERVERS_ICON = "org/netbeans/modules/server/ui/resources/servers.png";
    private static final Logger LOGGER = Logger.getLogger(RootNode.class.getName());
    private static RootNode node;

    private RootNode(ChildFactory factory) {
        super(Children.create((org.openide.nodes.ChildFactory)factory, (boolean)true));
        this.setName("");
        this.setDisplayName(NbBundle.getMessage(RootNode.class, (String)"Server_Registry_Node_Name"));
        this.setShortDescription(NbBundle.getMessage(RootNode.class, (String)"Server_Registry_Node_Short_Description"));
        this.setIconBaseWithExtension(SERVERS_ICON);
    }

    public static synchronized RootNode getInstance() {
        if (node == null) {
            ChildFactory factory = new ChildFactory();
            factory.init();
            node = new RootNode(factory);
        }
        return node;
    }

    public Action[] getActions(boolean context) {
        Action[] arr = Utilities.actionsForPath((String)"Servers/Actions").toArray(new Action[0]);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null || !Boolean.TRUE.equals(arr[i].getValue("serverNodeHidden"))) continue;
            arr[i] = null;
        }
        return arr;
    }

    static void enableActionsOnExpand() {
        FileObject fo = FileUtil.getConfigFile((String)"Servers/Actions");
        if (fo != null) {
            for (FileObject o : fo.getChildren()) {
                Enumeration en = o.getAttributes();
                while (en.hasMoreElements()) {
                    String attr = (String)en.nextElement();
                    boolean enable = false;
                    String prefix = "property-";
                    if (attr.startsWith("property-")) {
                        if (System.getProperty(attr = attr.substring("property-".length())) != null) {
                            enable = true;
                        }
                    } else {
                        String config = "config-";
                        if (attr.startsWith("config-") && FileUtil.getConfigFile((String)(attr = attr.substring("config-".length()))) != null) {
                            enable = true;
                        }
                    }
                    if (!enable) continue;
                    Lookup l = Lookups.forPath((String)"Servers/Actions");
                    for (Lookup.Item item : l.lookupResult(Action.class).allItems()) {
                        if (!item.getId().contains(o.getName())) continue;
                        Action a = (Action)item.getInstance();
                        a.actionPerformed(new ActionEvent((Object)RootNode.getInstance(), 0, "noui"));
                    }
                }
            }
        }
    }

    private static class InstanceComparator
    implements Comparator<ServerInstance>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(ServerInstance o1, ServerInstance o2) {
            boolean firstNull = false;
            boolean secondNull = false;
            if (o1.getDisplayName() == null) {
                LOGGER.log(Level.INFO, "Instance display name is null for {0}", o1);
                firstNull = true;
            }
            if (o2.getDisplayName() == null) {
                LOGGER.log(Level.INFO, "Instance display name is null for {0}", o2);
                secondNull = true;
            }
            if (firstNull && secondNull) {
                return 0;
            }
            if (firstNull && !secondNull) {
                return -1;
            }
            if (!firstNull && secondNull) {
                return 1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    }

    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<ServerInstance>
    implements ChangeListener,
    Runnable {
        private static final Comparator<ServerInstance> COMPARATOR = new InstanceComparator();
        private final List<ServerInstanceProvider> types = new ArrayList<ServerInstanceProvider>();
        private static boolean actionsPropertiesDone;

        public void init() {
            REFRESH_PROCESSOR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ChildFactory childFactory = ChildFactory.this;
                    synchronized (childFactory) {
                        ServerRegistry registry = ServerRegistry.getInstance();
                        registry.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)ChildFactory.this, (Object)registry));
                        ChildFactory.this.updateState(new ChangeEvent(registry));
                    }
                }
            });
        }

        @Override
        public void stateChanged(final ChangeEvent e) {
            REFRESH_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    ChildFactory.this.updateState(e);
                }
            });
        }

        private synchronized void updateState(ChangeEvent e) {
            if (e.getSource() instanceof ServerRegistry) {
                for (ServerInstanceProvider type : this.types) {
                    type.removeChangeListener(this);
                }
                this.types.clear();
                this.types.addAll(((ServerRegistry)e.getSource()).getProviders());
                for (ServerInstanceProvider type : this.types) {
                    type.addChangeListener(this);
                }
            }
            this.refresh();
        }

        protected final void refresh() {
            this.refresh(false);
        }

        protected Node createNodeForKey(ServerInstance key) {
            return key.getFullNode();
        }

        protected boolean createKeys(List<ServerInstance> toPopulate) {
            ArrayList<ServerInstance> fresh = new ArrayList<ServerInstance>();
            Mutex.EVENT.readAccess((Runnable)this);
            ServerRegistry registry = ServerRegistry.getInstance();
            for (ServerInstanceProvider serverInstanceProvider : registry.getProviders()) {
                List<ServerInstance> instances = serverInstanceProvider.getInstances();
                for (ServerInstance instance : instances) {
                    assert (instance != null) : "ServerInstance returned by provider " + serverInstanceProvider + " is null";
                    if (instance == null) continue;
                    fresh.add(instance);
                }
            }
            Collections.sort(fresh, COMPARATOR);
            toPopulate.addAll(fresh);
            return true;
        }

        @Override
        public void run() {
            if (actionsPropertiesDone) {
                return;
            }
            assert (EventQueue.isDispatchThread());
            actionsPropertiesDone = true;
            RootNode.enableActionsOnExpand();
            REFRESH_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    ServerRegistry.getInstance().getProviders();
                }
            });
        }
    }
}

