/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.support.Catalog;
import org.netbeans.lib.terminalemulator.support.FontPanel;
import org.netbeans.lib.terminalemulator.support.TermOptions;

public final class TermOptionsPanel
extends JPanel {
    private TermOptions termOptions;
    private final Term term;
    private Action act;
    static final String LBL_ChooseForegroundColor = Catalog.get("LBL_ChooseForegroundColor");
    static final String LBL_ChooseBackgroundColor = Catalog.get("LBL_ChooseBackgroundColor");
    static final String LBL_ChooseSelectionBackgroundColor = Catalog.get("LBL_ChooseSelectionBackgroundColor");
    static final String LBL_Options = Catalog.get("LBL_Options");
    static final String CTL_Restore = Catalog.get("CTL_Restore");
    static final String LBL_Font = Catalog.get("LBL_Font");
    static final String CTL_Ellipsis = Catalog.get("CTL_Ellipsis");
    static final String LBL_FontSize = Catalog.get("LBL_FontSize");
    static final String LBL_ForegroundColor = Catalog.get("LBL_ForegroundColor");
    static final String LBL_BackgroundColor = Catalog.get("LBL_BackgroundColor");
    static final String LBL_SelectionBackgroundColor = Catalog.get("LBL_SelectionBackgroundColor");
    static final String LBL_HistorySize = Catalog.get("LBL_HistorySize");
    static final String LBL_TabSize = Catalog.get("LBL_TabSize");
    static final String CTL_ClickToType = Catalog.get("CTL_ClickToType");
    static final String CTL_ScrollOnInput = Catalog.get("CTL_ScrollOnInput");
    static final String CTL_ScrollOnOutput = Catalog.get("CTL_ScrollOnOutput");
    static final String LBL_WrapLines = Catalog.get("LBL_WrapLines");
    static final String LBL_Preview = Catalog.get("LBL_Preview");
    static final String LBL_IgnoreKeymap = Catalog.get("LBL_IgnoreKeymap");
    private static final int MNM_Restore = Catalog.mnemonic("MNM_Restore");
    private static final int MNM_Font = Catalog.mnemonic("MNM_Font");
    private static final int MNM_FontSize = Catalog.mnemonic("MNM_FontSize");
    private static final int MNM_ForegroundColor = Catalog.mnemonic("MNM_ForegroundColor");
    private static final int MNM_BackgroundColor = Catalog.mnemonic("MNM_BackgroundColor");
    private static final int MNM_SelectionBackgroundColor = Catalog.mnemonic("MNM_SelectionBackgroundColor");
    private static final int MNM_HistorySize = Catalog.mnemonic("MNM_HistorySize");
    private static final int MNM_TabSize = Catalog.mnemonic("MNM_TabSize");
    private static final int MNM_ClickToType = Catalog.mnemonic("MNM_ClickToType");
    private static final int MNM_ScrollOnInput = Catalog.mnemonic("MNM_ScrollOnInput");
    private static final int MNM_ScrollOnOutput = Catalog.mnemonic("MNM_ScrollOnOutput");
    private static final int MNM_WrapLines = Catalog.mnemonic("MNM_WrapLines");
    private static final int MNM_IgnoreKeymap = Catalog.mnemonic("MNM_IgnoreKeymap");
    private static final int MNM_Preview = Catalog.mnemonic("MNM_Preview");
    private final PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TermOptionsPanel.this.refreshView();
        }
    };
    private JButton backgroundButton;
    private JLabel backgroundLabel;
    private JCheckBox clickToTypeCheckBox;
    private JLabel descriptionLabel;
    private JPanel filler;
    private JButton fontButton;
    private JLabel fontLabel;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JTextField fontText;
    private JButton foregroundButton;
    private JLabel foregroundLabel;
    private JLabel historySizeLabel;
    private JSpinner historySizeSpinner;
    private JCheckBox ignoreKeymapCheckBox;
    private JCheckBox lineWrapCheckBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JButton restoreButton;
    private JCheckBox scrollOnInputCheckBox;
    private JCheckBox scrollOnOutputCheckBox;
    private JButton selectionButton;
    private JLabel selectionLabel;
    private JLabel tabSizeLabel;
    private JSpinner tabSizeSpinner;

    public TermOptionsPanel() {
        this.initComponents();
        this.term = new Term();
        String line1String = Catalog.get("MSG_Hello") + "\r\n";
        char[] line1 = line1String.toCharArray();
        this.term.putChars(line1, 0, line1.length);
        Border termBorder = BorderFactory.createLoweredBevelBorder();
        this.term.setBorder(termBorder);
        this.term.pushStream(new LineDiscipline());
        this.term.setRowsColumns(7, 60);
        this.term.setClickToType(true);
        this.previewPanel.add((Component)this.term, "Center");
    }

    public void setTermOptions(TermOptions termOptions) {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        this.termOptions = termOptions;
        if (this.termOptions != null) {
            this.termOptions.addPropertyChangeListener(this.propertyListener);
        }
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        try {
            this.applyTermOptions();
        }
        finally {
            if (this.termOptions != null) {
                this.termOptions.addPropertyChangeListener(this.propertyListener);
            }
        }
        this.previewTermOptions();
    }

    private void applyTermOptions() {
        this.fontSizeSpinner.setValue(this.termOptions.getFontSize());
        this.fontText.setText(this.termOptions.getFont().getFamily() + " " + this.termOptions.getFont().getSize());
        this.foregroundButton.setBackground(this.termOptions.getForeground());
        this.backgroundButton.setBackground(this.termOptions.getBackground());
        this.selectionButton.setBackground(this.termOptions.getSelectionBackground());
        this.historySizeSpinner.setValue(this.termOptions.getHistorySize());
        this.tabSizeSpinner.setValue(this.termOptions.getTabSize());
        this.clickToTypeCheckBox.setSelected(this.termOptions.getClickToType());
        this.scrollOnInputCheckBox.setSelected(this.termOptions.getScrollOnInput());
        this.scrollOnOutputCheckBox.setSelected(this.termOptions.getScrollOnOutput());
        this.lineWrapCheckBox.setSelected(this.termOptions.getLineWrap());
        this.ignoreKeymapCheckBox.setSelected(this.termOptions.getIgnoreKeymap());
    }

    private void patchSizes() {
        this.term.invalidate();
        this.previewPanel.validate();
        this.previewPanel.invalidate();
        this.validate();
        this.invalidate();
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JFrame)) continue;
            ((JFrame)p).pack();
            break;
        }
    }

    private void previewTermOptions() {
        if (this.term == null) {
            return;
        }
        this.term.setFixedFont(true);
        this.term.setFont(this.termOptions.getFont());
        this.term.setBackground(this.termOptions.getBackground());
        this.term.setForeground(this.termOptions.getForeground());
        this.term.setHighlightColor(this.termOptions.getSelectionBackground());
        this.term.setHistorySize(this.termOptions.getHistorySize());
        this.term.setTabSize(this.termOptions.getTabSize());
        this.term.setClickToType(this.termOptions.getClickToType());
        this.term.setScrollOnInput(this.termOptions.getScrollOnInput());
        this.term.setScrollOnOutput(this.termOptions.getScrollOnOutput());
        this.term.setHorizontallyScrollable(!this.termOptions.getLineWrap());
        this.term.setRowsColumns(7, 60);
        this.patchSizes();
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.restoreButton = new JButton();
        this.fontLabel = new JLabel();
        this.fontText = new JTextField();
        this.fontButton = new JButton();
        this.fontSizeLabel = new JLabel();
        this.fontSizeSpinner = new JSpinner();
        this.foregroundLabel = new JLabel();
        this.foregroundButton = new JButton();
        this.act = new ColorAction(this.foregroundButton, LBL_ChooseForegroundColor);
        this.foregroundButton.setAction(this.act);
        this.backgroundLabel = new JLabel();
        this.backgroundButton = new JButton();
        this.act = new ColorAction(this.backgroundButton, LBL_ChooseBackgroundColor);
        this.backgroundButton.setAction(this.act);
        this.selectionLabel = new JLabel();
        this.selectionButton = new JButton();
        this.act = new ColorAction(this.selectionButton, LBL_ChooseSelectionBackgroundColor);
        this.selectionButton.setAction(this.act);
        this.historySizeLabel = new JLabel();
        this.historySizeSpinner = new JSpinner();
        this.tabSizeLabel = new JLabel();
        this.tabSizeSpinner = new JSpinner();
        this.clickToTypeCheckBox = new JCheckBox();
        this.scrollOnInputCheckBox = new JCheckBox();
        this.scrollOnOutputCheckBox = new JCheckBox();
        this.lineWrapCheckBox = new JCheckBox();
        this.ignoreKeymapCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.descriptionLabel.setText(LBL_Options);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.restoreButton.setMnemonic(MNM_Restore);
        this.restoreButton.setText(CTL_Restore);
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.restoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.restoreButton, gridBagConstraints);
        this.fontLabel.setDisplayedMnemonic(MNM_Font);
        this.fontLabel.setText(LBL_Font);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontLabel, gridBagConstraints);
        this.fontText.setColumns(20);
        this.fontText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontText, gridBagConstraints);
        this.fontButton.setText(CTL_Ellipsis);
        this.fontButton.setMaximumSize(new Dimension(20, 20));
        this.fontButton.setMinimumSize(new Dimension(20, 20));
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.chooseFont(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontButton, gridBagConstraints);
        this.fontSizeLabel.setDisplayedMnemonic(MNM_FontSize);
        this.fontSizeLabel.setLabelFor(this.fontSizeSpinner);
        this.fontSizeLabel.setText(LBL_FontSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontSizeLabel, gridBagConstraints);
        this.fontSizeSpinner.setModel(new SpinnerNumberModel(12, 8, 48, 1));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.fontSizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontSizeSpinner, gridBagConstraints);
        this.foregroundLabel.setDisplayedMnemonic(MNM_ForegroundColor);
        this.foregroundLabel.setLabelFor(this.foregroundButton);
        this.foregroundLabel.setText(LBL_ForegroundColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.foregroundLabel, gridBagConstraints);
        this.foregroundButton.setBorder(BorderFactory.createBevelBorder(0));
        this.foregroundButton.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.foregroundButton, gridBagConstraints);
        this.backgroundLabel.setDisplayedMnemonic(MNM_BackgroundColor);
        this.backgroundLabel.setLabelFor(this.backgroundButton);
        this.backgroundLabel.setText(LBL_BackgroundColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.backgroundLabel, gridBagConstraints);
        this.backgroundButton.setBorder(BorderFactory.createBevelBorder(0));
        this.backgroundButton.setPreferredSize(new Dimension(20, 20));
        this.backgroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.backgroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.backgroundButton, gridBagConstraints);
        this.selectionLabel.setDisplayedMnemonic(MNM_SelectionBackgroundColor);
        this.selectionLabel.setLabelFor(this.selectionButton);
        this.selectionLabel.setText(LBL_SelectionBackgroundColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.selectionLabel, gridBagConstraints);
        this.selectionButton.setBorder(BorderFactory.createBevelBorder(0));
        this.selectionButton.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.selectionButton, gridBagConstraints);
        this.historySizeLabel.setDisplayedMnemonic(MNM_HistorySize);
        this.historySizeLabel.setLabelFor(this.historySizeSpinner);
        this.historySizeLabel.setText(LBL_HistorySize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.historySizeLabel, gridBagConstraints);
        this.historySizeSpinner.setModel(new SpinnerNumberModel(4000, 0, 50000, 10));
        this.historySizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.historySizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.historySizeSpinner, gridBagConstraints);
        this.tabSizeLabel.setDisplayedMnemonic(MNM_TabSize);
        this.tabSizeLabel.setLabelFor(this.tabSizeSpinner);
        this.tabSizeLabel.setText(LBL_TabSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.tabSizeLabel, gridBagConstraints);
        this.tabSizeSpinner.setModel(new SpinnerNumberModel(5, 1, 16, 1));
        this.tabSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.tabSizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.tabSizeSpinner, gridBagConstraints);
        this.clickToTypeCheckBox.setMnemonic(MNM_ClickToType);
        this.clickToTypeCheckBox.setText(CTL_ClickToType);
        this.clickToTypeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.clickToTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.clickToTypeCheckBox, gridBagConstraints);
        this.scrollOnInputCheckBox.setMnemonic(MNM_ScrollOnInput);
        this.scrollOnInputCheckBox.setText(CTL_ScrollOnInput);
        this.scrollOnInputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnInputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.scrollOnInputCheckBox, gridBagConstraints);
        this.scrollOnOutputCheckBox.setMnemonic(MNM_ScrollOnOutput);
        this.scrollOnOutputCheckBox.setText(CTL_ScrollOnOutput);
        this.scrollOnOutputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.scrollOnOutputCheckBox, gridBagConstraints);
        this.lineWrapCheckBox.setMnemonic(MNM_WrapLines);
        this.lineWrapCheckBox.setText(LBL_WrapLines);
        this.lineWrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.lineWrapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.lineWrapCheckBox, gridBagConstraints);
        this.ignoreKeymapCheckBox.setMnemonic(MNM_IgnoreKeymap);
        this.ignoreKeymapCheckBox.setText(LBL_IgnoreKeymap);
        this.ignoreKeymapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.ignoreKeymapCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.ignoreKeymapCheckBox, gridBagConstraints);
        this.previewLabel.setDisplayedMnemonic(MNM_Preview);
        this.previewLabel.setLabelFor(this.previewPanel);
        this.previewLabel.setText(LBL_Preview);
        this.add((Component)this.previewLabel, new GridBagConstraints());
        this.previewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.previewPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.previewPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.filler, gridBagConstraints);
    }

    private void restoreActionPerformed(ActionEvent evt) {
        this.termOptions.resetToDefault();
        this.refreshView();
    }

    private void fontSizeSpinnerStateChanged(ChangeEvent evt) {
        int fontSize = this.termOptions.getFontSize();
        Object fontSizeObj = this.fontSizeSpinner.getValue();
        if (fontSizeObj instanceof Integer) {
            fontSize = (Integer)fontSizeObj;
            this.termOptions.setFontSize(fontSize);
        }
    }

    private void historySizeSpinnerStateChanged(ChangeEvent evt) {
        int historySize = this.termOptions.getHistorySize();
        Object historySizeObj = this.historySizeSpinner.getValue();
        if (historySizeObj instanceof Integer) {
            historySize = (Integer)historySizeObj;
            this.termOptions.setHistorySize(historySize);
        }
    }

    private void tabSizeSpinnerStateChanged(ChangeEvent evt) {
        int tabSize = this.termOptions.getTabSize();
        Object tabSizeObj = this.tabSizeSpinner.getValue();
        if (tabSizeObj instanceof Integer) {
            tabSize = (Integer)tabSizeObj;
            this.termOptions.setTabSize(tabSize);
        }
    }

    private void clickToTypeActionPerformed(ActionEvent evt) {
        this.termOptions.setClickToType(this.clickToTypeCheckBox.isSelected());
    }

    private void scrollOnInputActionPerformed(ActionEvent evt) {
        this.termOptions.setScrollOnInput(this.scrollOnInputCheckBox.isSelected());
    }

    private void scrollOnOutputActionPerformed(ActionEvent evt) {
        this.termOptions.setScrollOnOutput(this.scrollOnOutputCheckBox.isSelected());
    }

    private void lineWrapActionPerformed(ActionEvent evt) {
        this.termOptions.setLineWrap(this.lineWrapCheckBox.isSelected());
    }

    String getStyleName(int i) {
        if ((i & 1) > 0) {
            if ((i & 2) > 0) {
                return "CTL_BoldItalic";
            }
            return "CTL_Bold";
        }
        if ((i & 2) > 0) {
            return "CTL_Italic";
        }
        return "CTL_Plain";
    }

    private void chooseFont(ActionEvent evt) {
        FontPanel panel = new FontPanel(this.termOptions.getFont(), this);
        int choice = JOptionPane.showOptionDialog(this.previewPanel, panel, Catalog.get("LBL_Title"), 2, -1, null, null, null);
        if (choice == 0) {
            this.termOptions.setFont(panel.font());
            this.applyTermOptions();
        }
    }

    private void backgroundButtonActionPerformed(ActionEvent evt) {
    }

    private void ignoreKeymapCheckBoxActionPerformed(ActionEvent evt) {
        this.termOptions.setIgnoreKeymap(this.ignoreKeymapCheckBox.isSelected());
    }

    private class ColorAction
    extends AbstractAction {
        private final String name;
        private final JButton button;

        public ColorAction(JButton button, String name) {
            this.button = button;
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            Color initialColor = null;
            if (this.button == TermOptionsPanel.this.foregroundButton) {
                initialColor = TermOptionsPanel.this.termOptions.getForeground();
            } else if (this.button == TermOptionsPanel.this.backgroundButton) {
                initialColor = TermOptionsPanel.this.termOptions.getBackground();
            } else if (this.button == TermOptionsPanel.this.selectionButton) {
                initialColor = TermOptionsPanel.this.termOptions.getSelectionBackground();
            }
            Color newColor = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, this.button), this.name, initialColor);
            if (newColor != null) {
                this.button.setBackground(newColor);
                if (this.button == TermOptionsPanel.this.foregroundButton) {
                    TermOptionsPanel.this.termOptions.setForeground(newColor);
                } else if (this.button == TermOptionsPanel.this.backgroundButton) {
                    TermOptionsPanel.this.termOptions.setBackground(newColor);
                } else if (this.button == TermOptionsPanel.this.selectionButton) {
                    TermOptionsPanel.this.termOptions.setSelectionBackground(newColor);
                }
            }
        }
    }
}

