/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ExportDiffPanel
extends ChangesetPickerPanel {
    private RepositoryRevision repoRev;
    private File fileToDiff;
    private final File repo;
    ExportDiffSupport.AbstractExportDiffPanel p;

    public ExportDiffPanel(File repo, RepositoryRevision repoRev, File[] roots, File fileToDiff) {
        super(repo, roots);
        this.fileToDiff = fileToDiff;
        this.repoRev = repoRev;
        this.repo = repo;
        this.initComponents();
    }

    public String getOutputFileName() {
        return this.p.getOutputFileText();
    }

    void setInsidePanel(ExportDiffSupport.AbstractExportDiffPanel insidePanel) {
        this.p = insidePanel;
        this.setDefaultOutputFile();
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        optionsPanel.add((Component)this.p, "North");
        this.setOptionsPanel(optionsPanel, new EmptyBorder(0, 0, 0, 0));
        this.loadRevisions();
    }

    @Override
    protected RepositoryRevision getDisplayedRevision() {
        return this.repoRev;
    }

    @Override
    protected String getRevisionLabel(RepositoryRevision repoRev) {
        String revStr = super.getRevisionLabel(repoRev);
        if (this.fileToDiff != null) {
            revStr = this.fileToDiff.getName() + " - " + revStr;
        }
        return revStr.toString();
    }

    @Override
    protected String getRefreshLabel() {
        return NbBundle.getMessage(ExportDiffPanel.class, (String)"MSG_Fetching_Revisions");
    }

    private void initComponents() {
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.jLabel1.text"));
        if (this.fileToDiff != null) {
            Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.revisionsLabel.text.forFileDiff"));
            this.jLabel2.setText(NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.exportHintLabel.text.forFileDiff"));
        } else {
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ExportDiffPanel.class, (String)"LBL_EXPORT_INFO"));
        }
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportDiffPanel.class, (String)"ExportDiffPanel.AccessibleContext.accessibleDescription"));
    }

    private void setDefaultOutputFile() {
        String fileName;
        String folderName = HgModuleConfig.getDefault().getPreferences().get("ExportDiff.saveFolder", HgModuleConfig.getDefault().getExportFolder());
        if (this.fileToDiff != null && this.repoRev != null && this.repoRev.getLog() != null && this.repo != null) {
            fileName = this.fileToDiff.getName().replace('.', '-') + "_" + this.repoRev.getLog().getRevisionNumber() + "_" + this.repoRev.getLog().getCSetShortID();
        } else if (this.repoRev != null && this.repoRev.getLog() != null && this.repo != null) {
            fileName = HgModuleConfig.getDefault().getExportFilename().replace("%b", this.repo.getName());
            fileName = fileName.replace("%r", this.repoRev.getLog().getRevisionNumber());
            fileName = fileName.replace("%h", this.repoRev.getLog().getCSetShortID());
        } else {
            fileName = this.repo != null ? HgModuleConfig.getDefault().getExportFilename().replace("%b", this.repo.getName()) : HgModuleConfig.getDefault().getExportFilename();
        }
        File file = new File(folderName, fileName + ".patch");
        this.p.setOutputFileText(file.getAbsolutePath());
    }
}

