/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSelectionManager;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;

public class XChartSelectionOverlay
extends ChartOverlay {
    private static final boolean FORCE_SPEED = Utils.forceSpeed();
    private ChartComponent chart;
    private int selectionMode;
    private Rectangle selectionBounds;
    private Rectangle oldSelectionBounds;
    private SelectionListener selectionListener;
    private ConfigurationListener configurationListener;
    private boolean renderingOptimized;
    private Paint linePaint;
    private Stroke lineStroke;
    private int lineWidth = -1;
    private Paint fillPaint;
    private Stroke oddPerfStroke;
    private Stroke evenPerfStroke;
    private boolean drawTop;
    private boolean drawBottom;
    private boolean drawLeft;
    private boolean drawRight;
    private final TimelineSupport support;

    public XChartSelectionOverlay(TimelineSupport support) {
        this.support = support;
        this.selectionListener = new SelectionListener();
        this.configurationListener = new ConfigurationListener();
        this.initDefaultValues();
    }

    public final void registerChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = chart;
        this.selectionMode = chart.getSelectionModel().getSelectionMode();
        this.registerListener();
    }

    public final void unregisterChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = null;
    }

    public final void setRenderingOptimized(boolean renderingOptimized) {
        this.renderingOptimized = renderingOptimized;
    }

    public final boolean isRenderingOptimized() {
        return this.renderingOptimized;
    }

    public final void setLineStroke(Stroke lineStroke) {
        this.lineStroke = lineStroke;
        this.lineWidth = -1;
    }

    public final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public final void setLinePaint(Paint linePaint) {
        this.linePaint = linePaint;
    }

    public final Paint getLinePaint() {
        return this.linePaint;
    }

    public final void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public final Paint getFillPaint() {
        return this.fillPaint;
    }

    public final void setLineMode(boolean drawTop, boolean drawLeft, boolean drawBottom, boolean drawRight) {
        this.drawTop = drawTop;
        this.drawLeft = drawLeft;
        this.drawBottom = drawBottom;
        this.drawRight = drawRight;
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this.selectionListener);
        this.chart.addConfigurationListener((ChartConfigurationListener)this.configurationListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.getSelectionModel().removeSelectionListener((ChartSelectionListener)this.selectionListener);
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.configurationListener);
    }

    private void initDefaultValues() {
        this.setRenderingOptimized(true);
        Color systemSelection = Utils.getSystemSelection();
        this.setLineStroke(new BasicStroke(1.0f));
        this.setLinePaint(systemSelection);
        this.setFillPaint(new Color(systemSelection.getRed(), systemSelection.getGreen(), systemSelection.getBlue(), 80));
        this.oddPerfStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f, 6.0f}, 6.0f);
        this.evenPerfStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f, 6.0f}, 0.0f);
        this.setLineMode(true, true, true, true);
    }

    private int getLineWidth() {
        if (this.lineWidth == -1) {
            this.lineWidth = FORCE_SPEED ? 1 : (int)Math.ceil(Utils.getStrokeWidth((Stroke)this.lineStroke));
        }
        return this.lineWidth;
    }

    private Rectangle normalizeRect(Rectangle rect, int border) {
        if (rect.width < 0) {
            rect.x += rect.width;
            rect.width = 0 - rect.width;
        }
        rect.y = 0;
        rect.height = this.getHeight();
        rect.grow(border, border);
        return rect;
    }

    public void paint(Graphics g) {
        if (this.selectionBounds == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle bounds = this.normalizeRect(new Rectangle(this.selectionBounds), 0);
        if (this.selectionBounds.width != 0) {
            if (bounds.width == 0 || bounds.height == 0 || this.chart.fitsWidth() && this.chart.fitsHeight()) {
                return;
            }
            if (this.fillPaint != null && !FORCE_SPEED) {
                Rectangle clip = g.getClipBounds();
                if (clip == null) {
                    clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                }
                g2.setPaint(this.fillPaint);
                g2.fill(clip.intersection(bounds));
            }
            if (!FORCE_SPEED && this.linePaint != null && this.lineStroke != null) {
                g2.setPaint(this.linePaint);
                g2.setStroke(this.lineStroke);
                this.drawRect(g2, bounds.x, bounds.y, bounds.width, bounds.height);
            } else if (FORCE_SPEED) {
                g2.setPaint(Color.BLACK);
                g2.setStroke(this.evenPerfStroke);
                this.drawRect(g2, bounds.x, bounds.y, bounds.width, bounds.height);
                g2.setPaint(Color.WHITE);
                g2.setStroke(this.oddPerfStroke);
                this.drawRect(g2, bounds.x, bounds.y, bounds.width, bounds.height);
            }
        } else if (!FORCE_SPEED) {
            g2.setPaint(this.selectionMode == 4 ? this.fillPaint : this.linePaint);
            g2.setStroke(this.lineStroke);
            g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
        } else if (FORCE_SPEED) {
            g2.setPaint(Color.BLACK);
            g2.setStroke(this.evenPerfStroke);
            g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
            g2.setPaint(Color.WHITE);
            g2.setStroke(this.oddPerfStroke);
            g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
        }
    }

    private void drawRect(Graphics g, int x, int y, int w, int h) {
        if (this.drawTop) {
            g.drawLine(x, y, x + w - 1, y);
        }
        if (this.drawLeft) {
            g.drawLine(x, y, x, y + h - 1);
        }
        if (this.drawRight) {
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
        }
        if (this.drawBottom) {
            g.drawLine(x + w - 1, y + h - 1, x, y + h - 1);
        }
    }

    private void updateSelection() {
        this.oldSelectionBounds = this.selectionBounds;
        this.selectionBounds = this.getCurrentBounds();
        if (this.selectionMode == 4) {
            this.rectBoundsChanged(this.selectionBounds, this.oldSelectionBounds, this.getLineWidth());
        }
    }

    private Rectangle getCurrentBounds() {
        int endIndex;
        TimelineSelectionManager manager = (TimelineSelectionManager)this.chart.getSelectionModel();
        int startIndex = manager.getStartIndex();
        if (startIndex > (endIndex = manager.getEndIndex())) {
            endIndex = startIndex;
            startIndex = manager.getEndIndex();
        }
        if (startIndex == -1) {
            return null;
        }
        if (startIndex == endIndex) {
            ChartContext context = this.chart.getChartContext();
            long timestamp = this.support.getTimestamp(startIndex);
            int x = Utils.checkedInt((double)context.getViewX((double)timestamp));
            return new Rectangle(x, 0, 0, this.chart.getHeight());
        }
        ChartContext context = this.chart.getChartContext();
        long startTimestamp = this.support.getTimestamp(startIndex);
        long endTimestamp = this.support.getTimestamp(endIndex);
        int startX = Utils.checkedInt((double)context.getViewX((double)startTimestamp));
        int endX = Utils.checkedInt((double)context.getViewX((double)endTimestamp));
        return new Rectangle(startX, 0, endX - startX, this.chart.getHeight());
    }

    private void rectBoundsChanged(Rectangle newBounds, Rectangle oldBounds, int lineW) {
        if (newBounds != null && oldBounds != null) {
            int x = newBounds.x + newBounds.width;
            int y = newBounds.y + newBounds.height;
            if (this.renderingOptimized) {
                boolean crossY;
                int selX = newBounds.x;
                int selY = newBounds.y;
                int oldX = oldBounds.x + oldBounds.width;
                int oldY = oldBounds.y + oldBounds.height;
                int dx = Math.min(x, oldX);
                int dwidth = Math.max(x, oldX) - dx;
                int dy = Math.min(y, oldY);
                int dheight = Math.max(y, oldY) - dy;
                boolean crossX = oldBounds.width * newBounds.width < 0;
                boolean bl = crossY = oldBounds.height * newBounds.height < 0;
                if (crossX || crossY) {
                    if (crossX && !crossY) {
                        int cheight = oldBounds.height < 0 ? Math.min(oldBounds.height, newBounds.height) : Math.max(oldBounds.height, newBounds.height);
                        this.paintRect(dx, selY, dwidth, cheight, lineW);
                    } else if (!crossX && crossY) {
                        int cwidth = oldBounds.width < 0 ? Math.min(oldBounds.width, newBounds.width) : Math.max(oldBounds.width, newBounds.width);
                        this.paintRect(selX, dy, cwidth, dheight, lineW);
                    } else {
                        this.paintRect(dx, dy, dwidth, dheight, lineW);
                    }
                } else if (selX <= x) {
                    if (selY <= y) {
                        this.paintRect(dx, selY, dwidth, dy - selY + dheight, lineW);
                        this.paintRect(selX, dy, dx - selX + dwidth, dheight, lineW);
                    } else {
                        this.paintRect(dx, dy, dwidth, selY - dy, lineW);
                        this.paintRect(selX, dy, dx - selX, dheight, lineW);
                    }
                } else if (selY <= y) {
                    this.paintRect(dx, selY, dwidth, dy - selY + dheight, lineW);
                    this.paintRect(dx + dwidth, dy, selX - dx, dheight, lineW);
                } else {
                    this.paintRect(dx, dy, dwidth, selY - dy, lineW);
                    this.paintRect(dx + dwidth, dy, selX - dx - dwidth, dheight, lineW);
                }
            } else {
                Rectangle oldB = this.normalizeRect(oldBounds, lineW);
                Rectangle newB = this.normalizeRect(new Rectangle(newBounds), lineW);
                this.repaint(oldB.union(newB));
            }
            return;
        }
        if (oldBounds != null) {
            this.paintImmediately(this.normalizeRect(new Rectangle(oldBounds), lineW));
        } else if (newBounds != null) {
            this.paintImmediately(this.normalizeRect(new Rectangle(newBounds), lineW));
        }
    }

    private void paintRect(int x, int y, int w, int h, int t) {
        this.paintImmediately(this.normalizeRect(new Rectangle(x, y, w, h), t));
    }

    private class ConfigurationListener
    extends ChartConfigurationListener.Adapter {
        private ConfigurationListener() {
        }

        public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
            if (lastOffsetX != offsetX || lastScaleX != scaleX || lastScaleY != scaleY) {
                XChartSelectionOverlay.this.updateSelection();
            }
        }
    }

    private class SelectionListener
    implements ChartSelectionListener {
        private boolean modeChanged = false;

        private SelectionListener() {
        }

        public void selectionModeChanged(int newMode, int oldMode) {
            XChartSelectionOverlay.this.selectionMode = newMode;
            this.modeChanged = true;
        }

        public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
            if (this.modeChanged) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectionListener.this.modeChanged = false;
                        XChartSelectionOverlay.this.oldSelectionBounds = XChartSelectionOverlay.this.selectionBounds;
                        XChartSelectionOverlay.this.selectionBounds = XChartSelectionOverlay.this.getCurrentBounds();
                        int lineWidth = XChartSelectionOverlay.this.getLineWidth();
                        Rectangle rect = XChartSelectionOverlay.this.normalizeRect(new Rectangle(XChartSelectionOverlay.this.oldSelectionBounds == null ? XChartSelectionOverlay.this.getBounds() : XChartSelectionOverlay.this.oldSelectionBounds), lineWidth);
                        XChartSelectionOverlay.this.paintImmediately(rect);
                        if (XChartSelectionOverlay.this.selectionBounds != null) {
                            rect = XChartSelectionOverlay.this.normalizeRect(new Rectangle(XChartSelectionOverlay.this.selectionBounds), lineWidth);
                            XChartSelectionOverlay.this.paintImmediately(rect);
                        }
                    }
                });
            } else {
                XChartSelectionOverlay.this.updateSelection();
            }
        }

        public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        }

        public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        }
    }
}

