/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.variablesfilterring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class JSPVariablesFilter
implements TreeModelFilter {
    private static final boolean verbose = true;
    private static HashSet hiddenLocals = null;
    private static HashSet leafType = null;

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        Object[] visibleChildren = null;
        if (parent.equals(original.getRoot())) {
            int parentChildrenCount = original.getChildrenCount(parent);
            Object[] children = original.getChildren(parent, 0, parentChildrenCount);
            if ((parentChildrenCount = children.length) == 1 && children[0] instanceof String) {
                return children;
            }
            ArrayList<Object> visibleChildrenList = new ArrayList<Object>();
            ImplicitLocals implicitLocals = new ImplicitLocals();
            Object refThis = null;
            AttributeMap requestAttributes = new AttributeMap("request");
            AttributeMap sessionAttributes = new AttributeMap("session");
            AttributeMap applicationAttributes = new AttributeMap("application");
            for (int i = 0; i < parentChildrenCount; ++i) {
                Object var = children[i];
                if (var instanceof LocalVariable) {
                    LocalVariable lvar = (LocalVariable)var;
                    if (ImplicitLocals.isImplicitLocal(lvar.getName())) {
                        implicitLocals.addLocal(lvar);
                        if (!(lvar instanceof ObjectVariable)) continue;
                        String varName = lvar.getName();
                        if (varName.equals("request")) {
                            requestAttributes = new AttributeMap((ObjectVariable)lvar);
                            continue;
                        }
                        if (varName.equals("session")) {
                            sessionAttributes = new AttributeMap((ObjectVariable)lvar);
                            continue;
                        }
                        if (!varName.equals("application")) continue;
                        applicationAttributes = new AttributeMap((ObjectVariable)lvar);
                        continue;
                    }
                    if (JSPVariablesFilter.isHiddenLocal(lvar.getName())) continue;
                    visibleChildrenList.add(var);
                    continue;
                }
                if (!(var instanceof This)) continue;
                refThis = var;
            }
            visibleChildrenList.add(0, applicationAttributes);
            visibleChildrenList.add(0, sessionAttributes);
            visibleChildrenList.add(0, requestAttributes);
            if (refThis != null) {
                visibleChildrenList.add(0, refThis);
            }
            visibleChildrenList.add(implicitLocals);
            if (to > visibleChildrenList.size()) {
                to = visibleChildrenList.size();
            }
            visibleChildren = visibleChildrenList.subList(from, to).toArray();
        } else {
            visibleChildren = parent instanceof ImplicitLocals ? ((ImplicitLocals)parent).getLocals().subList(from, to).toArray() : (parent instanceof AttributeMap ? ((AttributeMap)parent).getAttributes().subList(from, to).toArray() : (parent instanceof AttributeMap.Attribute ? original.getChildren((Object)((AttributeMap.Attribute)parent).getValue(), from, to) : original.getChildren(parent, from, to)));
        }
        return visibleChildren;
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        int countVisible = 0;
        if (node.equals(original.getRoot())) {
            countVisible = original.getChildrenCount(node);
            Object[] children = original.getChildren(node, 0, countVisible);
            if ((countVisible = children.length) == 1 && children[0] instanceof String) {
                return countVisible;
            }
            for (int i = 0; i < children.length; ++i) {
                Object var = children[i];
                if (var instanceof LocalVariable) {
                    if (!JSPVariablesFilter.isHiddenLocal(((LocalVariable)var).getName()) && !ImplicitLocals.isImplicitLocal(((LocalVariable)var).getName())) continue;
                    --countVisible;
                    continue;
                }
                if (var instanceof This) continue;
                --countVisible;
            }
            countVisible += 4;
        } else {
            countVisible = node instanceof ImplicitLocals ? ((ImplicitLocals)node).getLocals().size() : (node instanceof AttributeMap ? ((AttributeMap)node).getAttributes().size() : (node instanceof AttributeMap.Attribute ? original.getChildrenCount((Object)((AttributeMap.Attribute)node).getValue()) : original.getChildrenCount(node)));
        }
        return countVisible;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        Variable attributeValue;
        boolean il = node instanceof ImplicitLocals ? false : (node instanceof AttributeMap ? false : (node instanceof AttributeMap.Attribute ? (JSPVariablesFilter.isLeafType((attributeValue = ((AttributeMap.Attribute)node).getValue()).getType()) ? true : original.isLeaf((Object)attributeValue)) : original.isLeaf(node)));
        return il;
    }

    public void removeModelListener(ModelListener l) {
    }

    public void addModelListener(ModelListener l) {
    }

    private static boolean isHiddenLocal(String aLocalName) {
        if (hiddenLocals == null) {
            hiddenLocals = new HashSet();
            hiddenLocals.add("_jspxFactory");
            hiddenLocals.add("_jspx_out");
            hiddenLocals.add("_jspx_page_context");
        }
        return hiddenLocals.contains(aLocalName);
    }

    private static boolean isLeafType(String type) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(type);
    }

    public static class AttributeMap {
        private ArrayList attributes = new ArrayList();
        private ObjectVariable owner = null;
        private String ownerName = null;

        public AttributeMap(String aOwnerName) {
            this.setOwnerName(aOwnerName);
        }

        public AttributeMap(ObjectVariable aVar) {
            this.owner = aVar;
            this.setOwnerName(((LocalVariable)this.owner).getName());
            AttributeIterator it = new AttributeIterator();
            while (it.hasNext()) {
                Attribute attribute = (Attribute)it.next();
                if (attribute == null) continue;
                this.attributes.add(attribute);
            }
        }

        private void setOwnerName(String aOwnerName) {
            if (!(aOwnerName.equals("request") || aOwnerName.equals("session") || aOwnerName.equals("application"))) {
                throw new UnknownOwnerNameException(aOwnerName);
            }
            this.ownerName = aOwnerName;
        }

        public ArrayList getAttributes() {
            return this.attributes;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        private class AttributeIterator
        implements Iterator {
            ObjectVariable reqAttributes = null;

            public AttributeIterator() {
                try {
                    this.reqAttributes = (ObjectVariable)AttributeMap.this.owner.invokeMethod("getAttributeNames", "()Ljava/util/Enumeration;", new Variable[0]);
                }
                catch (InvalidExpressionException e) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                if (this.reqAttributes == null) {
                    return false;
                }
                boolean ret = false;
                try {
                    Variable hasMoreElements = this.reqAttributes.invokeMethod("hasMoreElements", "()Z", new Variable[0]);
                    ret = hasMoreElements != null && "true".equals(hasMoreElements.getValue());
                }
                catch (InvalidExpressionException e) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return ret;
            }

            public Object next() {
                Attribute nextElement = null;
                try {
                    Variable attributeName = this.reqAttributes.invokeMethod("nextElement", "()Ljava/lang/Object;", new Variable[0]);
                    if (attributeName != null) {
                        Variable attributeValue = AttributeMap.this.owner.invokeMethod("getAttribute", "(Ljava/lang/String;)Ljava/lang/Object;", new Variable[]{attributeName});
                        nextElement = new Attribute(attributeName.getValue() == null ? "" : attributeName.getValue(), attributeValue);
                    }
                }
                catch (InvalidExpressionException e) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return nextElement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        public class Attribute {
            private String name;
            private Variable value;

            public Attribute(String aName, Variable aValue) {
                this.name = aName;
                this.value = aValue;
            }

            public String getName() {
                return this.name;
            }

            public Variable getValue() {
                return this.value;
            }
        }

        public static class UnknownOwnerNameException
        extends RuntimeException {
            public UnknownOwnerNameException(String name) {
                super("Unknown owner name: " + name);
            }
        }
    }

    public static class ImplicitLocals {
        private List locals = new ArrayList();
        private static HashSet localsNames = null;

        public static boolean isImplicitLocal(String aLocalName) {
            if (localsNames == null) {
                localsNames = new HashSet();
                localsNames.add("application");
                localsNames.add("config");
                localsNames.add("out");
                localsNames.add("page");
                localsNames.add("pageContext");
                localsNames.add("request");
                localsNames.add("response");
                localsNames.add("session");
            }
            return localsNames.contains(aLocalName);
        }

        void addLocal(LocalVariable local) {
            this.locals.add(local);
        }

        List getLocals() {
            return this.locals;
        }

        public boolean equals(Object o) {
            return o instanceof ImplicitLocals;
        }

        public int hashCode() {
            if (this.locals.size() == 0) {
                return super.hashCode();
            }
            return this.locals.get(0).hashCode();
        }
    }
}

