/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.DataRowNode;
import org.netbeans.modules.dlight.visualizers.api.impl.AdvancedTableViewVisualizerConfigurationAccessor;
import org.netbeans.modules.dlight.visualizers.ui.AbstractDataRowNodeFactory;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class AdvancedTableDataRowNodeFactory
extends AbstractDataRowNodeFactory {
    private static final Image NULL_ICON = new BufferedImage(1, 1, 2);
    private final DataTableMetadata metadata;
    private final NodeActionsProvider nodeActionsProvider;
    private final String nodeColumnName;
    private final String iconColumnID;
    private final String resourceID;
    private final Lookup lookup;

    public AdvancedTableDataRowNodeFactory(AdvancedTableViewVisualizerConfiguration configuration, Lookup lookup) {
        this.lookup = lookup;
        this.metadata = configuration.getMetadata();
        AdvancedTableViewVisualizerConfigurationAccessor accessor = AdvancedTableViewVisualizerConfigurationAccessor.getDefault();
        this.nodeActionsProvider = accessor.getNodeActionProvider(configuration);
        this.nodeColumnName = accessor.getRowNodeColumnName(configuration);
        this.iconColumnID = accessor.getIconColumnID(configuration);
        this.resourceID = this.iconColumnID == null ? null : accessor.getIconPath(configuration);
    }

    @Override
    public DataRowNode createNode(DataRow row) {
        return new AdvancedDataRowNode(row);
    }

    private class AdvancedDataRowNode
    extends DataRowNode {
        private String displayName;
        private Action defaultAction;

        AdvancedDataRowNode(DataRow row) {
            super(row, AdvancedTableDataRowNodeFactory.this.lookup);
        }

        protected Sheet createSheet() {
            Sheet result = new Sheet();
            Sheet.Set set = new Sheet.Set();
            for (String columnName : this.getDataRow().getColumnNames()) {
                final DataTableMetadata.Column c = AdvancedTableDataRowNodeFactory.this.metadata.getColumnByName(columnName);
                PropertySupport.ReadOnly property = new PropertySupport.ReadOnly(columnName, c.getColumnClass(), c.getColumnUName(), c.getColumnLongUName()){

                    public Object getValue() throws IllegalAccessException, InvocationTargetException {
                        return AdvancedDataRowNode.this.getDataRow().getData(c.getColumnName());
                    }
                };
                set.put((Node.Property)property);
            }
            result.put(set);
            return result;
        }

        public synchronized Action getPreferredAction() {
            if (this.defaultAction == null) {
                this.defaultAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (AdvancedTableDataRowNodeFactory.this.nodeActionsProvider != null) {
                            try {
                                AdvancedTableDataRowNodeFactory.this.nodeActionsProvider.performDefaultAction((Object)AdvancedDataRowNode.this);
                            }
                            catch (UnknownTypeException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }

                    @Override
                    public boolean isEnabled() {
                        return AdvancedTableDataRowNodeFactory.this.nodeActionsProvider != null;
                    }
                };
            }
            return this.defaultAction;
        }

        public Action[] getActions(boolean context) {
            if (AdvancedTableDataRowNodeFactory.this.nodeActionsProvider == null) {
                return new Action[0];
            }
            try {
                return AdvancedTableDataRowNodeFactory.this.nodeActionsProvider.getActions((Object)this);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public Image getIcon(int type) {
            if (AdvancedTableDataRowNodeFactory.this.iconColumnID == null) {
                return NULL_ICON;
            }
            return ImageUtilities.loadImage((String)(AdvancedTableDataRowNodeFactory.this.resourceID + "/" + this.getDataRow().getStringValue(AdvancedTableDataRowNodeFactory.this.iconColumnID) + ".png"));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public synchronized String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.getDataRow().getData(AdvancedTableDataRowNodeFactory.this.nodeColumnName) + "";
            }
            return this.displayName;
        }
    }
}

