/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.ui.TextFilterPanel;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.TableViewBusyPanel;
import org.netbeans.modules.dlight.visualizers.TableViewEmptyPanel;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.VisualizerToolbarComponent;
import org.netbeans.modules.dlight.visualizers.api.VisualizerToolbarComponentsProvider;
import org.netbeans.modules.dlight.visualizers.ui.TableViewNodeChildren;
import org.netbeans.modules.dlight.visualizers.util.TableViewDataFilter;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class TableViewVisualizer<Config extends TableBasedVisualizerConfiguration, Data>
extends JPanel
implements Visualizer<Config>,
ExplorerManager.Provider,
Lookup.Provider,
VisualizerToolbarComponentsProvider {
    private static final RequestProcessor RP = new RequestProcessor("TableViewVisualizer Data Refresh", 10);
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private final ExplorerManager manager = new ExplorerManager();
    private final JPanel busyPanel;
    private final JPanel dataPanel;
    private final JPanel contentPanel;
    private final Config configuration;
    private final InstanceContent content = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.content);
    private final RequestProcessor.Task busyPanelDisplayTask;
    private final JButton refreshBtn;
    private final RequestProcessor.Task dataFetchTask;
    private final TextFilterPanel textFilterPanel = new TextFilterPanel();
    private final ChangeListener filterListener;
    private final AtomicReference<List<Data>> dataRef = new AtomicReference();
    private final ComponentListener componentListener;
    private final AtomicBoolean isVisible = new AtomicBoolean();
    private TableViewNodeChildren<Data> children;
    private JPanel emptyPanel;

    protected TableViewVisualizer(DataProvider provider, Config configuration) {
        this.configuration = configuration;
        this.content.add((Object)provider);
        this.setLayout(new BorderLayout());
        this.busyPanel = new TableViewBusyPanel();
        this.dataPanel = new JPanel(new BorderLayout());
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)this.busyPanel, "busy");
        this.contentPanel.add((Component)this.dataPanel, "data");
        this.add((Component)this.contentPanel, "Center");
        this.dataFetchTask = RP.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TableViewVisualizer.this.dataRef.set(TableViewVisualizer.this.getUpdatedData());
                    TableViewVisualizer.this.updateView();
                }
                catch (Exception ex) {
                    try {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TableViewVisualizer.this.refreshBtn.setEnabled(true);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.busyPanelDisplayTask = RP.create(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (!TableViewVisualizer.this.dataFetchTask.isFinished()) {
                                ((CardLayout)TableViewVisualizer.this.contentPanel.getLayout()).show(TableViewVisualizer.this.contentPanel, "busy");
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JToolBar toolbar = new JToolBar(1);
        if (isMacLaf) {
            toolbar.setBackground(macBackground);
        }
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        this.refreshBtn = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewVisualizer.this.refresh();
            }
        });
        this.refreshBtn.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refreshBtn.setToolTipText(NbBundle.getMessage(TableViewVisualizer.class, (String)"Refresh.Tooltip"));
        toolbar.add(this.refreshBtn);
        this.add((Component)toolbar, "West");
        this.filterListener = new ChangeListener(){
            private TableViewDataFilter<Data> currentFilter;

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                final String filter = ((TextFilterPanel)e.getSource()).getText();
                if (this.currentFilter != null) {
                    TableViewVisualizer.this.content.remove(this.currentFilter);
                }
                this.currentFilter = new TableViewDataFilter<Data>(){

                    @Override
                    public boolean matches(Data data) {
                        return TableViewVisualizer.this.matchesFilter(filter, data);
                    }
                };
                TableViewVisualizer.this.content.add(this.currentFilter);
                TableViewVisualizer.this.updateView();
            }
        };
        this.textFilterPanel.addChangeListener(this.filterListener);
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (TableViewVisualizer.this.isVisible.compareAndSet(false, true)) {
                    TableViewVisualizer.this.registerListeners();
                    TableViewVisualizer.this.refresh();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (TableViewVisualizer.this.isVisible.compareAndSet(true, false)) {
                    TableViewVisualizer.this.unregisterListeners();
                }
            }
        };
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void registerListeners() {
        KeyStroke refreshKey = KeyStroke.getKeyStroke(82, 128, true);
        this.getInputMap(1).put(refreshKey, "refresh");
        this.getActionMap().put("refresh", this.refreshBtn.getAction());
    }

    private void unregisterListeners() {
        KeyStroke refreshKey = KeyStroke.getKeyStroke(82, 128, true);
        this.getInputMap(1).remove(refreshKey);
        this.getActionMap().remove("refresh");
        this.resetKeyboardActions();
    }

    public void init() {
        this.emptyPanel = new TableViewEmptyPanel(this.getEmptyRunningMessage(), this.getEmptyAnalyzeMessage());
        this.contentPanel.add((Component)this.emptyPanel, "empty");
        this.dataPanel.add(this.initTableView(), "Center");
        this.children = this.initChildren();
        AbstractNode rootNode = new AbstractNode(this.children, this.lookup);
        this.manager.setRootContext((Node)rootNode);
    }

    protected DataTableMetadata getMetadata() {
        return this.getVisualizerConfiguration().getMetadata();
    }

    private void updateView() {
        String selectedNodeName;
        Node[] selectedNodes = this.getExplorerManager().getSelectedNodes();
        if (selectedNodes.length == 1) {
            Node selected = selectedNodes[0];
            selectedNodeName = selected.getDisplayName();
        } else {
            selectedNodeName = null;
        }
        List<Data> newData = this.dataRef.get();
        if (newData.isEmpty()) {
            ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "empty");
        } else {
            ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "data");
        }
        this.children.setData(newData);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (selectedNodeName != null) {
                    for (Node node : TableViewVisualizer.this.getExplorerManager().getRootContext().getChildren().getNodes(true)) {
                        if (!selectedNodeName.equals(node.getDisplayName())) continue;
                        try {
                            TableViewVisualizer.this.getExplorerManager().setSelectedNodes(new Node[]{node});
                        }
                        catch (PropertyVetoException ex) {}
                        break;
                    }
                }
            }
        });
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    public synchronized void refresh() {
        if (this.isVisible.get() && this.refreshBtn.isEnabled()) {
            this.refreshBtn.setEnabled(false);
            this.busyPanelDisplayTask.schedule(700);
            this.dataFetchTask.schedule(0);
        }
    }

    public final ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public List<VisualizerToolbarComponent> getToolbarComponents() {
        return Arrays.asList(new VisualizerToolbarComponent((Component)this.textFilterPanel));
    }

    @Override
    public void addNotify() {
        this.addComponentListener(this.componentListener);
        VisualizerContainer container = this.getDefaultContainer();
        if (container instanceof Component) {
            ((Component)container).addComponentListener(this.componentListener);
        }
        this.componentListener.componentShown(null);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.componentListener.componentHidden(null);
        this.removeComponentListener(this.componentListener);
        VisualizerContainer container = this.getDefaultContainer();
        if (container instanceof Component) {
            ((Component)container).removeComponentListener(this.componentListener);
        }
    }

    public Config getVisualizerConfiguration() {
        return this.configuration;
    }

    public void updateVisualizerConfiguration(Config configuration) {
    }

    protected String getEmptyRunningMessage() {
        return NbBundle.getMessage(TableViewVisualizer.class, (String)"TableViewVisualizer.defaultEmptyRunningMessage.text");
    }

    protected String getEmptyAnalyzeMessage() {
        return NbBundle.getMessage(TableViewVisualizer.class, (String)"TableViewVisualizer.defaultEmptyAnalyzeMessage.text");
    }

    protected abstract TableViewNodeChildren<Data> initChildren();

    protected abstract Component initTableView();

    protected abstract List<Data> getUpdatedData();

    protected abstract boolean matchesFilter(String var1, Data var2);
}

