/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.CancelAbort;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MissingPlatformError;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.DiagnosticListenerImpl;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.usages.ClassNamesForFileOraculumImpl;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class MultiPassCompileWorker
extends CompileWorker {
    private static final int MEMORY_LOW = 1;
    private static final int ERR = 2;

    MultiPassCompileWorker() {
    }

    @Override
    CompileWorker.ParsingOutput compile(final CompileWorker.ParsingOutput previous, final org.netbeans.modules.parsing.spi.indexing.Context context, JavaParsingContext javaContext, Iterable<? extends JavaCustomIndexer.CompileTuple> files) {
        LinkedList<JavaCustomIndexer.CompileTuple> toProcess = new LinkedList<JavaCustomIndexer.CompileTuple>();
        final HashMap<InferableJavaFileObject, JavaCustomIndexer.CompileTuple> jfo2tuples = new HashMap<InferableJavaFileObject, JavaCustomIndexer.CompileTuple>();
        for (JavaCustomIndexer.CompileTuple compileTuple : files) {
            if (previous.finishedFiles.contains(compileTuple.indexable)) continue;
            toProcess.add(compileTuple);
            jfo2tuples.put(compileTuple.jfo, compileTuple);
        }
        if (toProcess.isEmpty()) {
            return previous;
        }
        JavaFileManager fileManager = ClasspathInfoAccessor.getINSTANCE().getFileManager(javaContext.cpInfo);
        ClassNamesForFileOraculumImpl classNamesForFileOraculumImpl = new ClassNamesForFileOraculumImpl(previous.file2FQNs);
        LowMemoryWatcher mem = LowMemoryWatcher.getInstance();
        DiagnosticListenerImpl diagnosticListener = new DiagnosticListenerImpl();
        LinkedList<JavaCustomIndexer.CompileTuple> bigFiles = new LinkedList<JavaCustomIndexer.CompileTuple>();
        JavacTaskImpl jt = null;
        JavaCustomIndexer.CompileTuple active = null;
        boolean aptEnabled = false;
        int state = 0;
        boolean isBigFile = false;
        while (!toProcess.isEmpty() || !bigFiles.isEmpty() || active != null) {
            String message;
            ClassPath sourcePath;
            ClassPath classPath;
            ClassPath bootPath;
            if (context.isCancelled()) {
                return null;
            }
            try {
                boolean aptGenerated;
                if (mem.isLowMemory()) {
                    this.dumpSymFiles(fileManager, jt, previous.createdFiles);
                    mem.isLowMemory();
                    jt = null;
                    diagnosticListener.cleanDiagnostics();
                    if ((state & 1) != 0) break;
                    state |= 1;
                    System.gc();
                    continue;
                }
                if (active == null) {
                    if (!toProcess.isEmpty()) {
                        active = (JavaCustomIndexer.CompileTuple)toProcess.removeFirst();
                        if (active == null || previous.finishedFiles.contains(active.indexable)) continue;
                        isBigFile = false;
                    } else {
                        active = (JavaCustomIndexer.CompileTuple)bigFiles.removeFirst();
                        isBigFile = true;
                    }
                }
                if (jt == null) {
                    jt = JavacParser.createJavacTask(javaContext.cpInfo, diagnosticListener, javaContext.sourceLevel, classNamesForFileOraculumImpl, javaContext.fqn2Files, new CancelService(){

                        public boolean isCanceled() {
                            return context.isCancelled();
                        }
                    }, APTUtils.get(context.getRoot()));
                    Iterable processors = jt.getProcessors();
                    boolean bl = aptEnabled = processors != null && processors.iterator().hasNext();
                    if (JavaIndex.LOG.isLoggable(Level.FINER)) {
                        JavaIndex.LOG.finer("Created new JavacTask for: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()) + " " + javaContext.cpInfo.toString());
                    }
                }
                Iterable trees = jt.parse(new JavaFileObject[]{active.jfo});
                if (mem.isLowMemory()) {
                    this.dumpSymFiles(fileManager, jt, previous.createdFiles);
                    mem.isLowMemory();
                    jt = null;
                    diagnosticListener.cleanDiagnostics();
                    trees = null;
                    if ((state & 1) != 0) {
                        if (isBigFile) break;
                        bigFiles.add(active);
                        active = null;
                        state &= 0xFFFFFFFE;
                    } else {
                        state |= 1;
                    }
                    System.gc();
                    continue;
                }
                Iterable types = jt.enterTrees(trees);
                if (jfo2tuples.remove(active.jfo) != null) {
                    final Types ts = Types.instance(jt.getContext());
                    final Indexable activeIndexable = active.indexable;
                    class ScanNested
                    extends TreeScanner {
                        Set<JavaCustomIndexer.CompileTuple> dependencies = new LinkedHashSet<JavaCustomIndexer.CompileTuple>();

                        ScanNested() {
                        }

                        @Override
                        public void visitClassDef(JCTree.JCClassDecl node) {
                            if (node.sym != null) {
                                Type st = ts.supertype(node.sym.type);
                                if (st.tag == 10) {
                                    Symbol.ClassSymbol c = st.tsym.outermostClass();
                                    JavaCustomIndexer.CompileTuple u = (JavaCustomIndexer.CompileTuple)jfo2tuples.get(c.sourcefile);
                                    if (u != null && !previous.finishedFiles.contains(u.indexable) && !u.indexable.equals((Object)activeIndexable)) {
                                        this.dependencies.add(u);
                                    }
                                }
                            }
                            super.visitClassDef(node);
                        }
                    }
                    ScanNested scanner = new ScanNested();
                    for (CompilationUnitTree cut : trees) {
                        scanner.scan((JCTree.JCCompilationUnit)cut);
                    }
                    if (!scanner.dependencies.isEmpty()) {
                        toProcess.addFirst(active);
                        for (JavaCustomIndexer.CompileTuple tuple : scanner.dependencies) {
                            toProcess.addFirst(tuple);
                        }
                        active = null;
                        continue;
                    }
                }
                if (mem.isLowMemory()) {
                    this.dumpSymFiles(fileManager, jt, previous.createdFiles);
                    mem.isLowMemory();
                    jt = null;
                    diagnosticListener.cleanDiagnostics();
                    trees = null;
                    types = null;
                    if ((state & 1) != 0) {
                        if (isBigFile) break;
                        bigFiles.add(active);
                        active = null;
                        state &= 0xFFFFFFFE;
                    } else {
                        state |= 1;
                    }
                    System.gc();
                    continue;
                }
                jt.analyze(types);
                boolean bl = aptGenerated = aptEnabled ? JavaCustomIndexer.addAptGenerated(context, javaContext, active.indexable.getRelativePath(), previous.aptGenerated) : false;
                if (mem.isLowMemory()) {
                    this.dumpSymFiles(fileManager, jt, previous.createdFiles);
                    mem.isLowMemory();
                    jt = null;
                    diagnosticListener.cleanDiagnostics();
                    trees = null;
                    types = null;
                    if ((state & 1) != 0) {
                        if (isBigFile) break;
                        bigFiles.add(active);
                        active = null;
                        state &= 0xFFFFFFFE;
                    } else {
                        state |= 1;
                    }
                    System.gc();
                    continue;
                }
                javaContext.fqn2Files.set(types, active.indexable.getURL());
                boolean[] main = new boolean[1];
                if (javaContext.checkSums.checkAndSet(active.indexable.getURL(), types, jt.getElements()) || context.isSupplementaryFilesIndexing()) {
                    javaContext.sa.analyse(trees, jt, fileManager, active, previous.addedTypes, main);
                } else {
                    HashSet aTypes = new HashSet();
                    javaContext.sa.analyse(trees, jt, fileManager, active, aTypes, main);
                    previous.addedTypes.addAll(aTypes);
                    previous.modifiedTypes.addAll(aTypes);
                }
                ExecutableFilesIndex.DEFAULT.setMainClass(context.getRoot().getURL(), active.indexable.getURL(), main[0]);
                for (JavaFileObject javaFileObject : jt.generate(types)) {
                    if (!(javaFileObject instanceof FileObjects.FileBase)) continue;
                    previous.createdFiles.add(((FileObjects.FileBase)javaFileObject).getFile());
                }
                JavaCustomIndexer.setErrors(context, active, diagnosticListener);
                Log.instance((Context)jt.getContext()).nerrors = 0;
                previous.finishedFiles.add(active.indexable);
                active = null;
                state = 0;
                if (!aptGenerated) continue;
                this.dumpSymFiles(fileManager, jt, previous.createdFiles);
                jt = null;
            }
            catch (CouplingAbort ca) {
                TreeLoader.dumpCouplingAbort(ca, null);
                jt = null;
                diagnosticListener.cleanDiagnostics();
                if ((state & 2) != 0) {
                    if (active != null) {
                        previous.finishedFiles.add(active.indexable);
                    }
                    active = null;
                    state = 0;
                    continue;
                }
                state |= 2;
            }
            catch (OutputFileManager.InvalidSourcePath isp) {
                if (JavaIndex.LOG.isLoggable(Level.FINEST)) {
                    bootPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                    classPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                    sourcePath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                    message = String.format("MultiPassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
                    JavaIndex.LOG.log(Level.FINEST, message, isp);
                }
                return new CompileWorker.ParsingOutput(false, previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
            }
            catch (MissingPlatformError mpe) {
                if (JavaIndex.LOG.isLoggable(Level.FINEST)) {
                    bootPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                    classPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                    sourcePath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                    message = String.format("MultiPassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
                    JavaIndex.LOG.log(Level.FINEST, message, mpe);
                }
                return new CompileWorker.ParsingOutput(false, previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
            }
            catch (CancelAbort ca) {
                if (!JavaIndex.LOG.isLoggable(Level.FINEST)) continue;
                JavaIndex.LOG.log(Level.FINEST, "OnePassCompileWorker was canceled in root: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()), ca);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (JavaIndex.LOG.isLoggable(Level.WARNING)) {
                    bootPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                    classPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                    sourcePath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                    message = String.format("MultiPassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active == null ? null : active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
                    JavaIndex.LOG.log(Level.WARNING, message, t);
                }
                jt = null;
                diagnosticListener.cleanDiagnostics();
                if ((state & 2) != 0) {
                    if (active != null) {
                        previous.finishedFiles.add(active.indexable);
                    }
                    active = null;
                    state = 0;
                    continue;
                }
                state |= 2;
            }
        }
        if (state & true) {
            JavaIndex.LOG.warning("Not enough memory to compile folder: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()));
        }
        return new CompileWorker.ParsingOutput(true, previous.file2FQNs, previous.addedTypes, previous.createdFiles, previous.finishedFiles, previous.modifiedTypes, previous.aptGenerated);
    }

    private void dumpSymFiles(JavaFileManager jfm, JavacTaskImpl jti, Set<File> alreadyCreated) throws IOException {
        if (jti != null) {
            final Types types = Types.instance(jti.getContext());
            final Enter enter = Enter.instance(jti.getContext());
            HashSet<Env> processedEnvs = new HashSet<Env>();
            for (Env env : jti.getTodo()) {
                if (!processedEnvs.add(env)) continue;
                class ScanNested
                extends TreeScanner {
                    private Env<AttrContext> env;
                    private Set<Env<AttrContext>> dependencies = new LinkedHashSet<Env<AttrContext>>();

                    public ScanNested(Env<AttrContext> env) {
                        this.env = env;
                    }

                    @Override
                    public void visitClassDef(JCTree.JCClassDecl node) {
                        if (node.sym != null) {
                            Symbol.ClassSymbol c;
                            Env<AttrContext> stEnv;
                            Type st = types.supertype(node.sym.type);
                            if (st.tag == 10 && (stEnv = enter.getEnv(c = st.tsym.outermostClass())) != null && this.env != stEnv && this.dependencies.add(stEnv)) {
                                this.scan(stEnv.tree);
                            }
                        }
                        super.visitClassDef(node);
                    }
                }
                ScanNested scanner = new ScanNested(env);
                scanner.scan(env.tree);
                for (Env dep : scanner.dependencies) {
                    if (!processedEnvs.add(dep)) continue;
                    this.dumpSymFile(jfm, jti, dep.enclClass.sym, alreadyCreated);
                }
                this.dumpSymFile(jfm, jti, env.enclClass.sym, alreadyCreated);
            }
        }
    }

    private void dumpSymFile(JavaFileManager jfm, JavacTaskImpl jti, Symbol.ClassSymbol cs, Set<File> alreadyCreated) throws IOException {
        JavaFileObject file = jfm.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, cs.flatname.toString(), JavaFileObject.Kind.CLASS, cs.sourcefile);
        if (file instanceof FileObjects.FileBase && !alreadyCreated.contains(((FileObjects.FileBase)file).getFile())) {
            TreeLoader.dumpSymFile(jfm, jti, cs);
        }
    }
}

