/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.CloseProject;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectNodeAction
extends LookupSensitiveAction {
    private static final Icon SELECT_IN_PROJECTS_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/project/ui/resources/projectTab.png", (boolean)false);
    private static final Icon SELECT_IN_FILES_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/project/ui/resources/filesTab.png", (boolean)false);
    private static final String SELECT_IN_PROJECTS_NAME = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_MainMenuName");
    private static final String SELECT_IN_FILES_NAME = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_MainMenuName");
    private String findIn;

    public static SelectNodeAction inProjects() {
        SelectNodeAction a = new SelectNodeAction(SELECT_IN_PROJECTS_ICON, SELECT_IN_PROJECTS_NAME);
        a.findIn = "projectTabLogical_tc";
        return a;
    }

    static Action inProjects(Lookup lookup) {
        SelectNodeAction a = new SelectNodeAction(SELECT_IN_PROJECTS_ICON, SELECT_IN_PROJECTS_NAME, lookup);
        a.findIn = "projectTabLogical_tc";
        return a;
    }

    public static SelectNodeAction inFiles() {
        SelectNodeAction a = new SelectNodeAction(SELECT_IN_FILES_ICON, SELECT_IN_FILES_NAME);
        a.findIn = "projectTab_tc";
        return a;
    }

    public SelectNodeAction(Icon icon, String name) {
        this(icon, name, null);
    }

    private SelectNodeAction(Icon icon, String name, Lookup lookup) {
        super(icon, lookup, new Class[]{DataObject.class, FileObject.class});
        this.setDisplayName(name);
    }

    @Override
    protected void actionPerformed(Lookup context) {
        FileObject fo = this.getFileFromLookup(context);
        if (fo != null) {
            ProjectTab pt = ProjectTab.findDefault(this.findIn);
            pt.selectNodeAsync(fo);
        }
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        FileObject fo = this.getFileFromLookup(context);
        this.setEnabled(fo != null);
    }

    private FileObject getFileFromLookup(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return fo;
        }
        DataObject dobj = (DataObject)context.lookup(DataObject.class);
        return dobj == null ? null : dobj.getPrimaryFile();
    }
}

