/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import com.sun.el.parser.AstDeferredExpression;
import com.sun.el.parser.AstDynamicExpression;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstMethodSuffix;
import com.sun.el.parser.AstPropertySuffix;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.completion.ELElementHandle;
import org.netbeans.modules.web.el.completion.ELImplictObjectCompletionItem;
import org.netbeans.modules.web.el.completion.ELJavaCompletionItem;
import org.netbeans.modules.web.el.completion.ELKeywordCompletionItem;
import org.netbeans.modules.web.el.completion.ELRawObjectPropertyCompletionItem;
import org.netbeans.modules.web.el.completion.ELResourceBundleCompletionItem;
import org.netbeans.modules.web.el.completion.ELResourceBundleKeyCompletionItem;
import org.netbeans.modules.web.el.completion.ELSanitizer;
import org.netbeans.modules.web.el.completion.ELVariableCompletionItem;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class ELCodeCompletionHandler
implements CodeCompletionHandler {
    public CodeCompletionResult complete(final CodeCompletionContext context) {
        ResourceBundles bundle;
        String bundleIdentifier;
        final ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(50);
        DefaultCompletionResult result = new DefaultCompletionResult(proposals, false);
        final ELElement element = this.getElementAt(context.getParserResult(), context.getCaretOffset());
        if (element == null || !element.isValid()) {
            return CodeCompletionResult.NONE;
        }
        Node target = this.getTargetNode(element, context.getCaretOffset());
        if (target == null) {
            return CodeCompletionResult.NONE;
        }
        AstPath path = new AstPath(element.getNode());
        final List<Node> rootToNode = path.rootToNode(target);
        if (rootToNode.isEmpty()) {
            return result;
        }
        final PrefixMatcher prefixMatcher = PrefixMatcher.create(target, context);
        if (prefixMatcher == null) {
            return CodeCompletionResult.NONE;
        }
        if (target instanceof AstString && (bundleIdentifier = (bundle = ResourceBundles.get(this.getFileObject(context))).findResourceBundleIdentifier(path)) != null) {
            this.proposeBundleKeysInArrayNotation(context, prefixMatcher, element, bundleIdentifier, (AstString)target, proposals);
            return proposals.isEmpty() ? CodeCompletionResult.NONE : result;
        }
        Node previous = rootToNode.get(rootToNode.size() - 1);
        final Node nodeToResolve = this.getNodeToResolve(target, previous);
        final FileObject file = context.getParserResult().getSnapshot().getSource().getFileObject();
        JavaSource jsource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)file), (FileObject[])new FileObject[0]);
        try {
            jsource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationContext ccontext = CompilationContext.create(file, (CompilationInfo)info);
                    Element resolved = ELTypeUtilities.resolveElement(ccontext, element, nodeToResolve);
                    if (ELTypeUtilities.isRawObject(ccontext, nodeToResolve)) {
                        ELCodeCompletionHandler.this.proposeRawObjectProperties(ccontext, context, prefixMatcher, nodeToResolve, proposals);
                    } else if (ELTypeUtilities.isScopeObject(ccontext, nodeToResolve)) {
                        ELCodeCompletionHandler.this.proposeBeansFromScope(ccontext, context, prefixMatcher, element, nodeToResolve, proposals);
                    } else if (ELTypeUtilities.isResourceBundleVar(ccontext, nodeToResolve)) {
                        ELCodeCompletionHandler.this.proposeBundleKeysInDotNotation(context, prefixMatcher, element, nodeToResolve, proposals);
                    } else if (resolved == null) {
                        ELCodeCompletionHandler.this.proposeManagedBeans(ccontext, context, prefixMatcher, element, proposals);
                        ELCodeCompletionHandler.this.proposeBundles(ccontext, context, prefixMatcher, element, proposals);
                        ELCodeCompletionHandler.this.proposeVariables(ccontext, context, prefixMatcher, element, proposals);
                        ELCodeCompletionHandler.this.proposeImpicitObjects(ccontext, context, prefixMatcher, proposals);
                        ELCodeCompletionHandler.this.proposeKeywords(context, prefixMatcher, proposals);
                    } else {
                        ELCodeCompletionHandler.this.proposeMethods(ccontext, context, resolved, prefixMatcher, element, proposals, rootToNode);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return proposals.isEmpty() ? CodeCompletionResult.NONE : result;
    }

    private Node getNodeToResolve(Node target, Node previous) {
        if (target instanceof AstIdentifier && (previous instanceof AstIdentifier || previous instanceof AstPropertySuffix || previous instanceof AstMethodSuffix)) {
            return target;
        }
        return previous;
    }

    private ELElement getElementAt(ParserResult parserResult, int offset) {
        ELParserResult elParserResult = (ELParserResult)parserResult;
        ELElement result = elParserResult.getElementAt(offset);
        if (result == null || result.isValid()) {
            return result;
        }
        ELSanitizer sanitizer = new ELSanitizer(result);
        return sanitizer.sanitized();
    }

    private Node getTargetNode(ELElement element, int offset) {
        Node result = element.findNodeAt(offset);
        if (result instanceof AstDeferredExpression || result instanceof AstDynamicExpression) {
            int relativeOffset = offset - element.getOriginalOffset().getStart();
            assert (relativeOffset >= 0);
            if (relativeOffset >= 2) {
                Node realTarget = element.findNodeAt(offset - 1);
                if (realTarget != null) {
                    result = realTarget;
                }
            } else {
                return null;
            }
        }
        return result;
    }

    private FileObject getFileObject(CodeCompletionContext context) {
        return context.getParserResult().getSnapshot().getSource().getFileObject();
    }

    private void proposeMethods(CompilationContext info, CodeCompletionContext context, Element resolved, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals, List<Node> rootToNode) {
        List<Element> allTypes = ELTypeUtilities.getSuperTypesFor(info, resolved, elElement, rootToNode);
        for (Element element : allTypes) {
            for (ExecutableElement enclosed : ElementFilter.methodsIn(element.getEnclosedElements())) {
                String methodName;
                String propertyName;
                if (element.getSimpleName().contentEquals("Object") || !enclosed.getModifiers().contains((Object)Modifier.PUBLIC) || !prefix.matches(propertyName = RefactoringUtil.getPropertyName(methodName = enclosed.getSimpleName().toString(), true))) continue;
                ELJavaCompletionItem item = new ELJavaCompletionItem(info, enclosed, elElement);
                item.setSmart(true);
                item.setAnchorOffset(context.getCaretOffset() - prefix.length());
                proposals.add((CompletionProposal)item);
            }
        }
    }

    private void proposeImpicitObjects(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, List<CompletionProposal> proposals) {
        for (ImplicitObject implicitObject : ELTypeUtilities.getImplicitObjects(info)) {
            if (!prefix.matches(implicitObject.getName())) continue;
            ELImplictObjectCompletionItem item = new ELImplictObjectCompletionItem(implicitObject.getName(), implicitObject.getClazz());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeKeywords(CodeCompletionContext context, PrefixMatcher prefix, List<CompletionProposal> proposals) {
        for (ELTokenId elToken : ELTokenId.values()) {
            if (!ELTokenId.ELTokenCategories.KEYWORDS.hasCategory((TokenId)elToken) || elToken.fixedText() == null || !prefix.matches(elToken.fixedText())) continue;
            ELKeywordCompletionItem item = new ELKeywordCompletionItem(elToken.fixedText());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeManagedBeans(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getManagedBeans(info, this.getFileObject(context))) {
            TypeElement element;
            if (!prefix.matches(bean.name) || (element = ELTypeUtilities.getElementForType(info, bean.clazz)) == null) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(info, element, bean.name, elElement);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBeansFromScope(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, Node scopeNode, List<CompletionProposal> proposals) {
        String scope = scopeNode.getImage();
        String scopeString = "Scope";
        if (scope.endsWith("Scope")) {
            scope = scope.substring(0, scope.length() - "Scope".length());
        }
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getBeansInScope(info, scope, context.getParserResult().getSnapshot())) {
            if (!prefix.matches(bean.name)) continue;
            TypeElement element = ELTypeUtilities.getElementForType(info, bean.clazz);
            ELJavaCompletionItem item = new ELJavaCompletionItem(info, element, elElement);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeRawObjectProperties(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, Node scopeNode, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo property : ELVariableResolvers.getRawObjectProperties(info, scopeNode.getImage(), context.getParserResult().getSnapshot())) {
            if (!prefix.matches(property.name)) continue;
            ELRawObjectPropertyCompletionItem item = new ELRawObjectPropertyCompletionItem(property.name);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeVariables(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getVariables(info, context.getParserResult().getSnapshot(), context.getCaretOffset())) {
            if (!prefix.matches(bean.name)) continue;
            if (bean.clazz == null) {
                ELVariableCompletionItem item = new ELVariableCompletionItem(bean.name, bean.expression);
                item.setAnchorOffset(context.getCaretOffset() - prefix.length());
                item.setSmart(true);
                proposals.add((CompletionProposal)item);
                continue;
            }
            TypeElement element = ELTypeUtilities.getElementForType(info, bean.clazz);
            if (element == null) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(info, element, elElement);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundles(CompilationContext ccontext, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        for (ResourceBundle bundle : resourceBundles.getBundles()) {
            if (!prefix.matches(bundle.getVar())) continue;
            ELResourceBundleCompletionItem item = new ELResourceBundleCompletionItem(ccontext.file(), bundle, resourceBundles);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundleKeysInArrayNotation(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, String bundleKey, AstString target, List<CompletionProposal> proposals) {
        if (target.getImage().isEmpty() || elElement.getOriginalOffset((Node)target).getStart() >= context.getCaretOffset()) {
            return;
        }
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        for (Map.Entry<String, String> entry : resourceBundles.getEntries(bundleKey).entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            ELResourceBundleKeyCompletionItem item = new ELResourceBundleKeyCompletionItem(entry.getKey(), entry.getValue(), elElement);
            item.setSmart(true);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundleKeysInDotNotation(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, Node baseObjectNode, List<CompletionProposal> proposals) {
        String bundleKey = baseObjectNode.getImage();
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        for (Map.Entry<String, String> entry : resourceBundles.getEntries(bundleKey).entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            ELResourceBundleKeyCompletionItem item = new ELResourceBundleKeyCompletionItem(entry.getKey(), entry.getValue(), elElement);
            item.setSmart(true);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    public String document(ParserResult info, ElementHandle element) {
        if (!(element instanceof ELElementHandle)) {
            return null;
        }
        return ((ELElementHandle)element).document(info);
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        ELElement element = this.getElementAt(info, caretOffset);
        if (element == null) {
            return null;
        }
        Node node = element.findNodeAt(caretOffset);
        if (node instanceof AstString) {
            int startOffset = element.getOriginalOffset(node).getStart();
            int end = caretOffset - startOffset;
            String image = node.getImage();
            if (end > 0 && !image.isEmpty()) {
                return image.substring(1, end);
            }
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private static class PrefixMatcher {
        private final String prefix;
        private final boolean exact;

        private PrefixMatcher(String value, boolean exact) {
            this.prefix = value;
            this.exact = exact;
        }

        static PrefixMatcher create(Node target, CodeCompletionContext context) {
            boolean isDoc;
            String prefix = context.getPrefix() != null ? context.getPrefix() : "";
            boolean bl = isDoc = context.getQueryType() == CodeCompletionHandler.QueryType.DOCUMENTATION;
            if (isDoc) {
                prefix = PrefixMatcher.getPrefixForDocumentation(target);
            }
            if (isDoc && prefix.isEmpty()) {
                return null;
            }
            return new PrefixMatcher(prefix, isDoc);
        }

        private static String getPrefixForDocumentation(Node target) {
            if (target instanceof AstString) {
                return ((AstString)target).getString();
            }
            return target.getImage() == null ? "" : target.getImage();
        }

        boolean matches(String str) {
            if (this.exact) {
                return this.prefix.equals(str);
            }
            return str.startsWith(this.prefix);
        }

        int length() {
            return this.prefix.length();
        }
    }
}

