/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptionsListener;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.ToolsConfiguration;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationAccessor;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class DLightConfiguration {
    static final String CONFIGURATION_OPTIONS = "ConfigurationOptions";
    private final FileObject rootFolder;
    private final ToolsConfiguration toolsConfiguration;
    private final DLightConfigurationOptions configurationOptions;
    private final String displayedName;
    private final String category;
    private final String[] platforms;
    private final String collectorProviders;
    private final String[] indicatorProviders;
    private final boolean isHidden;
    private final boolean isSystem;
    private final boolean isDefault;
    private final DLightConfigurationOptionsListener listener = new DLightConfigurationOptionsListenerImpl();

    static DLightConfiguration create(FileObject configurationRoot) {
        return new DLightConfiguration(configurationRoot);
    }

    static DLightConfiguration createDefault() {
        FileObject fsRoot = FileUtil.getConfigRoot();
        FileObject toolConfigurations = fsRoot.getFileObject("DLight/ToolConfigurationProviders");
        return new DLightConfiguration(fsRoot.getFileObject("DLight"), ToolsConfiguration.createDefault(toolConfigurations));
    }

    private DLightConfiguration(FileObject configurationRoot) {
        this(configurationRoot, ToolsConfiguration.create(configurationRoot));
    }

    private DLightConfiguration(FileObject configurationRoot, ToolsConfiguration toolsConfiguration) {
        this.toolsConfiguration = toolsConfiguration;
        this.rootFolder = configurationRoot;
        this.configurationOptions = this.getConfigurationOptions();
        this.displayedName = configurationRoot.getAttribute("displayedName") == null ? configurationRoot.getName() : (String)configurationRoot.getAttribute("displayedName");
        this.isHidden = configurationRoot.getAttribute("hidden") != null && (Boolean)configurationRoot.getAttribute("hidden") != false;
        this.isSystem = configurationRoot.getAttribute("system") != null && (Boolean)configurationRoot.getAttribute("system") != false;
        this.isDefault = configurationRoot.getAttribute("default") != null && (Boolean)configurationRoot.getAttribute("default") != false;
        this.category = configurationRoot.getAttribute("category") == null ? configurationRoot.getName() : (String)configurationRoot.getAttribute("category");
        this.platforms = configurationRoot.getAttribute("platforms") == null ? null : ((String)configurationRoot.getAttribute("platforms")).split(",");
        this.collectorProviders = configurationRoot.getAttribute("collector.providers") == null ? null : (String)configurationRoot.getAttribute("collector.providers");
        this.indicatorProviders = configurationRoot.getAttribute("indicator.providers") == null ? null : ((String)configurationRoot.getAttribute("indicator.providers")).split(",");
    }

    public final String getDisplayedName() {
        return this.displayedName;
    }

    public final String getCategoryName() {
        return this.category;
    }

    public final List<String> getPlatforms() {
        return Arrays.asList(this.platforms);
    }

    public final String getCollectorProviders() {
        return this.collectorProviders;
    }

    public final List<String> getIndicatorProviders() {
        return Arrays.asList(this.indicatorProviders);
    }

    boolean isSystem() {
        return this.isSystem;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    final ToolsConfiguration getToolsConfiguration() {
        return this.toolsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DLightTool> getToolsSet() {
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            return this.toolsConfiguration.getToolsSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DLightTool> getToolsSet(ExecutionEnvironment env) {
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            return this.toolsConfiguration.getToolsSet(env);
        }
    }

    public List<Indicator<?>> getIndicators() {
        ArrayList result = new ArrayList();
        List<DLightTool> tools = this.getToolsSet();
        for (DLightTool tool : tools) {
            result.addAll(tool.getIndicators());
        }
        return result;
    }

    private final List<Indicator<?>> getEnabledIndicators() {
        ArrayList result = new ArrayList();
        List<DLightTool> tools = this.getToolsSet();
        for (DLightTool tool : tools) {
            if (!tool.isEnabled()) continue;
            result.addAll(tool.getIndicators());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLightTool getToolByID(String id) {
        ArrayList<DLightTool> list;
        if (id == null) {
            return null;
        }
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            list = new ArrayList<DLightTool>(this.toolsConfiguration.getToolsSet());
        }
        for (DLightTool tool : list) {
            if (!id.equals(tool.getID())) continue;
            return tool;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLightTool getToolByName(String name) {
        ArrayList<DLightTool> list;
        if (name == null) {
            return null;
        }
        ToolsConfiguration toolsConfiguration = this.toolsConfiguration;
        synchronized (toolsConfiguration) {
            list = new ArrayList<DLightTool>(this.toolsConfiguration.getToolsSet());
        }
        for (DLightTool tool : list) {
            if (!name.equals(tool.getName())) continue;
            return tool;
        }
        return null;
    }

    public DLightConfigurationOptions getConfigurationOptions(boolean template) {
        if (template) {
            this.getConfigurationOptions();
        }
        return this.configurationOptions;
    }

    FileObject getRootFolder() {
        return this.rootFolder;
    }

    private DLightConfigurationOptions getConfigurationOptions() {
        FileObject configurationsFolder = this.rootFolder.getFileObject(CONFIGURATION_OPTIONS);
        if (configurationsFolder == null) {
            return new DefaultConfigurationOption();
        }
        FileObject[] children = configurationsFolder.getChildren();
        if (children == null || children.length == 0) {
            return new DefaultConfigurationOption();
        }
        for (FileObject child : children) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)child);
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, null, ex);
            }
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            if (ic == null) {
                String message = "D-Light options configuration " + child.getName() + " not found";
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, message, new Exception(message));
                continue;
            }
            try {
                Class clazz = ic.instanceClass();
                DLightConfigurationOptions configurationProvider = (DLightConfigurationOptions)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                configurationProvider.addListener(this.listener);
                return configurationProvider;
            }
            catch (InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public String getConfigurationName() {
        return this.rootFolder.getName();
    }

    static {
        DLightConfigurationAccessor.setDefault(new DLightConfigurationAccessorImpl());
    }

    private static final class DLightConfigurationAccessorImpl
    extends DLightConfigurationAccessor {
        private DLightConfigurationAccessorImpl() {
        }

        @Override
        public List<Indicator<?>> getEnabledIndicators(DLightConfiguration configuration) {
            return configuration.getEnabledIndicators();
        }

        @Override
        public boolean isHidden(DLightConfiguration configuration) {
            return configuration.isHidden;
        }
    }

    private final class DLightConfigurationOptionsListenerImpl
    implements DLightConfigurationOptionsListener {
        private DLightConfigurationOptionsListenerImpl() {
        }

        @Override
        public boolean dlightToolEnabling(String toolName, boolean isEnabled) {
            if (DLightConfiguration.this.getToolByName(toolName) == null) {
                return false;
            }
            if (isEnabled) {
                DLightConfiguration.this.getToolByName(toolName).enable();
            } else {
                DLightConfiguration.this.getToolByName(toolName).disable();
            }
            return true;
        }
    }

    private class DefaultConfigurationOption
    implements DLightConfigurationOptions {
        private boolean turnState = true;

        private DefaultConfigurationOption() {
        }

        @Override
        public void turnCollectorsState(boolean turnState) {
            this.turnState = turnState;
        }

        @Override
        public boolean areCollectorsTurnedOn() {
            return this.turnState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<DLightTool> getToolsSet() {
            ToolsConfiguration toolsConfiguration = DLightConfiguration.this.toolsConfiguration;
            synchronized (toolsConfiguration) {
                return DLightConfiguration.this.toolsConfiguration.getToolsSet();
            }
        }

        @Override
        public List<DataCollector<?>> getCollectors(DLightTool tool) {
            List<DataCollector<?>> collectors = tool.getCollectors();
            ArrayList result = new ArrayList();
            for (DataCollector<?> collector : collectors) {
                if (!collector.getName().equals(DLightConfiguration.this.collectorProviders)) continue;
                result.add(collector);
            }
            return result;
        }

        @Override
        public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool tool) {
            String[] DLightIndicatorDPStrings = DLightConfiguration.this.indicatorProviders;
            List<IndicatorDataProvider<?>> idps = tool.getIndicatorDataProviders();
            ArrayList result = new ArrayList();
            block0: for (IndicatorDataProvider<?> idp : idps) {
                for (String idpStringName : DLightIndicatorDPStrings) {
                    if (!idp.getName().equals(idpStringName)) continue;
                    result.add(idp);
                    continue block0;
                }
            }
            return result;
        }

        @Override
        public boolean validateToolsRequiredUserInteraction() {
            return true;
        }

        @Override
        public boolean profileOnRun() {
            return false;
        }

        @Override
        public Collection<String> getActiveToolNames() {
            ArrayList<String> toolIDs = new ArrayList<String>();
            for (DLightTool tool : this.getToolsSet()) {
                if (!tool.isEnabled()) continue;
                toolIDs.add(tool.getID());
            }
            return toolIDs;
        }

        @Override
        public void addListener(DLightConfigurationOptionsListener listener) {
        }

        @Override
        public void removeListener(DLightConfigurationOptionsListener listener) {
        }
    }
}

