/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.common.JavaMethod;
import org.netbeans.modules.j2ee.sun.dd.api.common.Message;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurity;
import org.netbeans.modules.j2ee.sun.dd.api.common.MethodParams;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.openide.util.NbBundle;

public class MessageEntry
extends GenericTableModel.TableEntry {
    public static final String OPERATION_ENTRY = "OperationName";
    public static final String METHOD_ENTRY = "MethodName";
    public static final Pattern methodSplitter = Pattern.compile("[\\s,\\(\\)\\[\\]]+");
    private boolean saveAsOperation;

    public MessageEntry(boolean useOperations) {
        super(null, "Message", NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle"), useOperations ? OPERATION_ENTRY : METHOD_ENTRY, true, true);
        this.saveAsOperation = useOperations;
    }

    @Override
    public Object getEntry(CommonDDBean parent) {
        Object result = null;
        CommonDDBean[] message = (CommonDDBean[])parent.getValues(this.propertyName);
        if (message != null && message.length > 0 && message[0] != null) {
            if (this.saveAsOperation) {
                result = message[0].getValue(OPERATION_ENTRY);
            } else {
                result = this.methodToString((JavaMethod)message[0].getValue("JavaMethod"));
                if (!Utils.notEmpty((String)result)) {
                    result = message[0].getValue(OPERATION_ENTRY);
                }
            }
        }
        return result;
    }

    @Override
    public void setEntry(CommonDDBean parent, Object value) {
        if (value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        Object[] m = (CommonDDBean[])parent.getValues(this.propertyName);
        if (value != null) {
            if (m == null || m.length == 0 || m[0] == null) {
                MessageSecurity ms = (MessageSecurity)parent;
                m = new Message[]{ms.newMessage()};
                parent.setValue(this.propertyName, m);
            }
            if (this.saveAsOperation) {
                m[0].setValue(OPERATION_ENTRY, value);
            } else {
                m[0].setValue("JavaMethod", (Object)this.stringToMethod((Message)m[0], value.toString()));
            }
        } else if (m != null) {
            parent.setValue(this.propertyName, null);
        }
    }

    @Override
    public Object getEntry(CommonDDBean parent, int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntry(CommonDDBean parent, int row, Object value) {
        throw new UnsupportedOperationException();
    }

    private String methodToString(JavaMethod jm) {
        StringBuffer buf = new StringBuffer(128);
        if (jm != null) {
            buf.append(jm.getMethodName());
            MethodParams mps = jm.getMethodParams();
            if (mps != null && mps.sizeMethodParam() > 0) {
                buf.append("(");
                String[] params = mps.getMethodParam();
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (Utils.notEmpty(params[i])) {
                        buf.append(params[i]);
                        continue;
                    }
                    buf.append(" ");
                }
                buf.append(")");
            }
        }
        return buf.toString();
    }

    private JavaMethod stringToMethod(Message m, String methodDesc) {
        String[] parts;
        JavaMethod method = null;
        if (Utils.notEmpty(methodDesc) && (parts = methodSplitter.split(methodDesc)).length > 0) {
            method = m.newJavaMethod();
            method.setMethodName(parts[0]);
            if (parts.length > 1) {
                MethodParams mps = method.newMethodParams();
                for (int i = 1; i < parts.length; ++i) {
                    mps.addMethodParam(parts[i]);
                }
                method.setMethodParams(mps);
            }
        }
        return method;
    }
}

