/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.utils.AppletSupport;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class J2SEProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2se");
    private String mainClassSetManually = null;

    public boolean isFileObjectSupported(Project project, FileObject fo) {
        if (!"java".equals(fo.getExt()) && !"class".equals(fo.getExt())) {
            return false;
        }
        return SourceUtils.isRunnable((FileObject)fo);
    }

    public String getProfilerTargetName(Project project, FileObject buildScript, int type, FileObject profiledClassFile) {
        switch (type) {
            case 1: {
                return "profile";
            }
            case 2: {
                if (SourceUtils.isApplet((FileObject)profiledClassFile)) {
                    return "profile-applet";
                }
                return "profile-single";
            }
            case 3: {
                return null;
            }
            case 4: {
                return "profile-test-single";
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        return true;
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        PropertyEvaluator props = this.getProjectProperties(project);
        String platformName = props.getProperty("platform.active");
        if (platformName == null) {
            return null;
        }
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        if (platformName.equals("default_platform")) {
            return jpm.getDefaultPlatform();
        }
        JavaPlatform[] platforms = jpm.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < platforms.length; ++i) {
            JavaPlatform platform = platforms[i];
            String antName = (String)platform.getProperties().get("platform.ant.name");
            if (!antName.equals(platformName)) continue;
            return platform;
        }
        return null;
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject profiledClassFile) {
        if (profiledClassFile == null) {
            PropertyEvaluator pp = this.getProjectProperties(project);
            String profiledClass = pp.getProperty("main.class");
            if (profiledClass == null || "".equals(profiledClass) || SourceUtils.resolveClassByName((String)profiledClass, (Project)project) == null) {
                this.mainClassSetManually = ProjectUtilities.selectMainClass((Project)project, null, (String)ProjectUtilities.getProjectName((Project)project), (int)-1);
                if (this.mainClassSetManually == null) {
                    return false;
                }
            }
            return true;
        }
        return this.isFileObjectSupported(project, profiledClassFile);
    }

    public void configurePropertiesForProfiling(Properties props, Project project, FileObject profiledClassFile) {
        if (profiledClassFile == null) {
            if (this.mainClassSetManually != null) {
                props.put("main.class", this.mainClassSetManually);
                this.mainClassSetManually = null;
            }
        } else {
            if (SourceUtils.isApplet((FileObject)profiledClassFile)) {
                String jvmargs = props.getProperty("run.jvmargs");
                URL url = null;
                if (jvmargs == null || jvmargs.indexOf("java.security.policy") <= 0) {
                    PropertyEvaluator projectProps = this.getProjectProperties(project);
                    String buildDirProp = projectProps.getProperty("build.dir");
                    FileObject buildFolder = ProjectUtilities.getOrCreateBuildFolder((Project)project, (String)buildDirProp);
                    AppletSupport.generateSecurityPolicy((FileObject)project.getProjectDirectory(), (FileObject)buildFolder);
                    if (jvmargs == null || jvmargs.length() == 0) {
                        props.setProperty("run.jvmargs", "-Djava.security.policy=" + FileUtil.toFile((FileObject)buildFolder).getPath() + File.separator + "applet.policy");
                    } else {
                        props.setProperty("run.jvmargs", jvmargs + " -Djava.security.policy=" + FileUtil.toFile((FileObject)buildFolder).getPath() + File.separator + "applet.policy");
                    }
                }
                if ((url = profiledClassFile.existsExt("html") || profiledClassFile.existsExt("HTML") ? ProjectUtilities.copyAppletHTML((Project)project, (PropertyEvaluator)this.getProjectProperties(project), (FileObject)profiledClassFile, (String)"html") : ProjectUtilities.generateAppletHTML((Project)project, (PropertyEvaluator)this.getProjectProperties(project), (FileObject)profiledClassFile)) == null) {
                    return;
                }
                props.setProperty("applet.url", url.toString());
            } else {
                String profiledClass = SourceUtils.getToplevelClassName((FileObject)profiledClassFile);
                props.setProperty("profile.class", profiledClass);
            }
            String clazz = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)profiledClassFile), (FileObject)profiledClassFile);
            props.setProperty("javac.includes", clazz);
        }
    }

    public void setupProjectSessionSettings(Project project, SessionSettings ss) {
        PropertyEvaluator pp = this.getProjectProperties(project);
        if (this.mainClassSetManually == null) {
            String mainClass = pp.getProperty("main.class");
            ss.setMainClass(mainClass != null ? mainClass : "");
        } else {
            ss.setMainClass(this.mainClassSetManually);
        }
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("run.classpath");
        ss.setMainClassPath(runCP != null ? runCP : "");
        String jvmArgs = pp.getProperty("run.jvmargs");
        ss.setJVMArgs(jvmArgs != null ? jvmArgs : "");
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate(Project project) {
        return true;
    }

    public void unintegrateProfiler(Project project) {
        ProjectUtilities.unintegrateProfiler((Project)project);
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final Properties configProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        final FileObject configPropsFile = project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
        final FileObject configPropsDir = project.getProjectDirectory().getFileObject("nbproject/configs");
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block30: {
                    InputStream is;
                    if (privatePropsFile != null) {
                        try {
                            is = privatePropsFile.getInputStream();
                            try {
                                privateProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                    if (projectPropsFile != null) {
                        try {
                            is = projectPropsFile.getInputStream();
                            try {
                                projectProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                    if (userPropsFile != null) {
                        try {
                            is = new BufferedInputStream(new FileInputStream(userPropsFile));
                            try {
                                userPropsProps.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                    if (configPropsDir != null && configPropsFile != null) {
                        try {
                            is = configPropsFile.getInputStream();
                            Properties activeConfigProps = new Properties();
                            try {
                                FileObject configSpecPropFile;
                                activeConfigProps.load(is);
                                String activeConfig = activeConfigProps.getProperty("config");
                                if (activeConfig == null || activeConfig.length() <= 0 || (configSpecPropFile = configPropsDir.getFileObject(activeConfig + ".properties")) == null) break block30;
                                InputStream configSpecIn = configSpecPropFile.getInputStream();
                                try {
                                    configProps.load(configSpecIn);
                                }
                                finally {
                                    configSpecIn.close();
                                }
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            err.notify(1, (Throwable)e);
                        }
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(configProps), new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

