/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class VcsVisibilityQueryImplementation
implements VisibilityQueryImplementation2 {
    private final InvisibleFiles cache = new InvisibleFiles(25);
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static VcsVisibilityQueryImplementation instance;
    private static RequestProcessor rp;
    private RequestProcessor.Task refreshTask = rp.create((Runnable)new RefreshTask());
    private RequestProcessor.Task vsChangedTask = rp.create((Runnable)new VisibilityChangedTask());
    private final HashMap<File, Boolean> refreshedFiles = new HashMap(20);
    private static final int MAX_CACHE_SIZE = 500;
    private Map<File, FileObject> fileObjects = Collections.synchronizedMap(new HashMap(8));
    private static final String SVN_ADMIN_DIR;
    private static final Pattern svnmetadataPattern;
    private static final Pattern hgmetadataPattern;
    private static final Pattern cvsmetadataPattern;
    private static final Pattern gitmetadatapattern;

    public VcsVisibilityQueryImplementation() {
        instance = this;
    }

    public static VcsVisibilityQueryImplementation getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(File file) {
        boolean refresh;
        boolean visible;
        if (this.isHiddenMetadata(file)) {
            return false;
        }
        InvisibleFiles invisibleFiles = this.cache;
        synchronized (invisibleFiles) {
            this.cache.clearOldValues();
            visible = !this.cache.keySet().contains(file);
        }
        HashMap<File, Boolean> hashMap = this.refreshedFiles;
        synchronized (hashMap) {
            refresh = this.refreshedFiles.isEmpty();
            this.refreshedFiles.put(file, visible);
        }
        if (refresh) {
            this.refreshTask.schedule(100);
        }
        return visible;
    }

    public boolean isVisible(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return true;
        }
        this.fileObjects.put(file, fileObject);
        return this.isVisible(file);
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.add(l);
        this.listeners = newList;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.remove(l);
        this.listeners = newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVisibilityChanged() {
        ChangeListener[] ls;
        VcsVisibilityQueryImplementation vcsVisibilityQueryImplementation = this;
        synchronized (vcsVisibilityQueryImplementation) {
            ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(event);
        }
    }

    private boolean isHiddenMetadata(File file) {
        return svnmetadataPattern.matcher(file.getAbsolutePath()).matches() || hgmetadataPattern.matcher(file.getAbsolutePath()).matches() || cvsmetadataPattern.matcher(file.getAbsolutePath()).matches() || gitmetadatapattern.matcher(file.getAbsolutePath()).matches();
    }

    static {
        String env;
        rp = new RequestProcessor(VcsVisibilityQueryImplementation.class.getName(), 1, false, false);
        SVN_ADMIN_DIR = Utilities.isWindows() ? ((env = System.getenv("SVN_ASP_DOT_NET_HACK")) != null ? "_svn" : "\\.svn") : "\\.svn";
        svnmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + SVN_ADMIN_DIR + "(\\" + File.separatorChar + ".*|$)");
        hgmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)hg(\\" + File.separatorChar + ".*|$)");
        cvsmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + "CVS(\\" + File.separatorChar + ".*|$)");
        gitmetadatapattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)git(\\" + File.separatorChar + ".*|$)");
    }

    private static class InvisibleFiles
    extends LinkedHashMap<File, Long> {
        public InvisibleFiles(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, Long> eldest) {
            return this.size() >= 500;
        }

        public void clearOldValues() {
            if (this.size() > 125) {
                Iterator it = this.entrySet().iterator();
                long threshold = System.currentTimeMillis() - 1800000L;
                while (it.hasNext() && (Long)it.next().getValue() < threshold) {
                    it.remove();
                }
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = null;
            boolean originalValue = false;
            HashMap hashMap = VcsVisibilityQueryImplementation.this.refreshedFiles;
            synchronized (hashMap) {
                Iterator it = VcsVisibilityQueryImplementation.this.refreshedFiles.entrySet().iterator();
                if (it.hasNext()) {
                    Map.Entry e = it.next();
                    file = (File)e.getKey();
                    originalValue = (Boolean)e.getValue();
                    it.remove();
                }
            }
            if (file == null) {
                return;
            }
            boolean visible = true;
            FileObject fo = (FileObject)VcsVisibilityQueryImplementation.this.fileObjects.remove(file);
            VersioningSystem system = VersioningManager.getInstance().getOwner(file, fo != null ? Boolean.valueOf(!fo.isFolder()) : null);
            if (system != null) {
                VCSVisibilityQuery vqi = system.getVisibilityQuery();
                visible = vqi == null ? true : vqi.isVisible(file);
            }
            InvisibleFiles invisibleFiles = VcsVisibilityQueryImplementation.this.cache;
            synchronized (invisibleFiles) {
                VcsVisibilityQueryImplementation.this.cache.remove(file);
                if (!visible) {
                    VcsVisibilityQueryImplementation.this.cache.put(file, System.currentTimeMillis());
                }
            }
            if (originalValue != visible) {
                VcsVisibilityQueryImplementation.this.vsChangedTask.schedule(1000);
            }
            VcsVisibilityQueryImplementation.this.refreshTask.schedule(0);
        }
    }

    private class VisibilityChangedTask
    implements Runnable {
        private VisibilityChangedTask() {
        }

        @Override
        public void run() {
            VcsVisibilityQueryImplementation.this.fireVisibilityChanged();
        }
    }
}

