/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import javax.faces.component.UIComponentBase;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.model.MenuModel;

public abstract class AbstractMenu
extends UIComponentBase {
    private static final String BUILT_FROM_MODEL_PARAM = "_builtFromModel";

    public void buildMenuFromModel() {
        MenuModel model = this.getModel();
        if (model != null) {
            for (Submenu submenu : model.getSubmenus()) {
                this.getChildren().add(submenu);
            }
            for (MenuItem menuItem : model.getMenuItems()) {
                this.getChildren().add(menuItem);
            }
            this.markAsBuiltFromModel();
        }
    }

    public abstract MenuModel getModel();

    public boolean isDynamic() {
        return this.getValueExpression("model") != null;
    }

    public boolean isBuiltFromModel() {
        return this.getFacesContext().getViewRoot().getViewMap().containsKey(this.getClientId() + BUILT_FROM_MODEL_PARAM);
    }

    public void markAsBuiltFromModel() {
        this.getFacesContext().getViewRoot().getViewMap().put(this.getClientId() + BUILT_FROM_MODEL_PARAM, true);
    }

    public boolean shouldBuildFromModel() {
        return this.isDynamic() && !this.isBuiltFromModel();
    }
}

