/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtext;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputtext.InputText;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputTextRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputText inputText = (InputText)component;
        if (inputText.isDisabled() || inputText.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputText);
        String clientId = inputText.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            inputText.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputText inputText = (InputText)component;
        this.encodeMarkup(context, inputText);
        this.encodeScript(context, inputText);
    }

    protected void encodeScript(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputText.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(inputText.resolveWidgetVar() + " = new PrimeFaces.widget.InputText({");
        writer.write("id:'" + clientId + "'");
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputText);
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputText.getClientId(context);
        String styleClass = inputText.getStyleClass();
        styleClass = styleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + styleClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)inputText);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)inputText, HTML.INPUT_TEXT_ATTRS);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        InputText inputText = (InputText)component;
        String value = (String)submittedValue;
        Converter converter = inputText.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)inputText, value);
        }
        ValueExpression ve = inputText.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)inputText, value);
            }
        }
        return value;
    }
}

