/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imagecompare;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.imagecompare.ImageCompare;
import org.primefaces.renderkit.CoreRenderer;

public class ImageCompareRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ImageCompare compare = (ImageCompare)component;
        this.encodeMarkup(facesContext, compare);
        this.encodeScript(facesContext, compare);
    }

    protected void encodeScript(FacesContext fc, ImageCompare compare) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = compare.getClientId(fc);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).beforeAfter({");
        writer.write("handle:'" + this.getResourceRequestPath(fc, "imagecompare/handle.gif") + "'");
        writer.write(",lt:'" + this.getResourceRequestPath(fc, "imagecompare/lt-small.png") + "'");
        writer.write(",rt:'" + this.getResourceRequestPath(fc, "imagecompare/rt-small.png") + "'");
        writer.write(",showFullLinks : false");
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, ImageCompare compare) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)compare);
        writer.writeAttribute("id", (Object)compare.getClientId(facesContext), "id");
        this.renderImage(facesContext, compare, "before", compare.getLeftImage());
        this.renderImage(facesContext, compare, "fter", compare.getRightImage());
        writer.endElement("div");
    }

    private void renderImage(FacesContext facesContext, ImageCompare compare, String type, String src) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)compare);
        writer.startElement("img", null);
        writer.writeAttribute("alt", (Object)type, null);
        writer.writeAttribute("src", (Object)this.getResourceURL(facesContext, src), null);
        writer.writeAttribute("width", (Object)compare.getWidth(), null);
        writer.writeAttribute("height", (Object)compare.getHeight(), null);
        writer.endElement("img");
        writer.endElement("div");
    }
}

