/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionItem;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileObjectFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ExtensionList;
import org.openide.util.Exceptions;

public class CsmIncludeCompletionQuery {
    private static final Collection<String> EXCLUDED_DIR_NAMES = Arrays.asList("CVS", ".hg", "nbproject", "SCCS", "SunWS_cache");
    private Map<String, CsmIncludeCompletionItem> results;
    private final CsmFile file;

    public CsmIncludeCompletionQuery(CsmFile file) {
        this.file = file;
    }

    public Collection<CsmIncludeCompletionItem> query(BaseDocument doc, String childSubDir, int substitutionOffset, Boolean usrInclude, boolean showAll) {
        FileSystem docFileSystem;
        this.results = new HashMap<String, CsmIncludeCompletionItem>(100);
        CsmFile docFile = this.file;
        if (docFile == null) {
            docFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        }
        try {
            docFileSystem = docFile.getFileObject().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return this.results.values();
        }
        Collection<Object> usrPaths = Collections.emptyList();
        Collection<Object> sysPaths = Collections.emptyList();
        if (CndPathUtilitities.isPathAbsolute((CharSequence)childSubDir)) {
            this.addFolderItems(FSPath.toFSPath((FileObject)docFileSystem.getRoot()), "", childSubDir, true, usrInclude != null ? usrInclude : false, true, substitutionOffset);
            return this.results.values();
        }
        if (docFile != null) {
            usrPaths = this.getFileIncludes(docFile, false);
            sysPaths = this.getFileIncludes(docFile, true);
        } else {
            FileObject baseFile = CsmUtilities.getFileObject((Document)doc);
            if (baseFile == null || !baseFile.isValid()) {
                return Collections.emptyList();
            }
        }
        FileObject usrDir = docFile.getFileObject().getParent();
        if (usrDir != null && usrDir.isValid()) {
            if (usrInclude == null || usrInclude == Boolean.TRUE) {
                this.addFolderItems(FSPath.toFSPath((FileObject)usrDir), ".", childSubDir, false, false, true, substitutionOffset);
                if (showAll) {
                    for (FSPath fSPath : usrPaths) {
                        this.addFolderItems(fSPath, fSPath.getPath(), childSubDir, false, false, true, substitutionOffset);
                    }
                    for (FSPath fSPath : sysPaths) {
                        this.addFolderItems(fSPath, fSPath.getPath(), childSubDir, false, true, false, substitutionOffset);
                    }
                }
                if (usrDir.getParent() != null) {
                    this.addParentFolder(substitutionOffset, childSubDir, false);
                }
            } else {
                for (FSPath fSPath : sysPaths) {
                    this.addFolderItems(fSPath, fSPath.getPath(), childSubDir, false, true, false, substitutionOffset);
                }
                if (showAll) {
                    for (FSPath fSPath : usrPaths) {
                        this.addFolderItems(fSPath, fSPath.getPath(), childSubDir, false, false, true, substitutionOffset);
                    }
                    this.addFolderItems(FSPath.toFSPath((FileObject)usrDir), ".", childSubDir, false, false, true, substitutionOffset);
                    if (usrDir.getParent() != null) {
                        this.addParentFolder(substitutionOffset, childSubDir, true);
                    }
                }
            }
        }
        return this.results.values();
    }

    private void addFolderItems(FSPath parentFolder, String parentFolderPresentation, String childSubDir, boolean highPriority, boolean system, boolean filtered, int substitutionOffset) {
        FileObject dir;
        FileObject parentFO = parentFolder.getFileObject();
        if (parentFO != null && (dir = parentFO.getFileObject(childSubDir)) != null && dir.isValid()) {
            FileObject[] list;
            FileObject[] fileObjectArray = list = filtered ? this.listFiles(dir, new HeadersFileFilter()) : this.listFiles(dir, new DefFileFilter());
            if (list != null) {
                for (FileObject curFile : list) {
                    String relFileName = curFile.getNameExt();
                    CsmIncludeCompletionItem item = CsmIncludeCompletionItem.createItem(substitutionOffset, relFileName, parentFolderPresentation, childSubDir, system, highPriority, curFile.isFolder(), true);
                    if (this.results.containsKey(relFileName)) continue;
                    this.results.put(relFileName, item);
                }
            }
        }
    }

    private FileObject[] listFiles(FileObject parent, FileObjectFilter filter) {
        FileObject[] children = parent.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>(children.length);
        for (FileObject child : children) {
            if (!filter.accept(child)) continue;
            result.add(child);
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private void addParentFolder(int substitutionOffset, String childSubDir, boolean system) {
        if (!this.results.isEmpty()) {
            CsmIncludeCompletionItem item = CsmIncludeCompletionItem.createItem(substitutionOffset, "..", ".", childSubDir, system, false, true, false);
            this.results.put("..", item);
        }
    }

    private Collection<FSPath> getFileIncludes(CsmFile file, boolean system) {
        CsmFileInfoQuery query = CsmFileInfoQuery.getDefault();
        return system ? query.getSystemIncludePaths(file) : query.getUserIncludePaths(file);
    }

    private static boolean isHeaderFileWoExt(FileObject pathname) {
        if (FileUtil.getExtension((String)pathname.getNameExt()).length() == 0) {
            return "text/x-h".equals(MIMESupport.getSourceFileMIMEType((FileObject)pathname));
        }
        return false;
    }

    private static boolean specialFile(FileObject file) {
        String name = file.getNameExt();
        if (name.startsWith(".")) {
            return true;
        }
        if (name.endsWith("~")) {
            return true;
        }
        return file.isFolder() && EXCLUDED_DIR_NAMES.contains(name);
    }

    private static final class HeadersFileFilter
    implements FileObjectFilter {
        private final ExtensionList exts = new ExtensionList();

        protected HeadersFileFilter() {
            for (String ext : MIMEExtensions.get((String)"text/x-h").getValues()) {
                this.exts.addExtension(ext);
            }
        }

        public boolean accept(FileObject pathname) {
            return !CsmIncludeCompletionQuery.specialFile(pathname) && (this.exts.isRegistered(pathname.getNameExt()) || pathname.isFolder() || CsmIncludeCompletionQuery.isHeaderFileWoExt(pathname));
        }
    }

    private static final class DefFileFilter
    implements FileObjectFilter {
        private DefFileFilter() {
        }

        public boolean accept(FileObject fileObject) {
            return !CsmIncludeCompletionQuery.specialFile(fileObject);
        }
    }
}

