/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class RemoteFileUrlMapper
extends URLMapper {
    public FileObject[] getFileObjects(URL url) {
        if (url.getProtocol().equals("rfs")) {
            ExecutionEnvironment env;
            String user = url.getUserInfo();
            if (user != null) {
                env = ExecutionEnvironmentFactory.createNew((String)user, (String)url.getHost(), (int)url.getPort());
            } else {
                RemoteLogger.assertTrue(false, "Trying to access remote file system without user name");
                env = RemoteFileSystemUtils.getExecutionEnvironment(url.getHost(), url.getPort());
                if (env == null && (user = System.getProperty("user.name")) != null) {
                    env = ExecutionEnvironmentFactory.createNew((String)user, (String)url.getHost(), (int)url.getPort());
                }
            }
            if (env != null) {
                RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
                RemoteFileObjectBase fo = fs.findResource(url.getFile());
                return new FileObject[]{fo};
            }
        }
        return null;
    }

    public URL getURL(FileObject fo, int type) {
        if (fo instanceof RemoteFileObjectBase) {
            RemoteFileObjectBase rfo = (RemoteFileObjectBase)fo;
            try {
                ExecutionEnvironment env = rfo.getExecutionEnvironment();
                return RemoteFileUrlMapper.getURL(env, rfo.getPath(), rfo.isFolder());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static URL getURL(ExecutionEnvironment env, String path, boolean folder) throws MalformedURLException {
        String host = env.getUser() + '@' + env.getHost();
        URL url = new URL("rfs", host, env.getSSHPort(), path);
        String ext = url.toExternalForm() + (folder ? "/" : "");
        return new URL(ext);
    }
}

