/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntrySftp;
import org.netbeans.modules.remote.impl.fs.DirectoryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryReaderSftp
implements DirectoryReader {
    private final ExecutionEnvironment execEnv;
    private final String remotePath;
    private List<DirEntry> entries = new ArrayList<DirEntry>();
    private final Object lock = new Object();

    public DirectoryReaderSftp(ExecutionEnvironment execEnv, String remotePath) {
        this.execEnv = execEnv;
        if (remotePath.length() == 0) {
            this.remotePath = "/";
        } else {
            if (!remotePath.startsWith("/")) {
                throw new IllegalArgumentException("path should be absolute: " + remotePath);
            }
            this.remotePath = remotePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DirEntry> getEntries() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDirectory() throws InterruptedException, CancellationException, ExecutionException {
        Future res = FileInfoProvider.ls((ExecutionEnvironment)this.execEnv, (String)this.remotePath);
        FileInfoProvider.StatInfo[] infos = (FileInfoProvider.StatInfo[])res.get();
        ArrayList<DirEntry> newEntries = new ArrayList<DirEntry>(infos.length);
        for (FileInfoProvider.StatInfo statInfo : infos) {
            newEntries.add(new DirEntrySftp(statInfo, statInfo.getName()));
        }
        Object object = this.lock;
        synchronized (object) {
            this.entries = newEntries;
        }
    }
}

