/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.openide.util.Exceptions;

public class DirEntrySftp
implements DirEntry {
    public final FileInfoProvider.StatInfo statInfo;
    private String cache;

    public DirEntrySftp(FileInfoProvider.StatInfo statInfo, String cache) {
        this.statInfo = statInfo;
        this.cache = cache;
    }

    public boolean canExecute(ExecutionEnvironment execEnv) {
        return this.statInfo.canExecute(execEnv);
    }

    public boolean canRead(ExecutionEnvironment execEnv) {
        return this.statInfo.canRead(execEnv);
    }

    public boolean canWrite(ExecutionEnvironment execEnv) {
        return this.statInfo.canWrite(execEnv);
    }

    public String getAccessAsString() {
        return this.statInfo.getAccessAsString();
    }

    public String getCache() {
        return this.cache;
    }

    public FileType getFileType() {
        if (this.statInfo.isDirectory()) {
            return FileType.Directory;
        }
        if (this.statInfo.isLink()) {
            return FileType.Symlink;
        }
        return FileType.File;
    }

    public String getLinkTarget() {
        return this.statInfo.getLinkTarget();
    }

    public String getName() {
        return this.statInfo.getName();
    }

    public long getSize() {
        return this.statInfo.getSize();
    }

    public boolean isDirectory() {
        return this.statInfo.isDirectory();
    }

    public boolean isLink() {
        return this.statInfo.isLink();
    }

    public boolean isPlainFile() {
        return !this.statInfo.isLink() && !this.statInfo.isDirectory();
    }

    public boolean isSameType(DirEntry other) {
        return this.isLink() == other.isLink() && this.isDirectory() == other.isDirectory();
    }

    public boolean isSameUser(DirEntry other) {
        if (other instanceof DirEntrySftp) {
            return this.statInfo.getUserId() == ((DirEntrySftp)other).statInfo.getUserId();
        }
        return false;
    }

    public boolean isSameLastModified(DirEntry other) {
        if (other instanceof DirEntrySftp) {
            return this.statInfo.getLastModified().equals(((DirEntrySftp)other).statInfo.getLastModified());
        }
        return false;
    }

    public Date getLastModified() {
        return this.statInfo.getLastModified();
    }

    public boolean isSameGroup(DirEntry other) {
        if (other instanceof DirEntrySftp) {
            return this.statInfo.getGropupId() == ((DirEntrySftp)other).statInfo.getGropupId();
        }
        return false;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String toExternalForm() {
        return DirEntrySftp.escape(this.cache) + ' ' + this.statInfo.toExternalForm();
    }

    public boolean isValid() {
        return true;
    }

    public static DirEntrySftp fromExternalForm(String externalForm) throws FormatException {
        try {
            int pos = externalForm.indexOf(32);
            if (pos < 1) {
                throw new FormatException("Wrong directory entry format: " + externalForm, false);
            }
            String cache = DirEntrySftp.unescape(externalForm.substring(0, pos));
            FileInfoProvider.StatInfo statInfo = FileInfoProvider.StatInfo.fromExternalForm((String)externalForm.substring(pos + 1));
            return new DirEntrySftp(statInfo, cache);
        }
        catch (Exception ex) {
            throw new FormatException("Wrong directory entry format: " + externalForm, ex);
        }
    }

    private static String escape(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace(" ", "\\ ");
            return text;
        }
    }

    private static String unescape(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace("\\ ", " ");
            return text;
        }
    }

    public String toString() {
        return this.statInfo.toString() + " (" + this.cache + ')' + (this.isValid() ? "[valid]" : "[invalid]");
    }
}

