/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.api.ui.AutocompletionProvider;
import org.netbeans.modules.remote.spi.AutocompletionProviderFactory;
import org.netbeans.modules.remote.util.ExecSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class FindBasedExecutablesCompletionProviderFactory
implements AutocompletionProviderFactory {
    public AutocompletionProvider newInstance(ExecutionEnvironment env) {
        try {
            return new Provider(env);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public boolean supports(ExecutionEnvironment env) {
        return ConnectionManager.getInstance().isConnectedTo(env);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Provider
    implements AutocompletionProvider {
        private String[] executables = null;
        private final FutureTask<String[]> fetchTask;

        private Provider(ExecutionEnvironment env) throws IOException {
            this.fetchTask = new FutureTask<String[]>(new Find(env));
            RequestProcessor.getDefault().post(this.fetchTask);
        }

        public List<String> autocomplete(String str) {
            if ("".equals(str)) {
                return Collections.emptyList();
            }
            if (this.executables == null) {
                try {
                    this.executables = this.fetchTask.get();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ArrayList<String> result = new ArrayList<String>();
            boolean found = false;
            for (String exec : this.executables) {
                if (exec.startsWith(str)) {
                    result.add(exec);
                    found = true;
                    continue;
                }
                if (found) break;
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class Find
        implements Callable<String[]> {
            private final ExecutionEnvironment env;

            private Find(ExecutionEnvironment env) {
                this.env = env;
            }

            @Override
            public String[] call() throws Exception {
                TreeSet<String> result = new TreeSet<String>();
                try {
                    NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
                    npb.setExecutable("/bin/sh").setArguments(new String[]{"-c", "find `echo $PATH|tr : ' '` -type f -perm -+x 2>/dev/null"});
                    ExecSupport.Status rc = ExecSupport.call(npb);
                    for (String s : rc.output) {
                        int idx = s.lastIndexOf(47) + 1;
                        if (idx <= 0) continue;
                        result.add(s.substring(idx));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result.toArray(new String[0]);
            }
        }
    }
}

