/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.dlight.annotationsupport.AnnotationBarManager;
import org.netbeans.modules.dlight.annotationsupport.AnnotationSupport;
import org.netbeans.modules.dlight.annotationsupport.FileAnnotationInfo;
import org.netbeans.modules.dlight.annotationsupport.LineAnnotationInfo;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricFormatter;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class AnnotatedSourceSupportImpl
implements AnnotatedSourceSupport {
    private static final Logger log = Logger.getLogger("dlight.annotationsupport");
    private static boolean checkedLogging = AnnotatedSourceSupportImpl.checkLogging();
    private static boolean logginIsOn;
    private HashMap<String, FileAnnotationInfo> activeAnnotations = new HashMap();
    private static AnnotatedSourceSupportImpl instance;

    public AnnotatedSourceSupportImpl() {
        AnnotationSupport.getInstance().addPropertyChangeListener(new ProfilerPropertyChangeListener());
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new EditorFileChangeListener());
    }

    protected static AnnotatedSourceSupportImpl getInstance() {
        if (instance == null) {
            instance = (AnnotatedSourceSupportImpl)Lookup.getDefault().lookup(AnnotatedSourceSupportImpl.class);
        }
        return instance;
    }

    private synchronized void preProcessAnnotations(SourceFileInfoDataProvider sourceFileInfoProvider, List<DataTableMetadata.Column> metrics, List<FunctionCallWithMetric> list, boolean lineAnnotations) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (FunctionCallWithMetric functionCall : list) {
            FileAnnotationInfo fileAnnotationInfo;
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.getSourceFileInfo((FunctionCall)functionCall);
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            String filePath = sourceFileInfo.getFileName();
            if (new File(filePath).exists()) {
                filePath = FileUtil.normalizePath((String)filePath);
            }
            if ((fileAnnotationInfo = this.activeAnnotations.get(filePath)) == null) {
                fileAnnotationInfo = new FileAnnotationInfo();
                fileAnnotationInfo.setFilePath(filePath);
                fileAnnotationInfo.setColumnNames(new String[metrics.size()]);
                fileAnnotationInfo.setMaxColumnWidth(new int[metrics.size()]);
                this.activeAnnotations.put(filePath, fileAnnotationInfo);
            }
            LineAnnotationInfo lineAnnotationInfo = new LineAnnotationInfo(fileAnnotationInfo);
            lineAnnotationInfo.setLine(sourceFileInfo.getLine());
            lineAnnotationInfo.setOffset(sourceFileInfo.getOffset());
            lineAnnotationInfo.setColumns(new String[metrics.size()]);
            lineAnnotationInfo.setNotFormattedColumns(new String[metrics.size()]);
            boolean below = true;
            int col = 0;
            for (DataTableMetadata.Column column : metrics) {
                String metricUName;
                String metricId = column.getColumnName();
                Object metricVal = functionCall.getMetricValue(metricId);
                String longFormattedMetricString = FunctionMetricFormatter.getLongFormattedValue((FunctionCallWithMetric)functionCall, (String)metricId);
                String metricValString = FunctionMetricFormatter.getFormattedValue((FunctionCallWithMetric)functionCall, (String)metricId);
                if (!metricValString.equals("0.0")) {
                    below = false;
                }
                lineAnnotationInfo.getColumns()[col] = metricValString;
                lineAnnotationInfo.getNotFormattedColumns()[col] = longFormattedMetricString;
                int metricValLength = metricValString.length();
                if (fileAnnotationInfo.getMaxColumnWidth()[col] < metricValLength) {
                    fileAnnotationInfo.getMaxColumnWidth()[col] = metricValLength;
                }
                fileAnnotationInfo.getColumnNames()[col] = metricUName = column.getColumnUName();
                ++col;
            }
            if (lineAnnotations && !below) {
                fileAnnotationInfo.addLineAnnotationInfo(lineAnnotationInfo);
            }
            if (lineAnnotations) continue;
            fileAnnotationInfo.addBlockAnnotationInfo(lineAnnotationInfo);
        }
    }

    public synchronized FileAnnotationInfo getFileAnnotationInfo(String filePath) {
        return this.activeAnnotations.get(filePath);
    }

    public synchronized void updateSource(SourceFileInfoDataProvider sourceFileInfoProvider, List<DataTableMetadata.Column> metrics, List<FunctionCallWithMetric> list, List<FunctionCallWithMetric> functionCalls) {
        HashSet<JEditorPane> previousAnnotatedPanes = new HashSet<JEditorPane>();
        if (this.activeAnnotations != null) {
            for (FileAnnotationInfo fileAnnotationInfo : this.activeAnnotations.values()) {
                if (!fileAnnotationInfo.isAnnotated()) continue;
                previousAnnotatedPanes.add(fileAnnotationInfo.getEditorPane());
            }
        }
        this.activeAnnotations = new HashMap();
        this.preProcessAnnotations(sourceFileInfoProvider, metrics, list, true);
        this.preProcessAnnotations(sourceFileInfoProvider, metrics, functionCalls, false);
        this.annotateCurrentFocusedFiles();
        for (FileAnnotationInfo fileAnnotationInfo : this.activeAnnotations.values()) {
            if (!fileAnnotationInfo.isAnnotated()) continue;
            previousAnnotatedPanes.remove(fileAnnotationInfo.getEditorPane());
        }
        for (JEditorPane pane : previousAnnotatedPanes) {
            new UnAnnotate(pane).run();
        }
    }

    private String fileFromEditorPane(JTextComponent jEditorPane) {
        Object source;
        String ret = null;
        if (jEditorPane != null && (source = jEditorPane.getDocument().getProperty("stream")) instanceof DataObject) {
            FileObject fo = ((DataObject)source).getPrimaryFile();
            ret = (String)SourceSupportProvider.FileObjectsToSourceMap.getInstance().get(fo);
            if (ret == null) {
                ret = (String)fo.getAttribute("URI");
            }
            if (ret == null && FileUtil.toFile((FileObject)fo) != null) {
                ret = FileUtil.toFile((FileObject)fo).getPath();
            }
            if (ret != null) {
                ret = FileUtil.normalizePath((String)ret);
            }
        }
        return ret;
    }

    private synchronized void annotateCurrentFocusedFiles() {
        FileAnnotationInfo fileAnnotationInfo;
        String fileURI;
        if (this.activeAnnotations.size() == 0) {
            return;
        }
        JTextComponent jEditorPane = EditorRegistry.focusedComponent();
        if (jEditorPane == null) {
            jEditorPane = EditorRegistry.lastFocusedComponent();
        }
        if (jEditorPane != null && (fileURI = this.fileFromEditorPane(jEditorPane)) != null && (fileAnnotationInfo = this.activeAnnotations.get(fileURI)) != null) {
            fileAnnotationInfo.setEditorPane((JEditorPane)jEditorPane);
            fileAnnotationInfo.setAnnotated(true);
            new Annotate(jEditorPane, fileAnnotationInfo).run();
        }
    }

    private void log(SourceFileInfoDataProvider sourceFileInfoProvider, List<DataTableMetadata.Column> metrics, List<FunctionCallWithMetric> functionCalls, boolean lineAnnotations) {
        if (!logginIsOn) {
            return;
        }
        log.fine("AnnotatedSourceSupportImpl.updateSource");
        log.finest("metrics:");
        for (DataTableMetadata.Column column : metrics) {
            log.finest("  getColumnLongUName " + column.getColumnLongUName());
            log.finest("  getColumnName " + column.getColumnName());
            log.finest("  getColumnUName " + column.getColumnUName());
            log.finest("  getExpression = " + column.getExpression());
            log.finest("");
        }
        log.finest("functionCalls:");
        for (FunctionCallWithMetric functionCall : functionCalls) {
            log.finest("  getDisplayedName " + functionCall.getDisplayedName());
            log.finest("  getFunction " + functionCall.getFunction());
            log.finest("  getFunction().getName() " + functionCall.getFunction().getName());
            log.finest("  getFunction().getQuilifiedName() " + functionCall.getFunction().getSignature());
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.getSourceFileInfo((FunctionCall)functionCall);
            if (sourceFileInfo != null) {
                if (sourceFileInfo.isSourceKnown()) {
                    log.finer(sourceFileInfo.getFileName() + "\n");
                }
                log.finer("  type=" + (lineAnnotations ? "Line" : "Block") + "\n");
                log.finer("  line=" + sourceFileInfo.getLine() + "\n");
                log.finer("  column=" + sourceFileInfo.getColumn() + "\n");
                log.finer("  offset=" + sourceFileInfo.getOffset() + "\n");
                for (DataTableMetadata.Column column : metrics) {
                    String metricId = column.getColumnName();
                    Object metricVal = functionCall.getMetricValue(metricId);
                    String metricUName = column.getColumnUName();
                    log.finer("  " + metricUName + "=" + metricVal + "\n");
                }
            }
            log.finest("  " + functionCall);
        }
    }

    private static boolean checkLogging() {
        if (checkedLogging) {
            return true;
        }
        logginIsOn = false;
        String logProp = System.getProperty("dlight.annotationsupport");
        if (logProp != null) {
            logginIsOn = true;
            if (logProp.equals("FINE")) {
                log.setLevel(Level.FINE);
            } else if (logProp.equals("FINER")) {
                log.setLevel(Level.FINER);
            } else if (logProp.equals("FINEST")) {
                log.setLevel(Level.FINEST);
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<String, FileAnnotationInfo> entry : this.activeAnnotations.entrySet()) {
            buf.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        return buf.toString();
    }

    static {
        instance = null;
    }

    private class ProfilerPropertyChangeListener
    implements PropertyChangeListener {
        private ProfilerPropertyChangeListener() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            block4: {
                String prop = evt.getPropertyName();
                if (!prop.equals("textAnnotationsVisible")) break block4;
                boolean annotate = AnnotationSupport.getInstance().getTextAnnotationVisible();
                if (annotate) {
                    for (FileAnnotationInfo fileAnnotationInfo : AnnotatedSourceSupportImpl.this.activeAnnotations.values()) {
                        if (!fileAnnotationInfo.isAnnotated()) continue;
                        new Annotate(fileAnnotationInfo.getEditorPane(), fileAnnotationInfo).run();
                    }
                } else {
                    for (FileAnnotationInfo fileAnnotationInfo : AnnotatedSourceSupportImpl.this.activeAnnotations.values()) {
                        if (!fileAnnotationInfo.isAnnotated()) continue;
                        new HideAnnotate(fileAnnotationInfo.getEditorPane()).run();
                    }
                }
            }
        }
    }

    private class EditorFileChangeListener
    implements PropertyChangeListener {
        private EditorFileChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("focusGained")) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AnnotatedSourceSupportImpl.this.annotateCurrentFocusedFiles();
                    }
                }, (String)"Annotate current focused file");
            }
        }
    }

    private static class Annotate
    implements Runnable {
        JTextComponent jEditorPane;
        FileAnnotationInfo fileAnnotationInfo;

        public Annotate(JTextComponent jEditorPane, FileAnnotationInfo fileAnnotationInfo) {
            this.jEditorPane = jEditorPane;
            this.fileAnnotationInfo = fileAnnotationInfo;
        }

        @Override
        public void run() {
            AnnotationBarManager.showAnnotationBar(this.jEditorPane, this.fileAnnotationInfo);
        }
    }

    private static class UnAnnotate
    implements Runnable {
        JTextComponent jEditorPane;

        public UnAnnotate(JTextComponent jEditorPane) {
            this.jEditorPane = jEditorPane;
        }

        @Override
        public void run() {
            AnnotationBarManager.unAnnotate(this.jEditorPane);
        }
    }

    private static class HideAnnotate
    implements Runnable {
        JTextComponent jEditorPane;

        public HideAnnotate(JTextComponent jEditorPane) {
            this.jEditorPane = jEditorPane;
        }

        @Override
        public void run() {
            AnnotationBarManager.hideAnnotationBar(this.jEditorPane);
        }
    }
}

